/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.cv;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.imageio.netcdf.cv.CoordinateHandlerSpi;
import org.geotools.util.Utilities;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.logging.Logging;
import ucar.nc2.dataset.CoordinateAxis;

public final class CoordinateHandlerFinder {
    private static final Logger LOGGER = Logging.getLogger(CoordinateHandlerFinder.class);
    private static volatile FactoryRegistry registry;

    private CoordinateHandlerFinder() {
    }

    public static synchronized Set<CoordinateHandlerSpi> getAvailableHandlers() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Coordinate Handlers scan");
        }
        CoordinateHandlerFinder.scanForPlugins();
        return (Set)CoordinateHandlerFinder.getServiceRegistry().getFactories(CoordinateHandlerSpi.class, true).collect(Utilities.toUnmodifiableSet());
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(CoordinateHandlerFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(CoordinateHandlerSpi.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        CoordinateHandlerFinder.getServiceRegistry().scanForPlugins();
    }

    public static synchronized Set<CoordinateHandlerSpi.CoordinateHandler> findHandlers(CoordinateAxis axis) {
        Set<CoordinateHandlerSpi> availableHandlersSpi = CoordinateHandlerFinder.getAvailableHandlers();
        HashSet<CoordinateHandlerSpi.CoordinateHandler> handlers = new HashSet<CoordinateHandlerSpi.CoordinateHandler>();
        for (CoordinateHandlerSpi spi : availableHandlersSpi) {
            if (!spi.canHandle(axis)) continue;
            handlers.add(spi.createHandler());
        }
        return Collections.unmodifiableSet(handlers);
    }

    public static synchronized CoordinateHandlerSpi.CoordinateHandler findHandler(CoordinateAxis axis) {
        Set<CoordinateHandlerSpi.CoordinateHandler> formats = CoordinateHandlerFinder.findHandlers(axis);
        Iterator<CoordinateHandlerSpi.CoordinateHandler> it = formats.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }
}

