/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import it.geosolutions.imageio.stream.AccessibleStream;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.imageio.netcdf.NetCDFImageReader;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.logging.Logging;

public class NetCDFImageReaderSpi
extends ImageReaderSpi {
    public static final Class<?>[] STANDARD_INPUT_TYPES = new Class[]{AccessibleStream.class, ImageInputStream.class, File.class, URL.class, URI.class};
    public static final String VENDOR_NAME = "GeoTools";
    private static final Logger LOGGER = Logging.getLogger(NetCDFImageReaderSpi.class);
    static final String[] suffixes;
    static final String[] formatNames;
    static final String[] MIMETypes;
    static final String version = "1.0";
    static final String readerCN = "it.geosolutions.imageio.plugins.netcdf.NetCDFImageReader";
    static final String[] wSN;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName;
    static final String nativeStreamMetadataFormatClassName;
    static final String[] extraStreamMetadataFormatNames;
    static final String[] extraStreamMetadataFormatClassNames;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName;
    static final String nativeImageMetadataFormatClassName;
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;

    public NetCDFImageReaderSpi() {
        super(VENDOR_NAME, version, formatNames, suffixes, MIMETypes, readerCN, STANDARD_INPUT_TYPES, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        LOGGER.fine("NetCDFImageReaderSpi Constructor");
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new NetCDFImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return new StringBuffer("NetCDF-CF Image Reader, version ").append(version).toString();
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        URI input = null;
        if (source instanceof URI) {
            input = (URI)source;
        } else if (source instanceof File) {
            input = ((File)source).toURI();
        } else if (source instanceof FileImageInputStreamExtImpl) {
            input = ((FileImageInputStreamExtImpl)source).getFile().toURI();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found a valid FileImageInputStream");
            }
        } else if (source instanceof URIImageInputStream) {
            input = ((URIImageInputStream)source).getUri();
        }
        if (input != null) {
            return NetCDFUtilities.getFormat(input) != NetCDFUtilities.FileFormat.NONE;
        }
        return false;
    }

    static {
        wSN = new String[]{null};
        nativeStreamMetadataFormatName = null;
        nativeStreamMetadataFormatClassName = null;
        extraStreamMetadataFormatNames = new String[]{null};
        extraStreamMetadataFormatClassNames = new String[]{null};
        nativeImageMetadataFormatName = null;
        nativeImageMetadataFormatClassName = null;
        extraImageMetadataFormatNames = new String[]{null};
        extraImageMetadataFormatClassNames = new String[]{null};
        ArrayList suffixesList = new ArrayList();
        Collections.addAll(suffixesList, "nc", "NC");
        Collections.addAll(suffixesList, "ncml", "NCML");
        ArrayList formatNamesList = new ArrayList();
        Collections.addAll(formatNamesList, "netcdf", "NetCDF", "NetCDF-3");
        ArrayList mimeTypesList = new ArrayList();
        Collections.addAll(mimeTypesList, "application/x-netcdf", "image/netcdf", "image/x-netcdf", "image/x-nc");
        if (NetCDFUtilities.isGribAvailable()) {
            Collections.addAll(suffixesList, "grib", "grib2", "grb", "grb2");
            Collections.addAll(formatNamesList, "grib", "grib2", "GRIB", "GRIB2");
            Collections.addAll(mimeTypesList, "application/octet-stream");
        }
        if (NetCDFUtilities.isNC4CAvailable()) {
            Collections.addAll(formatNamesList, "NetCDF-4C", "NetCDF-4");
            Collections.addAll(mimeTypesList, "application/x-netcdf4");
        }
        suffixes = suffixesList.toArray(new String[suffixesList.size()]);
        formatNames = formatNamesList.toArray(new String[formatNamesList.size()]);
        MIMETypes = mimeTypesList.toArray(new String[mimeTypesList.size()]);
    }
}

