/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

class TemporalConverterFactoryHack
implements ConverterFactory {
    private static final Converter DATE_STRING = new Converter(){

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source instanceof Date) {
                return (T)TemporalConverterFactoryHack.getDateFormat().format((Date)source);
            }
            return null;
        }
    };
    private static final Converter CALENDAR_STRING = new Converter(){

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source instanceof Calendar) {
                return (T)TemporalConverterFactoryHack.getDateFormat().format(((Calendar)source).getTime());
            }
            return null;
        }
    };
    private static final Converter XML_CALENDAR_STRING = new Converter(){

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source instanceof XMLGregorianCalendar) {
                GregorianCalendar date = ((XMLGregorianCalendar)source).toGregorianCalendar(TimeZone.getTimeZone("GMT"), Locale.getDefault(), null);
                return (T)TemporalConverterFactoryHack.getDateFormat().format(date.getTime());
            }
            return null;
        }
    };

    TemporalConverterFactoryHack() {
    }

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    public Converter createConverter(Class source, Class target, Hints hints) {
        if (Date.class.isAssignableFrom(source) && String.class.equals((Object)target)) {
            return DATE_STRING;
        }
        if (Calendar.class.isAssignableFrom(source) && String.class.equals((Object)target)) {
            return CALENDAR_STRING;
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(source) && String.class.equals((Object)target)) {
            return XML_CALENDAR_STRING;
        }
        return null;
    }
}

