/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.io.netcdf.NetCDFReader;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public class NetCDFFormat
extends AbstractGridFormat {
    public static final ParameterDescriptor<Filter> FILTER = new DefaultParameterDescriptor("Filter", Filter.class, null, null);
    private static final Logger LOGGER = Logging.getLogger(NetCDFFormat.class);

    public NetCDFFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "NetCDF");
        info.put("description", "NetCDF store plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, TIME, ELEVATION, FILTER, BANDS}));
        this.writeParameters = null;
    }

    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        try {
            NetCDFReader reader = new NetCDFReader(source, hints);
            return reader;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("Writing operation not implemented");
    }

    public boolean accepts(Object source, Hints hints) {
        File file = null;
        if (source instanceof URL) {
            file = URLs.urlToFile((URL)((URL)source));
        } else if (source instanceof File) {
            file = (File)source;
        }
        if (file != null) {
            if (file.isDirectory()) {
                return false;
            }
            String absolutePath = file.getAbsolutePath();
            if (absolutePath.endsWith("nc") || absolutePath.endsWith("ncml")) {
                return true;
            }
        }
        return false;
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Writing operation not implemented");
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("Writing operation not implemented");
    }
}

