/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.FileSetManager;
import org.geotools.coverage.io.CoverageAccess;
import org.geotools.coverage.io.CoverageSource;
import org.geotools.coverage.io.Driver;
import org.geotools.coverage.io.impl.DefaultFileCoverageAccess;
import org.geotools.coverage.io.impl.DefaultFileDriver;
import org.geotools.coverage.io.netcdf.NetCDFDriver;
import org.geotools.coverage.io.netcdf.NetCDFSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.Parameter;
import org.geotools.data.Repository;
import org.geotools.data.ServiceInfo;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.NameImpl;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.imageio.GeoSpatialImageReader;
import org.geotools.imageio.netcdf.NetCDFImageReader;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;
import org.opengis.util.ProgressListener;

public class NetCDFAccess
extends DefaultFileCoverageAccess
implements CoverageAccess,
FileSetManager {
    private static final Logger LOGGER = Logging.getLogger(NetCDFAccess.class);
    private Exception tracer;
    GeoSpatialImageReader reader = null;

    NetCDFAccess(Driver driver, URL source, Map<String, Serializable> additionalParameters, Hints hints, ProgressListener listener) throws DataSourceException {
        super(driver, EnumSet.of(CoverageAccess.AccessType.READ_ONLY), (Map)new HashMap<String, Parameter<?>>(){
            {
                this.put(DefaultFileDriver.URL.key, DefaultFileDriver.URL);
            }
        }, source, additionalParameters);
        String protocol = source.getProtocol();
        if (!(protocol.equalsIgnoreCase("file") || protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("dods"))) {
            throw new DataSourceException("Wrong protocol for URL:" + source.toExternalForm().toString());
        }
        File sourceFile = null;
        if (!(!protocol.equalsIgnoreCase("file") || (sourceFile = URLs.urlToFile((URL)source)).exists() && sourceFile.isFile() && sourceFile.canRead())) {
            throw new DataSourceException("Invalid source");
        }
        try {
            this.reader = (NetCDFImageReader)((Object)NetCDFDriver.SPI.createReaderInstance());
            this.setAuxiliaryEntries(hints);
            this.reader.setInput((Object)this.source);
            if (this.names == null) {
                this.names = new ArrayList();
                Collection originalNames = this.reader.getCoveragesNames();
                for (Name name : originalNames) {
                    NameImpl coverageName = new NameImpl(name.toString());
                    this.names.add(coverageName);
                }
            }
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
        if (NetCDFUtilities.TRACE_ENABLED.booleanValue()) {
            this.tracer = new Exception();
            this.tracer.fillInStackTrace();
        }
    }

    private void setAuxiliaryEntries(Hints hints) {
        Object prefix = "";
        if (hints != null) {
            String filePath;
            if (hints.containsKey((Object)Utils.PARENT_DIR)) {
                prefix = (String)hints.get((Object)Utils.PARENT_DIR) + File.separatorChar;
            }
            if (hints.containsKey((Object)Utils.AUXILIARY_FILES_PATH)) {
                filePath = (String)hints.get((Object)Utils.AUXILIARY_FILES_PATH);
                filePath = this.makeAbsolute((String)prefix, filePath);
                this.reader.setAuxiliaryFilesPath(filePath);
            }
            if (hints.containsKey((Object)Utils.AUXILIARY_DATASTORE_PATH)) {
                filePath = (String)hints.get((Object)Utils.AUXILIARY_DATASTORE_PATH);
                filePath = this.makeAbsolute((String)prefix, filePath);
                this.reader.setAuxiliaryDatastorePath(filePath);
            }
            if (hints.containsKey((Object)Hints.REPOSITORY)) {
                this.reader.setRepository((Repository)hints.get((Object)Hints.REPOSITORY));
            }
        }
    }

    private String makeAbsolute(String prefix, String filePath) {
        if (!Paths.get((String)filePath, new String[0]).isAbsolute()) {
            filePath = prefix + (String)filePath;
        }
        return filePath;
    }

    public boolean delete(Name name, Map<String, Serializable> params, Hints hints) throws IOException {
        return this.names.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverageSource access(Name name, Map<String, Serializable> params, CoverageAccess.AccessType accessType, Hints hints, ProgressListener listener) throws IOException {
        if (listener == null) {
            listener = new NullProgressListener();
        }
        listener.started();
        try {
            NetCDFSource netCDFSource = new NetCDFSource((NetCDFImageReader)this.reader, name);
            return netCDFSource;
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to access the NetCDF source", e);
            listener.exceptionOccurred(e);
            CoverageSource coverageSource = null;
            return coverageSource;
        }
        finally {
            listener.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getInfo(ProgressListener listener) {
        if (listener == null) {
            listener = new NullProgressListener();
        }
        listener.started();
        DefaultServiceInfo info = new DefaultServiceInfo();
        List coverageNames = this.getNames(listener);
        Iterator namesIterator = coverageNames.iterator();
        if (namesIterator.hasNext()) {
            info.setTitle(((Name)namesIterator.next()).toString());
        }
        try {
            info.setSource(this.source.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        finally {
            listener.complete();
        }
        return info;
    }

    public void dispose() {
        super.dispose();
        if (this.reader != null) {
            try {
                this.reader.dispose();
                this.reader = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.reader != null) {
            LOGGER.warning("There is code leaving netcdf readers open, this might cause issues with file deletion on Windows!");
            if (NetCDFUtilities.TRACE_ENABLED.booleanValue()) {
                LOGGER.log(Level.WARNING, "The unclosed reader originated on this stack trace", this.tracer);
            }
            this.dispose();
        }
    }

    public void addFile(String filePath) {
        this.reader.addFile(filePath);
    }

    public List<String> list() {
        return this.reader.list();
    }

    public void removeFile(String filePath) {
        this.reader.removeFile(filePath);
    }

    public void purge() {
        this.reader.purge();
    }
}

