/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import it.geosolutions.imageio.imageioimpl.EnhancedImageReadParam;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.FileSetManager;
import org.geotools.coverage.io.catalog.CoverageSlicesCatalog;
import org.geotools.coverage.io.catalog.DataStoreConfiguration;
import org.geotools.coverage.io.range.FieldType;
import org.geotools.coverage.io.range.RangeType;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.imageio.GeoSpatialImageReader;
import org.geotools.imageio.netcdf.AncillaryFileManager;
import org.geotools.imageio.netcdf.MultipleBandsDimensionInfo;
import org.geotools.imageio.netcdf.NetCDFGeoreferenceManager;
import org.geotools.imageio.netcdf.NetCDFImageMetadata;
import org.geotools.imageio.netcdf.Slice2DIndex;
import org.geotools.imageio.netcdf.VariableAdapter;
import org.geotools.imageio.netcdf.cv.CoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.SampleDimension;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class NetCDFImageReader
extends GeoSpatialImageReader
implements FileSetManager {
    private static final int INTERNAL_INDEX_CREATION_PAGE_SIZE = 1000;
    private static final Logger LOGGER = Logging.getLogger(NetCDFImageReader.class);
    private Exception tracer;
    AncillaryFileManager ancillaryFileManager;
    final List<Name> coverages = new ArrayList<Name>();
    private RasterLayerRequest imageMosaicRequest;
    private NetcdfDataset dataset;
    NetCDFGeoreferenceManager georeferencing;
    private NetCDFUtilities.CheckType checkType = NetCDFUtilities.CheckType.UNSET;
    boolean uniqueTimeAttribute = false;
    private ImageInputStream imageInputStream = null;
    private final SoftValueHashMap<String, VariableAdapter> coverageSourceDescriptorsCache = new SoftValueHashMap();

    public void setRasterLayerRequest(RasterLayerRequest request) {
        this.imageMosaicRequest = request;
    }

    public RasterLayerRequest getImageMosaicRequest() {
        return this.imageMosaicRequest;
    }

    public List<Name> getCoveragesNames() {
        return Collections.unmodifiableList(this.coverages);
    }

    public int getCoveragesNumber() {
        return this.coverages.size();
    }

    public NetCDFImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
        if (NetCDFUtilities.TRACE_ENABLED.booleanValue()) {
            this.tracer = new Exception();
            this.tracer.fillInStackTrace();
        }
    }

    private NetcdfDataset extractDataset(Object input) throws IOException {
        URL tempURL;
        String protocol;
        NetcdfDataset dataset = null;
        if (input instanceof URIImageInputStream) {
            URIImageInputStream uriInStream = (URIImageInputStream)input;
            dataset = NetCDFUtilities.acquireDataset(uriInStream.getUri());
        } else if (input instanceof URL && ((protocol = (tempURL = (URL)input).getProtocol()).equalsIgnoreCase("http") || protocol.equalsIgnoreCase("dods"))) {
            try {
                dataset = NetCDFUtilities.acquireDataset(tempURL.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        if (dataset == null) {
            dataset = NetCDFUtilities.getDataset(input);
        }
        return dataset;
    }

    protected void setNumImages(int numImages) {
        if (numImages <= 0) {
            throw new IllegalArgumentException("Number of Images is negative: " + numImages);
        }
        if (this.numImages == -1) {
            this.numImages = numImages;
        }
    }

    public int getHeight(int imageIndex) throws IOException {
        VariableAdapter wrapper = this.getCoverageDescriptor(imageIndex);
        if (wrapper != null) {
            return wrapper.getHeight();
        }
        return -1;
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        VariableAdapter wrapper = this.getCoverageDescriptor(imageIndex);
        if (wrapper != null) {
            SampleModel sampleModel = wrapper.getSampleModel();
            ImageTypeSpecifier imageType = new ImageTypeSpecifier(ImageIOUtilities.createColorModel((SampleModel)sampleModel), sampleModel);
            l.add(imageType);
        }
        return l.iterator();
    }

    public int getWidth(int imageIndex) throws IOException {
        VariableAdapter wrapper = this.getCoverageDescriptor(imageIndex);
        if (wrapper != null) {
            return wrapper.getWidth();
        }
        return -1;
    }

    public Variable getVariableByName(String varName) {
        List varList = this.dataset.getVariables();
        for (Variable var : varList) {
            if (!var.getFullName().equals(varName)) continue;
            return var;
        }
        return null;
    }

    public void reset() {
        super.setInput(null, false, false);
        this.dispose();
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (this.dataset != null) {
            this.reset();
        }
        if (input instanceof ImageInputStream) {
            this.imageInputStream = (ImageInputStream)input;
        }
        try {
            this.dataset = this.extractDataset(input);
            this.file = NetCDFUtilities.getFile(input);
            if (this.file != null) {
                this.ancillaryFileManager = new AncillaryFileManager(this.file, this.getAuxiliaryFilesPath(), this.getAuxiliaryDatastorePath());
            }
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int initIndex() throws InvalidRangeException, IOException {
        DefaultTransaction transaction = new DefaultTransaction("indexTransaction" + System.nanoTime());
        int numImages = 0;
        try {
            DataStoreConfiguration datastoreConfig = this.ancillaryFileManager.getDatastoreConfiguration();
            boolean isShared = datastoreConfig.isShared();
            this.initCatalog(datastoreConfig);
            List variables = this.dataset.getVariables();
            if (variables != null) {
                for (Variable var_ : variables) {
                    VariableDS variable;
                    String varName;
                    if (var_ == null || !(var_ instanceof VariableDS) || !this.ancillaryFileManager.acceptsVariable(varName = (variable = (VariableDS)var_).getFullName()) || !NetCDFUtilities.isVariableAccepted((Variable)variable, this.checkType, this.dataset)) continue;
                    Name coverageName = this.getCoverageName(varName);
                    CoordinateSystem cs = NetCDFCRSUtilities.getCoordinateSystem(variable);
                    SimpleFeatureType indexSchema = this.getIndexSchema(coverageName, cs, isShared);
                    VariableAdapter vaAdapter = this.getCoverageDescriptor(coverageName);
                    if (indexSchema == null) {
                        throw new IllegalStateException("Unable to created index schema for coverage:" + String.valueOf(coverageName));
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Collecting slices for: " + String.valueOf(coverageName));
                    }
                    int variableImageStartIndex = numImages;
                    int numberOfSlices = vaAdapter.getNumberOfSlices();
                    numImages += numberOfSlices;
                    int startPagingIndex = 0;
                    int limit = 1000;
                    ListFeatureCollection collection = new ListFeatureCollection(indexSchema);
                    int processedSlices = 0;
                    while (processedSlices < numberOfSlices) {
                        int features;
                        processedSlices += vaAdapter.getFeatures(startPagingIndex, 1000, collection);
                        if (variableImageStartIndex != 0 || isShared) {
                            this.updateFeaturesIndex(collection, variableImageStartIndex, isShared);
                        }
                        if ((features = collection.size()) <= 0) continue;
                        CoverageSlicesCatalog catalog = this.getCatalog();
                        if (catalog != null) {
                            catalog.addGranules(indexSchema.getTypeName(), (SimpleFeatureCollection)collection, (Transaction)transaction);
                        }
                        collection.clear();
                        startPagingIndex += features;
                    }
                }
            }
            this.ancillaryFileManager.writeToDisk();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Committing changes to the DB");
            }
            transaction.commit();
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rollback");
            }
            if (transaction != null) {
                transaction.rollback();
            }
            throw new IOException(e);
        }
        finally {
            try {
                if (transaction != null) {
                    transaction.close();
                }
            }
            catch (Throwable datastoreConfig) {}
        }
        return numImages;
    }

    private void updateFeaturesIndex(ListFeatureCollection collection, int offset, boolean isShared) throws IOException {
        try (SimpleFeatureIterator featuresIt = collection.features();){
            while (featuresIt.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featuresIt.next();
                Integer index = (Integer)feature.getAttribute("imageindex");
                if (isShared) {
                    feature.setAttribute("location", (Object)this.file.getCanonicalPath());
                }
                feature.setAttribute("imageindex", (Object)(index + offset));
            }
        }
    }

    private Name getCoverageName(String varName) {
        Name coverageName = this.ancillaryFileManager.getCoverageName(varName);
        if (coverageName == null) {
            this.ancillaryFileManager.addCoverage(varName);
            coverageName = new NameImpl(varName);
        }
        this.coverages.add(coverageName);
        return coverageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SoftValueHashMap<String, VariableAdapter> softValueHashMap = this.coverageSourceDescriptorsCache;
        synchronized (softValueHashMap) {
            this.coverageSourceDescriptorsCache.clear();
        }
        super.dispose();
        this.checkType = NetCDFUtilities.CheckType.UNSET;
        this.georeferencing.dispose();
        this.numImages = -1;
        try {
            if (this.dataset != null) {
                this.dataset.close();
            }
            if (this.ancillaryFileManager != null) {
                this.ancillaryFileManager.dispose();
            }
            if (this.imageInputStream != null) {
                this.imageInputStream.close();
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Errors closing NetCDF dataset." + e.getLocalizedMessage());
            }
        }
        finally {
            this.dataset = null;
            this.ancillaryFileManager = null;
            this.imageInputStream = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.numImages > 0) {
            LOGGER.warning("There is code leaving netcdf image readers open, this might cause issues with file deletion on Windows!");
            if (NetCDFUtilities.TRACE_ENABLED.booleanValue()) {
                LOGGER.log(Level.WARNING, "The unclosed image reader originated on this stack trace", this.tracer);
            }
            this.dispose();
        }
    }

    private void init() throws IOException {
        int numImages;
        block8: {
            numImages = 0;
            try {
                if (this.dataset != null) {
                    this.checkType = NetCDFUtilities.getCheckType(this.dataset);
                    this.georeferencing = new NetCDFGeoreferenceManager(this.dataset);
                    File slicesIndexFile = this.ancillaryFileManager.getSlicesIndexFile();
                    this.uniqueTimeAttribute = this.ancillaryFileManager.getParameterAsBoolean("uniqueTimeAttribute");
                    if (slicesIndexFile != null) {
                        if (slicesIndexFile.exists()) {
                            this.ancillaryFileManager.initSliceManager();
                            numImages = this.ancillaryFileManager.slicesIndexManager.getNumberOfRecords();
                            if (!this.ignoreMetadata) {
                                this.coverages.addAll(this.ancillaryFileManager.getCoveragesNames());
                                DataStoreConfiguration datastoreConfiguration = this.ancillaryFileManager.getDatastoreConfiguration();
                                this.settingTypeNames(datastoreConfiguration);
                                this.initCatalog(datastoreConfiguration);
                            }
                        }
                        if (numImages <= 0 || !slicesIndexFile.exists()) {
                            this.ancillaryFileManager.resetSliceManager();
                            numImages = this.initIndex();
                            this.ancillaryFileManager.initSliceManager();
                            numImages = this.ancillaryFileManager.slicesIndexManager.getNumberOfRecords();
                        }
                    } else {
                        numImages = this.initIndex();
                    }
                    break block8;
                }
                throw new IllegalArgumentException("No valid NetCDF dataset has been found");
            }
            catch (InvalidRangeException e) {
                throw new IllegalArgumentException("Exception occurred during NetCDF file parsing", e);
            }
        }
        this.setNumImages(numImages);
    }

    private void settingTypeNames(DataStoreConfiguration datastoreConfiguration) {
        Map params = datastoreConfiguration.getParams();
        List<Name> coverages = this.ancillaryFileManager.getCoveragesNames();
        StringBuilder builder = new StringBuilder();
        for (Name coverage : coverages) {
            builder.append(this.ancillaryFileManager.getTypeName(coverage.getLocalPart())).append(",");
        }
        String typeNames = builder.toString();
        typeNames = typeNames.substring(0, typeNames.length() - 1);
        params.put("TypeName", typeNames);
    }

    protected IIOException netcdfFailure(Exception e) throws IOException {
        return new IIOException("Can't read file " + this.dataset.getLocation(), e);
    }

    public Slice2DIndex getSlice2DIndex(int imageIndex) throws IOException {
        return this.ancillaryFileManager.getSlice2DIndex(imageIndex);
    }

    protected VariableAdapter getCoverageDescriptor(int imageIndex) {
        block3: {
            this.checkImageIndex(imageIndex);
            try {
                Slice2DIndex slice2DIndex = this.getSlice2DIndex(imageIndex);
                if (slice2DIndex != null) {
                    return this.getCoverageDescriptor((Name)new NameImpl(slice2DIndex.getVariableName()));
                }
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableAdapter getCoverageDescriptor(Name name) {
        Utilities.ensureNonNull((String)"name", (Object)name);
        String name_ = name.toString();
        SoftValueHashMap<String, VariableAdapter> softValueHashMap = this.coverageSourceDescriptorsCache;
        synchronized (softValueHashMap) {
            VariableAdapter cd;
            if (this.coverageSourceDescriptorsCache.containsKey((Object)name_)) {
                return (VariableAdapter)((Object)this.coverageSourceDescriptorsCache.get((Object)name_));
            }
            try {
                String origName;
                String string = origName = this.ancillaryFileManager.variablesMap != null ? this.ancillaryFileManager.variablesMap.get(name) : null;
                if (origName == null) {
                    origName = name.getLocalPart();
                }
                cd = new VariableAdapter(this, name, (VariableDS)this.getVariableByName(origName));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.coverageSourceDescriptorsCache.put((Object)name_, (Object)cd);
            return cd;
        }
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        int[] dstBands;
        int strideY;
        int strideX;
        this.clearAbortRequest();
        Slice2DIndex slice2DIndex = this.getSlice2DIndex(imageIndex);
        String variableName = slice2DIndex.getVariableName();
        VariableAdapter wrapper = this.getCoverageDescriptor((Name)new NameImpl(variableName));
        int[] bands = null;
        if (param instanceof EnhancedImageReadParam) {
            bands = ((EnhancedImageReadParam)param).getBands();
        }
        if (param != null) {
            strideX = param.getSourceXSubsampling();
            strideY = param.getSourceYSubsampling();
            dstBands = param.getDestinationBands();
        } else {
            strideX = 1;
            strideY = 1;
            dstBands = null;
        }
        int width = wrapper.getWidth();
        int height = wrapper.getHeight();
        Rectangle srcRegion = new Rectangle();
        Rectangle destRegion = new Rectangle();
        NetCDFImageReader.computeRegions((ImageReadParam)param, (int)width, (int)height, null, (Rectangle)srcRegion, (Rectangle)destRegion);
        if (this.georeferencing.isNeedsFlipping()) {
            NetCDFImageReader.flipVertically(param, height, srcRegion);
        }
        int destWidth = destRegion.x + destRegion.width;
        int destHeight = destRegion.y + destRegion.height;
        LinkedList<Range> ranges = new LinkedList<Range>();
        try {
            int first;
            int i;
            if (!wrapper.ignoredDimensions.isEmpty()) {
                for (int i2 = 0; i2 < wrapper.ignoredDimensions.size(); ++i2) {
                    ranges.add(new Range(0, 0, 1));
                }
            }
            for (i = 0; i < slice2DIndex.getNCount(); ++i) {
                first = slice2DIndex.getNIndex(i);
                if (first == -1) continue;
                ranges.add(new Range(first, first, 1));
            }
            for (i = 0; i < slice2DIndex.getNCount(); ++i) {
                first = slice2DIndex.getNIndex(i);
                int index = wrapper.getNDimensionIndex(i);
                if (first == -1 || index == -1) continue;
                ranges.set(index, new Range(first, first, 1));
            }
            first = srcRegion.y;
            int length = srcRegion.height;
            int stride = strideY;
            ranges.add(new Range(first, first + length - 1, stride));
            first = srcRegion.x;
            length = srcRegion.width;
            stride = strideX;
            ranges.add(new Range(first, first + length - 1, stride));
        }
        catch (InvalidRangeException e) {
            throw this.netcdfFailure((Exception)((Object)e));
        }
        Section section = new Section(ranges);
        int numDstBands = 1;
        String candidateDimension = ((Dimension)wrapper.variableDS.getDimensions().get(0)).getFullName();
        MultipleBandsDimensionInfo multipleBands = this.ancillaryFileManager.getMultipleBandsDimensionInfo(candidateDimension);
        if (multipleBands != null) {
            numDstBands = multipleBands.getNumberOfBands();
            if (bands != null) {
                int maxSourceBand = Arrays.stream(bands).max().getAsInt();
                if (maxSourceBand > numDstBands) {
                    throw new IllegalArgumentException("The provided source bands parameter is invalid.");
                }
                numDstBands = bands.length;
            }
        }
        BandedSampleModel sampleModel = new BandedSampleModel(wrapper.getSampleModel().getDataType(), destWidth, destHeight, numDstBands);
        ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
        BufferedImage image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), this.getNoDataProperties(wrapper));
        CoordinateSystem cs = (CoordinateSystem)wrapper.variableDS.getCoordinateSystems().get(0);
        CoordinateAxis axis = this.georeferencing.isLonLat() ? cs.getLatAxis() : cs.getYaxis();
        boolean flipYAxis = this.needFlipYAxis(axis);
        this.processImageStarted(imageIndex);
        float toPercent = 100.0f / (float)numDstBands;
        int type = raster.getSampleModel().getDataType();
        int xmin = destRegion.x;
        int ymin = destRegion.y;
        int xmax = destRegion.width + xmin;
        int ymax = destRegion.height + ymin;
        for (int zi = 0; zi < numDstBands; ++zi) {
            int dstBand;
            int n = dstBand = dstBands == null ? zi : dstBands[zi];
            if (multipleBands != null) {
                try {
                    int sourceBand = bands == null ? zi : bands[zi];
                    Range range = new Range(sourceBand, sourceBand, 1);
                    section.setRange(0, range);
                }
                catch (InvalidRangeException exception) {
                    throw this.netcdfFailure((Exception)((Object)exception));
                }
            }
            Array array = this.readSection(wrapper, section);
            if (flipYAxis) {
                IndexIterator it = array.getIndexIterator();
                int y = ymax;
                while (--y >= ymin) {
                    block20: for (int x = xmin; x < xmax; ++x) {
                        switch (type) {
                            case 5: {
                                raster.setSample(x, y, dstBand, it.getDoubleNext());
                                continue block20;
                            }
                            case 4: {
                                raster.setSample(x, y, dstBand, it.getFloatNext());
                                continue block20;
                            }
                            case 0: {
                                byte b = it.getByteNext();
                                raster.setSample(x, y, dstBand, b);
                                continue block20;
                            }
                            default: {
                                raster.setSample(x, y, dstBand, it.getIntNext());
                            }
                        }
                    }
                }
            } else {
                switch (type) {
                    case 5: {
                        DoubleBuffer doubleBuffer = array.getDataAsByteBuffer().asDoubleBuffer();
                        double[] samples = new double[destRegion.width * destRegion.height];
                        doubleBuffer.get(samples);
                        raster.setSamples(xmin, ymin, destRegion.width, destRegion.height, dstBand, samples);
                        break;
                    }
                    case 4: {
                        float[] samples = new float[destRegion.width * destRegion.height];
                        FloatBuffer floatBuffer = array.getDataAsByteBuffer().asFloatBuffer();
                        floatBuffer.get(samples);
                        raster.setSamples(xmin, ymin, destRegion.width, destRegion.height, dstBand, samples);
                        break;
                    }
                    case 0: {
                        raster.setDataElements(xmin, ymin, destRegion.width, destRegion.height, array.getDataAsByteBuffer().array());
                        break;
                    }
                    case 3: {
                        IntBuffer intBuffer = array.getDataAsByteBuffer().asIntBuffer();
                        int[] intSamples = new int[destRegion.width * destRegion.height];
                        intBuffer.get(intSamples);
                        raster.setSamples(xmin, ymin, destRegion.width, destRegion.height, dstBand, intSamples);
                        break;
                    }
                    default: {
                        IndexIterator it = array.getIndexIterator();
                        for (int y = ymin; y < ymax; ++y) {
                            for (int x = xmin; x < xmax; ++x) {
                                raster.setSample(x, y, dstBand, it.getIntNext());
                            }
                        }
                    }
                }
            }
            if (this.abortRequested()) {
                this.processReadAborted();
                return image;
            }
            this.processImageProgress((float)zi * toPercent);
        }
        this.processImageComplete();
        return image;
    }

    private synchronized Array readSection(VariableAdapter wrapper, Section section) throws IIOException, IOException {
        try {
            return wrapper.variableDS.read(section);
        }
        catch (InvalidRangeException e) {
            throw this.netcdfFailure((Exception)((Object)e));
        }
    }

    private synchronized boolean needFlipYAxis(CoordinateAxis axis) throws IOException {
        boolean flipYAxis = false;
        try {
            Array yAxisStart = axis.read(new Section().appendRange(2));
            float y1 = yAxisStart.getFloat(0);
            float y2 = yAxisStart.getFloat(1);
            if (y2 > y1) {
                flipYAxis = true;
            }
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        return flipYAxis;
    }

    private Hashtable<String, Object> getNoDataProperties(VariableAdapter wrapper) {
        SampleDimension sampleDimension;
        double[] noData;
        Set sampleDims;
        FieldType field;
        Set fields;
        RangeType range = wrapper.getRangeType();
        if (range != null && (fields = range.getFieldTypes()) != null && !fields.isEmpty() && (field = (FieldType)fields.iterator().next()) != null && (sampleDims = field.getSampleDimensions()) != null && !sampleDims.isEmpty() && (noData = (sampleDimension = (SampleDimension)sampleDims.iterator().next()).getNoDataValues()) != null && noData.length > 0) {
            Hashtable<String, Object> table = new Hashtable<String, Object>();
            CoverageUtilities.setNoDataProperty(table, (Object)noData[0]);
            return table;
        }
        return null;
    }

    private double[] getNoData(VariableAdapter wrapper) {
        SampleDimension sampleDimension;
        double[] noData;
        Set sampleDims;
        FieldType field;
        Set fields;
        RangeType range = wrapper.getRangeType();
        if (range != null && (fields = range.getFieldTypes()) != null && !fields.isEmpty() && (field = (FieldType)fields.iterator().next()) != null && (sampleDims = field.getSampleDimensions()) != null && !sampleDims.isEmpty() && (noData = (sampleDimension = (SampleDimension)sampleDims.iterator().next()).getNoDataValues()) != null && noData.length > 0) {
            return noData;
        }
        return null;
    }

    protected static void flipVertically(ImageReadParam param, int srcHeight, Rectangle srcRegion) {
        int spaceLeft = srcRegion.y;
        srcRegion.y = srcHeight - (srcRegion.y + srcRegion.height);
        if (param != null) {
            int offset = (srcRegion.height - 1) % param.getSourceYSubsampling();
            srcRegion.y += offset;
            if ((offset -= spaceLeft) > 0) {
                srcRegion.height -= offset;
            }
        }
    }

    private void forceSchemaCreation(SimpleFeatureType indexSchema) throws IOException {
        String typeName = indexSchema.getTypeName();
        CoverageSlicesCatalog catalog = this.getCatalog();
        if (typeName != null && catalog != null) {
            if (catalog.hasTypeName(typeName)) {
                return;
            }
            catalog.createType(indexSchema);
        }
    }

    public SimpleFeatureType getIndexSchema(Name coverageName, CoordinateSystem cs) throws Exception {
        return this.getIndexSchema(coverageName, cs, false);
    }

    public SimpleFeatureType getIndexSchema(Name coverageName, CoordinateSystem coordinateSystem, boolean isShared) throws Exception {
        String schemaDef;
        String _coverageName = coverageName.toString();
        Indexer.Coverages.Coverage coverage = this.ancillaryFileManager.coveragesMapping.get(_coverageName);
        SchemaType schema = coverage.getSchema();
        String string = schemaDef = schema != null ? schema.getAttributes() : null;
        if (schema == null || schema.getAttributes() == null) {
            schemaDef = this.suggestSchemaFromCoordinateSystem(coverage, coordinateSystem, isShared);
            this.ancillaryFileManager.setSchema(coverage, coverage.getName(), schemaDef);
            schema = coverage.getSchema();
        }
        String variableName = this.ancillaryFileManager.variablesMap.get(coverageName);
        CoordinateReferenceSystem crs = this.georeferencing.getCoordinateReferenceSystem(variableName);
        SimpleFeatureType indexSchema = NetCDFUtilities.createFeatureType(coverage.getName(), schemaDef, crs);
        this.forceSchemaCreation(indexSchema);
        return indexSchema;
    }

    String suggestSchemaFromCoordinateSystem(Indexer.Coverages.Coverage coverage, CoordinateSystem cs, boolean isShared) throws SchemaException {
        Object schemaAttributes = isShared ? "the_geom:Polygon,imageindex:Integer,location:String" : "the_geom:Polygon,imageindex:Integer";
        Object timeAttribute = "";
        Object elevationAttribute = "";
        Object otherAttributes = "";
        block5: for (CoordinateAxis axis : cs.getCoordinateAxes()) {
            String axisName = axis.getFullName();
            if (NetCDFUtilities.getIgnoredDimensions().contains(axisName)) continue;
            CoordinateVariable<?> cv = this.georeferencing.getCoordinateVariable(axisName);
            if (cv == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Unable to find a coordinate variable for " + axisName);
                continue;
            }
            String name = cv.getName();
            String typeName = cv.getType().getName();
            switch (cv.getAxisType()) {
                case GeoX: 
                case GeoY: 
                case Lat: 
                case Lon: {
                    continue block5;
                }
                case Time: {
                    name = this.uniqueTimeAttribute ? "time" : name;
                    timeAttribute = (String)timeAttribute + "," + name + ":" + typeName;
                    continue block5;
                }
                case Height: 
                case Pressure: 
                case RadialElevation: 
                case RadialDistance: 
                case GeoZ: {
                    elevationAttribute = (String)elevationAttribute + "," + name + ":" + typeName;
                    continue block5;
                }
            }
            otherAttributes = (String)otherAttributes + "," + name + ":" + typeName;
        }
        schemaAttributes = (String)schemaAttributes + (String)timeAttribute + (String)elevationAttribute + (String)otherAttributes;
        return schemaAttributes;
    }

    List<Attribute> getGlobalAttributes() {
        if (this.dataset != null) {
            return this.dataset.getGlobalAttributes();
        }
        return null;
    }

    public void addFile(String filePath) {
        this.ancillaryFileManager.addFile(filePath);
    }

    public List<String> list() {
        return this.ancillaryFileManager.list();
    }

    public void removeFile(String filePath) {
        this.ancillaryFileManager.removeFile(filePath);
    }

    public void purge() {
        CoverageSlicesCatalog catalog = this.getCatalog();
        try {
            catalog.purge((Filter)Filter.INCLUDE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catalog.dispose();
        this.ancillaryFileManager.purge();
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        Slice2DIndex slice2DIndex = this.getSlice2DIndex(imageIndex);
        String variableName = slice2DIndex.getVariableName();
        VariableAdapter wrapper = this.getCoverageDescriptor((Name)new NameImpl(variableName));
        CoordinateReferenceSystem crs = this.georeferencing.getCoordinateReferenceSystem(variableName);
        int width = wrapper.getWidth();
        int height = wrapper.getHeight();
        BandedSampleModel sampleModel = new BandedSampleModel(wrapper.getSampleModel().getDataType(), width, height, wrapper.getNumBands());
        ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
        NetCDFImageMetadata metadata = new NetCDFImageMetadata(variableName, sampleModel, colorModel, crs);
        double[] noData = this.getNoData(wrapper);
        if (noData != null) {
            metadata.setNoData(noData);
        }
        return metadata;
    }
}

