/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.MongoFeatureSource;

public class MongoFeatureReader
implements SimpleFeatureReader {
    DBCursor cursor;
    MongoFeatureSource featureSource;
    CollectionMapper mapper;

    public MongoFeatureReader(DBCursor cursor, MongoFeatureSource featureSource) {
        this.cursor = cursor;
        this.featureSource = featureSource;
        this.mapper = featureSource.getMapper();
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureSource.getSchema();
    }

    public boolean hasNext() throws IOException {
        return this.cursor.hasNext();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        DBObject obj = this.cursor.next();
        return this.mapper.buildFeature(obj, this.featureSource.getSchema());
    }

    public void close() throws IOException {
        this.cursor.close();
    }
}

