/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.mongodb.AbstractCollectionMapper;
import org.geotools.data.mongodb.MongoGeometryBuilder;
import org.geotools.data.mongodb.MongoUtil;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class GeoJSONMapper
extends AbstractCollectionMapper {
    static final Logger LOGGER = Logging.getLogger(GeoJSONMapper.class);
    MongoGeometryBuilder geomBuilder = new MongoGeometryBuilder();

    @Override
    public String getGeometryPath() {
        return "geometry";
    }

    @Override
    public String getPropertyPath(String property) {
        return "properties." + property;
    }

    @Override
    public Geometry getGeometry(DBObject obj) {
        return this.geomBuilder.toGeometry((DBObject)obj.get("geometry"));
    }

    @Override
    public DBObject toObject(Geometry g) {
        return this.geomBuilder.toObject(g);
    }

    @Override
    public void setGeometry(DBObject obj, Geometry g) {
        obj.put("geometry", (Object)this.toObject(g));
    }

    @Override
    public SimpleFeatureType buildFeatureType(Name name, DBCollection collection) {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(name);
        ftBuilder.userData((Object)"mapping", (Object)"geometry");
        ftBuilder.userData((Object)"encoding", (Object)"GeoJSON");
        ftBuilder.add("geometry", Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        DBObject rootDBO = collection.findOne();
        if (rootDBO != null && rootDBO.containsField("properties")) {
            DBObject propertiesDBO = (DBObject)rootDBO.get("properties");
            for (String key : propertiesDBO.keySet()) {
                Object v = propertiesDBO.get(key);
                Class<?> binding = MongoUtil.mapBSONObjectToJavaType(v);
                if (binding != null) {
                    ftBuilder.userData((Object)"mapping", (Object)("properties." + key));
                    ftBuilder.add(key, binding);
                    continue;
                }
                LOGGER.warning("unmapped key, " + key + " with type of " + v.getClass().getName());
            }
        }
        SimpleFeatureType ft = ftBuilder.buildFeatureType();
        ft.getUserData().put("collection", ft.getTypeName());
        return ft;
    }
}

