/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBObject;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.filter.identity.FeatureIdImpl;

public class MongoFeature
extends SimpleFeatureImpl {
    private final DBObject mongoObject;
    private final Object[] values;
    private CoordinateReferenceSystem originalCRS;

    public MongoFeature(Object[] values, SimpleFeatureType featureType, String id) {
        this(null, values, featureType, id);
    }

    public MongoFeature(DBObject mongoObject, Object[] values, SimpleFeatureType featureType, String id) {
        super(values, featureType, (FeatureId)new FeatureIdImpl(id), false);
        this.values = values;
        this.mongoObject = mongoObject;
        this.originalCRS = this.featureType.getGeometryDescriptor().getCoordinateReferenceSystem();
    }

    public DBObject getMongoObject() {
        return this.mongoObject;
    }

    public Object[] getValues() {
        return this.values;
    }

    public CoordinateReferenceSystem getOriginalCRS() {
        return this.originalCRS;
    }
}

