/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb.complex;

import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.parameter.Parameter;
import org.geotools.data.mongodb.complex.MongoCollectionFeature;
import org.geotools.data.mongodb.complex.MongoComplexUtilities;
import org.geotools.feature.NameImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.xml.sax.helpers.NamespaceSupport;

public final class JsonSelectFunction
extends FunctionExpressionImpl
implements PropertyName {
    private static final NamespaceSupport NAMESPACE_SUPPORT = new NamespaceSupport();
    private static final FunctionName DEFINITION = new FunctionNameImpl("jsonSelect", FunctionNameImpl.parameter((String)"path", String.class), new Parameter[0]);

    public JsonSelectFunction() {
        super(DEFINITION);
    }

    public Object evaluate(Object object) {
        Object path = (String)((Expression)this.params.get(0)).evaluate(object);
        if (object instanceof MongoCollectionFeature) {
            String parentPath = ((MongoCollectionFeature)((Object)object)).getCollectionPath();
            path = parentPath + "." + (String)path;
        }
        if (object == null) {
            return new AttributeExpressionImpl((Name)new NameImpl((String)path));
        }
        return MongoComplexUtilities.getValue(object, (String)path);
    }

    public String getJsonPath() {
        return (String)((Expression)this.params.get(0)).evaluate(null);
    }

    public String getPropertyName() {
        return this.getJsonPath();
    }

    public NamespaceSupport getNamespaceContext() {
        return NAMESPACE_SUPPORT;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        if (visitor instanceof FilterAttributeExtractor) {
            return visitor.visit((PropertyName)this, extraData);
        }
        return super.accept(visitor, extraData);
    }
}

