/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.mongodb.AbstractCollectionMapper;
import org.geotools.data.mongodb.MongoGeometryBuilder;
import org.geotools.data.mongodb.MongoSchemaInitParams;
import org.geotools.data.mongodb.MongoUtil;
import org.geotools.data.mongodb.complex.MongoComplexUtilities;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class MongoInferredMapper
extends AbstractCollectionMapper {
    public static final Logger LOG = Logging.getLogger(MongoInferredMapper.class);
    MongoGeometryBuilder geomBuilder = new MongoGeometryBuilder();
    SimpleFeatureType schema;
    private MongoSchemaInitParams schemainitParams;

    public MongoInferredMapper() {
        this.schemainitParams = MongoSchemaInitParams.builder().build();
    }

    public MongoInferredMapper(MongoSchemaInitParams schemainitParams) {
        this.schemainitParams = schemainitParams != null ? schemainitParams : MongoSchemaInitParams.builder().build();
    }

    @Override
    public String getGeometryPath() {
        String gdName = this.schema.getGeometryDescriptor().getLocalName();
        return (String)this.schema.getDescriptor(gdName).getUserData().get("mapping");
    }

    @Override
    public String getPropertyPath(String property) {
        AttributeDescriptor descriptor = this.schema.getDescriptor(property);
        return descriptor == null ? null : (String)descriptor.getUserData().get("mapping");
    }

    @Override
    public Geometry getGeometry(DBObject dbo) {
        Object o = MongoUtil.getDBOValue(dbo, this.getGeometryPath());
        return o == null ? null : this.geomBuilder.toGeometry((DBObject)o);
    }

    @Override
    public DBObject toObject(Geometry g) {
        return this.geomBuilder.toObject(g);
    }

    @Override
    public void setGeometry(DBObject dbo, Geometry g) {
        MongoUtil.setDBOValue(dbo, this.getGeometryPath(), (Object)this.toObject(g));
    }

    @Override
    public SimpleFeatureType buildFeatureType(Name name, DBCollection collection) {
        Set<String> indexedGeometries = MongoUtil.findIndexedGeometries(collection);
        Set<String> indexedFields = MongoUtil.findIndexedFields(collection);
        Map<String, Class> mappedFields = this.schemainitParams.getIds().isEmpty() && this.schemainitParams.getMaxObjects() == 1 ? MongoComplexUtilities.findMappings(collection.findOne()) : this.generateMappedFields(collection);
        indexedFields.removeAll(mappedFields.keySet());
        indexedFields.removeAll(indexedGeometries);
        block0: for (String mappedProperty : new ArrayList<String>(mappedFields.keySet())) {
            for (String string : indexedGeometries) {
                if (!mappedProperty.startsWith(string)) continue;
                mappedFields.remove(mappedProperty);
                continue block0;
            }
        }
        DBObject dbo = collection.findOne();
        if (dbo != null) {
            Iterator<String> indexedIterator = indexedFields.iterator();
            while (indexedIterator.hasNext()) {
                Object value = MongoUtil.getDBOValue(dbo, indexedIterator.next());
                if (value != null) continue;
                indexedIterator.remove();
            }
        }
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(name);
        String geometryField = indexedGeometries.iterator().next();
        if (indexedGeometries.size() > 1) {
            LOG.log(Level.WARNING, "More than one indexed geometry field found for type {0}, selecting {1} (first one encountered with index search of collection {2})", new Object[]{name, geometryField, collection.getFullName()});
        }
        ftBuilder.userData((Object)"mapping", (Object)geometryField);
        ftBuilder.userData((Object)"encoding", (Object)"GeoJSON");
        ftBuilder.add(geometryField, Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        LOG.log(Level.INFO, "building type {0}: mapping geometry field {1} from collection {2}", new Object[]{name, geometryField, collection.getFullName()});
        for (Map.Entry<String, Class> entry : mappedFields.entrySet()) {
            String field = entry.getKey();
            Class binding = entry.getValue();
            ftBuilder.userData((Object)"mapping", (Object)field);
            ftBuilder.add(field, binding);
            LOG.log(Level.INFO, "building type \"{0}\": mapping field \"{1}\" with binding {2} from collection {3}", new Object[]{name, field, binding.getName(), collection.getFullName()});
        }
        for (String string : indexedFields) {
            ftBuilder.userData((Object)"mapping", (Object)string);
            ftBuilder.add(string, String.class);
            LOG.log(Level.INFO, "building type \"{0}\": mapping indexed field \"{1}\" with default binding, {2}, from collection {3}", new Object[]{name, string, String.class.getName(), collection.getFullName()});
        }
        SimpleFeatureType simpleFeatureType = ftBuilder.buildFeatureType();
        simpleFeatureType.getUserData().put("collection", collection.getName());
        this.schema = simpleFeatureType;
        return simpleFeatureType;
    }

    private Map<String, Class> generateMappedFields(DBCollection collection) {
        HashMap<String, Class> resultMap = new HashMap<String, Class>();
        DBCursor idsCursor = this.obtainCursorByIds(collection);
        Map<Object, Object> idsMappings = idsCursor != null ? MongoComplexUtilities.findMappings(idsCursor) : Collections.emptyMap();
        int max = this.schemainitParams.getMaxObjects() - idsMappings.size();
        DBCursor maxObjectsCursor = this.obtainCursorByMaxObjects(collection, max);
        if (maxObjectsCursor != null) {
            resultMap.putAll(MongoComplexUtilities.findMappings(maxObjectsCursor));
        }
        if (!idsMappings.isEmpty()) {
            resultMap.putAll(idsMappings);
        }
        return resultMap;
    }

    private DBCursor obtainCursorByIds(DBCollection collection) {
        List<String> ids = this.schemainitParams.getIds();
        if (!ids.isEmpty()) {
            LOG.info("Using IDs list for schema generation.");
            this.logIdsOnCursor(this.queryByIds(collection, ids), ids);
            return this.queryByIds(collection, ids);
        }
        LOG.info("IDs list for schema generation not available.");
        return null;
    }

    private DBCursor queryByIds(DBCollection collection, List<String> ids) {
        List<ObjectId> oidList = ids.stream().map(id -> new ObjectId(id)).collect(Collectors.toList());
        DBObject query = QueryBuilder.start((String)"_id").in((Object)oidList.toArray(new ObjectId[0])).get();
        LOG.log(Level.INFO, "IDs query for execute: {0}", query);
        return collection.find(query);
    }

    private void logIdsOnCursor(DBCursor cursor, List<String> ids) {
        HashSet idsOnCursor = new HashSet();
        try (DBCursor dBCursor = cursor;){
            cursor.forEach(dbo -> {
                ObjectId oid = (ObjectId)dbo.get("_id");
                idsOnCursor.add(oid.toHexString());
            });
        }
        for (String eid : ids) {
            if (idsOnCursor.contains(eid)) continue;
            LOG.log(Level.WARNING, "ObjectId with value = '{0}' not found in collection.", eid);
        }
    }

    private DBCursor obtainCursorByMaxObjects(DBCollection collection, int maxObects) {
        if (this.schemainitParams.getMaxObjects() == -1) {
            LOG.info("Using all collection objects for schema generation.");
            return collection.find();
        }
        if (maxObects > 0) {
            LOG.info("Using objects max num for schema generation.");
            LOG.log(Level.INFO, "Max objects limit: {0}", this.schemainitParams.getMaxObjects());
            return collection.find().limit(maxObects);
        }
        return null;
    }
}

