/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.mongodb.MongoGeometryBuilder;
import org.geotools.data.mongodb.complex.JsonSelectAllFunction;
import org.geotools.data.mongodb.complex.JsonSelectFunction;
import org.geotools.data.util.DistanceBufferUtil;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public abstract class AbstractFilterToMongo
implements FilterVisitor,
ExpressionVisitor {
    public static final int HUNDRED_KM_IN_METERS = 100000;
    protected static Logger LOGGER = Logging.getLogger(AbstractFilterToMongo.class);
    private static final int DEFAULT_SEGMENTS = 10;
    protected final MongoGeometryBuilder geometryBuilder = new MongoGeometryBuilder();
    protected FeatureType featureType;
    private static final Envelope WORLD = new Envelope(-179.99, 179.99, -89.99, 89.99);
    private static final Class[] SUPPORTED_PRIMITIVES_TYPES = new Class[]{Boolean.class, Double.class, Integer.class, Long.class, String.class};

    public AbstractFilterToMongo(MongoGeometryBuilder builder) {
    }

    public AbstractFilterToMongo() {
        this(new MongoGeometryBuilder());
    }

    protected BasicDBObject asDBObject(Object extraData) {
        if (extraData instanceof BasicDBObject) {
            return (BasicDBObject)extraData;
        }
        return new BasicDBObject();
    }

    public void setFeatureType(FeatureType featureType) {
        this.featureType = featureType;
    }

    public Object visit(Literal expression, Object extraData) {
        Class targetType = null;
        if (extraData != null && extraData instanceof Class) {
            targetType = (Class)extraData;
        }
        return this.encodeLiteral(expression.getValue(), targetType);
    }

    public Object visit(PropertyName expression, Object extraData) {
        String prop = expression.getPropertyName();
        if (extraData == Geometry.class) {
            return this.getGeometryPath();
        }
        return this.getPropertyPath(prop);
    }

    protected abstract String getGeometryPath();

    protected abstract String getPropertyPath(String var1);

    public Object visit(ExcludeFilter filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        output.put((Object)"foo", (Object)"not_likely_to_exist");
        return output;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return new BasicDBObject();
    }

    public Object visit(And filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        List children = filter.getChildren();
        BasicDBList andList = new BasicDBList();
        if (children != null) {
            for (Filter child : children) {
                BasicDBObject item = (BasicDBObject)child.accept((FilterVisitor)this, null);
                andList.add((Object)item);
            }
            output.put((Object)"$and", (Object)andList);
        }
        return output;
    }

    public Object visit(Or filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        List children = filter.getChildren();
        BasicDBList orList = new BasicDBList();
        if (children != null) {
            for (Filter child : children) {
                BasicDBObject item = (BasicDBObject)child.accept((FilterVisitor)this, null);
                orList.add((Object)item);
            }
            output.put((Object)"$or", (Object)orList);
        }
        return output;
    }

    public Object visit(Not filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        class PropertyNameFinder
        extends FilterAttributeExtractor {
            List<PropertyName> pNames = new ArrayList<PropertyName>();

            PropertyNameFinder() {
            }

            public Object visit(PropertyName expression, Object data) {
                this.pNames.add(expression);
                return super.visit(expression, data);
            }

            PropertyName getPropertyName() {
                if (this.pNames.isEmpty()) {
                    return null;
                }
                return this.pNames.get(0);
            }
        }
        PropertyNameFinder finder = new PropertyNameFinder();
        filter.getFilter().accept((FilterVisitor)finder, null);
        PropertyName pn = finder.getPropertyName();
        BasicDBObject expr = (BasicDBObject)filter.getFilter().accept((FilterVisitor)this, null);
        if (pn == null) {
            throw new UnsupportedOperationException("No propertyName found, cannot use $not as top level operator");
        }
        String strPn = this.getPropertyPath(pn.getPropertyName());
        Object exprValue = expr.get(strPn);
        BasicDBObject dbObject = new BasicDBObject("$not", exprValue);
        output.put((Object)strPn, (Object)dbObject);
        return output;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        String propName = (String)Converters.convert((Object)filter.getExpression().accept((ExpressionVisitor)this, null), String.class);
        Object lower = filter.getLowerBoundary().accept((ExpressionVisitor)this, this.getValueType(filter.getExpression()));
        Object upper = filter.getUpperBoundary().accept((ExpressionVisitor)this, this.getValueType(filter.getExpression()));
        BasicDBObject dbo = new BasicDBObject();
        dbo.put((Object)"$gte", lower);
        dbo.put((Object)"$lte", upper);
        output.put((Object)propName, (Object)dbo);
        return output;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$eq", extraData);
    }

    BasicDBObject encodeBinaryComparisonOp(BinaryComparisonOperator filter, String op, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        Class<?> leftValueType = this.getValueType(right);
        Class<?> rightValueType = this.getValueType(left);
        Object leftValue = filter.getExpression1().accept((ExpressionVisitor)this, leftValueType);
        Object rightValue = filter.getExpression2().accept((ExpressionVisitor)this, rightValueType);
        if (rightValue instanceof String && !(leftValue instanceof String)) {
            Object tmp = leftValue;
            leftValue = rightValue;
            rightValue = tmp;
        }
        output.put((Object)((String)leftValue), op == null ? rightValue : new BasicDBObject(op, rightValue));
        return output;
    }

    protected Class<?> getValueType(Expression e) {
        Class<?> ret = this.getValueTypeInternal(e);
        if (ret == null && e instanceof Function) {
            ret = this.getFunctionReturnType((Function)e);
        }
        return ret;
    }

    protected abstract Class<?> getValueTypeInternal(Expression var1);

    private Class<?> getFunctionReturnType(Function f) {
        Class clazz = Object.class;
        if (f.getFunctionName() != null && f.getFunctionName().getReturn() != null) {
            clazz = f.getFunctionName().getReturn().getType();
        }
        if (clazz == Object.class) {
            clazz = null;
        }
        return clazz;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$ne", extraData);
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$gt", extraData);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$gte", extraData);
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$lt", extraData);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$lte", extraData);
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Expression filterExpression = filter.getExpression();
        if (!(filterExpression instanceof PropertyName)) {
            throw new UnsupportedOperationException("LIKE only works with propertyName");
        }
        String expr = (String)Converters.convert((Object)filterExpression.accept((ExpressionVisitor)this, null), String.class);
        String multi = filter.getWildCard();
        String single = filter.getSingleChar();
        int flags = filter.isMatchingCase() ? 0 : 2;
        Object regex = filter.getLiteral().replace(multi, ".*").replace(single, ".");
        regex = "^" + (String)regex + "$";
        Pattern p = Pattern.compile((String)regex, flags);
        output.put((Object)expr, (Object)p);
        return output;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        String prop = (String)Converters.convert((Object)filter.getExpression().accept((ExpressionVisitor)this, null), String.class);
        BasicDBObject propIsNull = new BasicDBObject();
        propIsNull.put((Object)"$eq", null);
        output.put((Object)prop, (Object)propIsNull);
        return output;
    }

    public Object visit(Id filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Set ids = filter.getIdentifiers();
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>(ids.size());
        for (Identifier id : ids) {
            objectIds.add(new ObjectId(id.toString()));
        }
        Object objectIdDBO = objectIds.size() > 1 ? new BasicDBObject("$in", objectIds) : objectIds.get(0);
        output.put((Object)"_id", objectIdDBO);
        return output;
    }

    public Object visit(BBOX filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object e1 = filter.getExpression1().accept((ExpressionVisitor)this, Geometry.class);
        Envelope envelope = (Envelope)filter.getExpression2().evaluate(null, Envelope.class);
        if (!WORLD.contains(envelope)) {
            envelope = envelope.intersection(WORLD);
        }
        DBObject geometryDBObject = this.geometryBuilder.toObject(envelope);
        this.addCrsToGeometryDBObject(geometryDBObject);
        DBObject dbo = BasicDBObjectBuilder.start().push("$geoIntersects").add("$geometry", (Object)geometryDBObject).get();
        output.put((Object)((String)e1), (Object)dbo);
        return output;
    }

    public Object visit(Intersects filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object e1 = filter.getExpression1().accept((ExpressionVisitor)this, Geometry.class);
        Geometry geometry = (Geometry)filter.getExpression2().evaluate(null, Geometry.class);
        DBObject geometryDBObject = this.geometryBuilder.toObject(geometry);
        this.addCrsToGeometryDBObject(geometryDBObject);
        DBObject dbo = BasicDBObjectBuilder.start().push("$geoIntersects").add("$geometry", (Object)geometryDBObject).get();
        output.put((Object)((String)e1), (Object)dbo);
        return output;
    }

    public Object visit(Within filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object e1 = filter.getExpression1().accept((ExpressionVisitor)this, Geometry.class);
        Geometry geometry = (Geometry)filter.getExpression2().evaluate(null, Geometry.class);
        DBObject geometryDBObject = this.geometryBuilder.toObject(geometry);
        this.addCrsToGeometryDBObject(geometryDBObject);
        DBObject dbo = BasicDBObjectBuilder.start().push("$geoWithin").add("$geometry", (Object)geometryDBObject).get();
        output.put((Object)((String)e1), (Object)dbo);
        return output;
    }

    public Object visitNullFilter(Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(NilExpression expression, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Beyond filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Contains filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Crosses filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Disjoint filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(DWithin filter, Object extraData) {
        DBObject dbo;
        BasicDBObject output = this.asDBObject(extraData);
        Object e1 = filter.getExpression1().accept((ExpressionVisitor)this, Geometry.class);
        Geometry geometry = (Geometry)filter.getExpression2().evaluate(null, Geometry.class);
        CoordinateReferenceSystem coordinateReferenceSystem = this.featureType.getCoordinateReferenceSystem();
        double distanceInMeters = DistanceBufferUtil.getDistanceInMeters((DistanceBufferOperator)filter);
        if (geometry instanceof Point) {
            DBObject geometryDBObject = this.geometryBuilder.toObject(geometry);
            dbo = BasicDBObjectBuilder.start().push("$near").add("$geometry", (Object)geometryDBObject).add("$maxDistance", (Object)distanceInMeters).get();
        } else {
            try {
                Point centroid = geometry.getCentroid();
                CoordinateReferenceSystem azimuthalEquidistantCRS = AbstractFilterToMongo.computeAzimutalEquidistantCRS(centroid, coordinateReferenceSystem);
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)azimuthalEquidistantCRS);
                geometry = JTS.transform((Geometry)geometry, (MathTransform)transform);
                Geometry bufferedGeometry = geometry.buffer(distanceInMeters, 10);
                this.logAdditionalInformation(bufferedGeometry);
                transform = CRS.findMathTransform((CoordinateReferenceSystem)azimuthalEquidistantCRS, (CoordinateReferenceSystem)coordinateReferenceSystem);
                geometry = JTS.transform((Geometry)bufferedGeometry, (MathTransform)transform);
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException("Failed to compute polygon within distance from reference geometry", e);
            }
            DBObject geometryDBObject = this.geometryBuilder.toObject(geometry);
            dbo = BasicDBObjectBuilder.start().push("$geoIntersects").add("$geometry", (Object)geometryDBObject).get();
        }
        output.put((Object)((String)e1), (Object)dbo);
        return output;
    }

    private void logAdditionalInformation(Geometry bufferedGeometry) {
        Coordinate[] coordinates;
        Coordinate centroidCoordinate = bufferedGeometry.getCentroid().getCoordinate();
        for (Coordinate coordinate : coordinates = bufferedGeometry.getEnvelope().getCoordinates()) {
            if (!(coordinate.distance(centroidCoordinate) > 100000.0)) continue;
            LOGGER.fine("The size of input buffer to apply is bigger then 100 km. This may result in decreased precision of buffer operation.");
            break;
        }
    }

    private static CoordinateReferenceSystem computeAzimutalEquidistantCRS(Point centroid, CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException, TransformException {
        if (!(coordinateReferenceSystem instanceof GeographicCRS) || CRS.getAxisOrder((CoordinateReferenceSystem)coordinateReferenceSystem).equals((Object)CRS.AxisOrder.NORTH_EAST)) {
            MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            centroid = (Point)JTS.transform((Geometry)centroid, (MathTransform)mathTransform);
        }
        double lon = centroid.getX();
        double lat = centroid.getY();
        String autoCRS = "AUTO:97003,9001," + lon + "," + lat;
        return CRS.decode((String)autoCRS);
    }

    public Object visit(Equals filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Overlaps filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Touches filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Add expression, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Divide expression, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Function function, Object extraData) {
        if (function instanceof JsonSelectFunction) {
            return ((JsonSelectFunction)function).getJsonPath();
        }
        if (function instanceof JsonSelectAllFunction) {
            return ((JsonSelectAllFunction)function).getJsonPath();
        }
        throw new UnsupportedOperationException();
    }

    public Object visit(Multiply expression, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Subtract expression, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(After after, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Before before, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Begins begins, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(During during, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Ends ends, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Meets meets, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(TContains contains, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(TEquals equals, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new UnsupportedOperationException();
    }

    Object encodeLiteral(Object literal, Class<?> targetType) {
        if (literal instanceof Envelope) {
            return this.geometryBuilder.toObject((Envelope)literal);
        }
        if (literal instanceof Geometry) {
            return this.geometryBuilder.toObject((Geometry)literal);
        }
        if (literal instanceof Date) {
            if (targetType != null && Date.class.isAssignableFrom(targetType)) {
                return literal;
            }
            return DateTimeFormatter.ISO_DATE_TIME.format(((Date)literal).toInstant());
        }
        if (literal instanceof String) {
            if (targetType != null && Date.class.isAssignableFrom(targetType)) {
                return Date.from(Instant.from(DateTimeFormatter.ISO_DATE_TIME.parse((String)literal)));
            }
            return this.convertLiteral(literal, targetType);
        }
        return this.convertLiteral(literal, targetType);
    }

    private Object convertLiteral(Object literal, Class<?> targetType) {
        if (literal == null) {
            return null;
        }
        if (targetType == null) {
            return this.covertToPrimitive(literal);
        }
        if (!this.isPrimitiveTypeSupported(targetType)) {
            return literal.toString();
        }
        Object converted = Converters.convert((Object)literal, targetType);
        if (converted == null) {
            return literal.toString();
        }
        return converted;
    }

    private Object covertToPrimitive(Object literal) {
        for (Class supportedType : SUPPORTED_PRIMITIVES_TYPES) {
            if (!supportedType.isAssignableFrom(literal.getClass())) continue;
            return literal;
        }
        return literal.toString();
    }

    private boolean isPrimitiveTypeSupported(Class<?> type) {
        for (Class supportedType : SUPPORTED_PRIMITIVES_TYPES) {
            if (!supportedType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    void addCrsToGeometryDBObject(DBObject geometryDBObject) {
        geometryDBObject.put("crs", (Object)BasicDBObjectBuilder.start().add("type", (Object)"name").push("properties").add("name", (Object)"urn:x-mongodb:crs:strictwinding:EPSG:4326").get());
    }
}

