/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.MongoFeature;
import org.geotools.data.mongodb.MongoUtil;
import org.geotools.util.Converters;

public abstract class AbstractCollectionMapper
implements CollectionMapper {
    public static final String MONGO_OBJECT_FEATURE_KEY = "MONGO_OBJECT_FEATURE";

    @Override
    public SimpleFeature buildFeature(DBObject rootDBO, SimpleFeatureType featureType) {
        String gdLocalName = featureType.getGeometryDescriptor().getLocalName();
        List adList = featureType.getAttributeDescriptors();
        ArrayList<Object> values = new ArrayList<Object>(adList.size());
        for (AttributeDescriptor descriptor : adList) {
            String adLocalName = descriptor.getLocalName();
            if (gdLocalName.equals(adLocalName)) {
                values.add(this.getGeometry(rootDBO));
                continue;
            }
            String path = this.getPropertyPath(adLocalName);
            Object o = path == null ? null : MongoUtil.getDBOValue(rootDBO, path);
            values.add(o == null ? null : Converters.convert((Object)o, (Class)descriptor.getType().getBinding()));
        }
        MongoFeature feature = new MongoFeature(rootDBO, values.toArray(), featureType, rootDBO.get("_id").toString());
        feature.getUserData().put(MONGO_OBJECT_FEATURE_KEY, feature);
        return feature;
    }
}

