/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb.complex;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.geotools.data.mongodb.MongoFeature;
import org.geotools.data.mongodb.complex.MongoComplexUtilities;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.filter.identity.FeatureId;

final class MongoCollectionFeature
extends SimpleFeatureImpl {
    private final MongoFeature mongoFeature;
    private final String collectionPath;
    private final Map<String, Integer> collectionsIndexes = new HashMap<String, Integer>();

    static MongoCollectionFeature build(Object feature, String collectionPath, int collectionIndex) {
        if ((feature = MongoComplexUtilities.extractFeature(feature, collectionPath)) instanceof MongoFeature) {
            return new MongoCollectionFeature((MongoFeature)((Object)feature), collectionPath, collectionIndex);
        }
        if (feature instanceof MongoCollectionFeature) {
            return new MongoCollectionFeature((MongoCollectionFeature)((Object)feature), collectionPath, collectionIndex);
        }
        throw new RuntimeException("The feature must be a mongo feature.");
    }

    private MongoCollectionFeature(MongoCollectionFeature collectionFeature, String collectionPath, int collectionIndex) {
        this(collectionFeature.getMongoFeature(), collectionPath, collectionIndex);
        this.collectionsIndexes.putAll(collectionFeature.getCollectionsIndexes());
    }

    private MongoCollectionFeature(MongoFeature feature, String collectionPath, int collectionIndex) {
        super(feature.getValues(), feature.getFeatureType(), (FeatureId)new FeatureIdImpl(UUID.randomUUID().toString()), false);
        this.mongoFeature = feature;
        this.collectionsIndexes.put(collectionPath, collectionIndex);
        this.collectionPath = collectionPath;
    }

    MongoFeature getMongoFeature() {
        return this.mongoFeature;
    }

    Map<String, Integer> getCollectionsIndexes() {
        return this.collectionsIndexes;
    }

    public String getCollectionPath() {
        return this.collectionPath;
    }
}

