/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import org.geotools.data.mongodb.AbstractCollectionMapper;
import org.geotools.data.mongodb.MongoGeometryBuilder;
import org.geotools.data.mongodb.MongoUtil;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class MongoSchemaMapper
extends AbstractCollectionMapper {
    MongoGeometryBuilder geomBuilder = new MongoGeometryBuilder();
    final SimpleFeatureType schema;

    public MongoSchemaMapper(SimpleFeatureType schema) {
        this.schema = schema;
    }

    @Override
    public String getGeometryPath() {
        String gdName = this.schema.getGeometryDescriptor().getLocalName();
        return (String)this.schema.getDescriptor(gdName).getUserData().get("mapping");
    }

    @Override
    public String getPropertyPath(String property) {
        AttributeDescriptor descriptor = this.schema.getDescriptor(property);
        return descriptor == null ? null : (String)descriptor.getUserData().get("mapping");
    }

    @Override
    public Geometry getGeometry(DBObject dbo) {
        Object o = MongoUtil.getDBOValue(dbo, this.getGeometryPath());
        return o == null ? null : this.geomBuilder.toGeometry((DBObject)o);
    }

    @Override
    public DBObject toObject(Geometry g) {
        return this.geomBuilder.toObject(g);
    }

    @Override
    public void setGeometry(DBObject dbo, Geometry g) {
        MongoUtil.setDBOValue(dbo, this.getGeometryPath(), (Object)this.toObject(g));
    }

    @Override
    public SimpleFeatureType buildFeatureType(Name name, DBCollection collection) {
        return this.schema;
    }
}

