/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import org.geotools.data.QueryCapabilities;
import org.geotools.data.mongodb.MongoFeatureSource;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;

class MongoQueryCapabilities
extends QueryCapabilities {
    private MongoFeatureSource source;

    MongoQueryCapabilities(MongoFeatureSource source) {
        this.source = source;
    }

    public boolean supportsSorting(SortBy[] sortAttributes) {
        for (SortBy sort : sortAttributes) {
            if (this.supportsPropertySorting(sort.getPropertyName())) continue;
            return false;
        }
        return true;
    }

    private boolean supportsPropertySorting(PropertyName propertyName) {
        AttributeDescriptor descriptor = (AttributeDescriptor)propertyName.evaluate((Object)this.source.getSchema());
        return descriptor != null && !Geometry.class.isAssignableFrom(descriptor.getType().getBinding());
    }
}

