/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.IOException;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.MongoDBObjectFeature;
import org.geotools.data.mongodb.MongoFeatureStore;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MongoFeatureWriter
implements SimpleFeatureWriter {
    private final DBCollection collection;
    private final SimpleFeatureType featureType;
    private final CollectionMapper mapper;
    private MongoDBObjectFeature current;

    public MongoFeatureWriter(DBCollection collection, SimpleFeatureType featureType, MongoFeatureStore featureStore) {
        this.collection = collection;
        this.featureType = featureType;
        this.mapper = featureStore.getMapper();
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public boolean hasNext() throws IOException {
        return false;
    }

    public SimpleFeature next() throws IOException {
        this.current = new MongoDBObjectFeature((DBObject)new BasicDBObject(), this.featureType, this.mapper);
        return this.current;
    }

    public void write() throws IOException {
        if (this.current == null) {
            throw new IllegalStateException("No current feature, must call next() before write()");
        }
        this.collection.save(this.current.getObject());
    }

    public void remove() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.collection.createIndex((DBObject)new BasicDBObject(this.mapper.getGeometryPath(), (Object)"2dsphere"));
    }
}

