/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb.data;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.geotools.data.mongodb.data.SchemaStoreDirectory;

public final class SchemaStoreDirectoryProvider {
    private static List<SchemaStoreDirectory> directoriies = SchemaStoreDirectoryProvider.initDirectories(SchemaStoreDirectory.class);

    private static <T> List<T> initDirectories(Class<T> type) {
        ServiceLoader<T> loader = ServiceLoader.load(type);
        loader.reload();
        ArrayList<T> directories = new ArrayList<T>();
        for (T aLoader : loader) {
            directories.add(aLoader);
        }
        return directories;
    }

    public static List<SchemaStoreDirectory> getDirectories() {
        return directoriies;
    }

    public static SchemaStoreDirectory getHighestPriority() {
        return (SchemaStoreDirectory)directoriies.stream().sorted((o1, o2) -> o2.getPriority() - o1.getPriority()).findFirst().get();
    }

    public static SchemaStoreDirectory getLowestPriority() {
        return (SchemaStoreDirectory)directoriies.stream().sorted((o1, o2) -> o1.getPriority() - o2.getPriority()).findFirst().get();
    }

    public static void addStoreDirectory(SchemaStoreDirectory directory) {
        directoriies.add(directory);
    }
}

