/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.geotools.data.mongodb.FeatureTypeDBObject;
import org.geotools.data.mongodb.data.SchemaStoreDirectory;
import org.geotools.http.HTTPClient;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class MongoUtil {
    public static Object getDBOValue(DBObject dbo, String path) {
        return MongoUtil.getDBOValue(dbo, Arrays.asList(path.split("\\.")).iterator());
    }

    public static Object getDBOValue(DBObject dbo, Iterator<String> path) {
        return MongoUtil.getDBOValueInternal(path, dbo);
    }

    private static Object getDBOValueInternal(Iterator<String> path, Object current) {
        if (path.hasNext()) {
            if (current instanceof DBObject) {
                String key = path.next();
                if (current instanceof BasicDBList) {
                    try {
                        Integer.parseInt(key);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                Object value = ((DBObject)current).get(key);
                return MongoUtil.getDBOValueInternal(path, value);
            }
            return null;
        }
        return current;
    }

    public static void setDBOValue(DBObject dbo, String path, Object value) {
        MongoUtil.setDBOValue(dbo, Arrays.asList(path.split("\\.")).iterator(), value);
    }

    public static void setDBOValue(DBObject dbo, Iterator<String> path, Object value) {
        MongoUtil.setDBOValueInternal(dbo, path, value);
    }

    private static void setDBOValueInternal(DBObject currentDBO, Iterator<String> path, Object value) {
        String key = path.next();
        if (path.hasNext()) {
            DBObject nextDBO;
            Object next = currentDBO.get(key);
            if (next instanceof DBObject) {
                nextDBO = (DBObject)next;
            } else {
                nextDBO = new BasicDBObject();
                currentDBO.put(key, (Object)nextDBO);
            }
            MongoUtil.setDBOValueInternal(nextDBO, path, value);
        } else {
            currentDBO.put(key, value);
        }
    }

    public static Set<String> findIndexedGeometries(DBCollection dbc) {
        return MongoUtil.findIndexedFields(dbc, "2dsphere");
    }

    public static Set<String> findIndexedFields(DBCollection dbc) {
        return MongoUtil.findIndexedFields(dbc, null);
    }

    public static Set<String> findIndexedFields(DBCollection dbc, String type) {
        List indices = dbc.getIndexInfo();
        return MongoUtil.findIndexedFields(indices, type);
    }

    public static Set<String> findIndexedFields(List<DBObject> indices, String type) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        for (DBObject index : indices) {
            Object key = index.get("key");
            if (!(key instanceof DBObject)) continue;
            for (Map.Entry entry : ((DBObject)key).toMap().entrySet()) {
                if (type != null && !type.equals(entry.getValue())) continue;
                fields.add(entry.getKey().toString());
            }
        }
        fields.remove("_id");
        return fields;
    }

    public static Map<String, Class<?>> findMappableFields(DBCollection dbc) {
        return MongoUtil.findMappableFields(dbc.findOne());
    }

    public static Map<String, Class<?>> findMappableFields(DBObject dbo) {
        if (dbo == null) {
            return Collections.emptyMap();
        }
        Map<String, Class<?>> map = MongoUtil.doFindMappableFields(dbo);
        map.remove("_id");
        return map;
    }

    private static Map<String, Class<?>> doFindMappableFields(DBObject dbo) {
        if (dbo == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry e : dbo.toMap().entrySet()) {
            Class<?> binding;
            Object k = e.getKey();
            if (!(k instanceof String)) continue;
            String field = (String)k;
            Object v = e.getValue();
            if (v instanceof DBObject) {
                if (v instanceof BasicDBList) continue;
                for (Map.Entry<String, Class<?>> childEntry : MongoUtil.doFindMappableFields((DBObject)v).entrySet()) {
                    map.put(field + "." + childEntry.getKey(), childEntry.getValue());
                }
                continue;
            }
            if (v instanceof List || (binding = MongoUtil.mapBSONObjectToJavaType(v)) == null) continue;
            map.put(field, binding);
        }
        return map;
    }

    public static Class<?> mapBSONObjectToJavaType(Object o) {
        if (o instanceof String || o instanceof Double || o instanceof Long || o instanceof Integer || o instanceof Boolean || o instanceof Date) {
            return o.getClass();
        }
        return null;
    }

    public static String extractFilesNameFromUrl(String url) throws MalformedURLException {
        String path;
        URL urlObject = new URL(url);
        int lastSeparatorIndex = (path = urlObject.getPath()).lastIndexOf("/");
        return path.substring(lastSeparatorIndex > -1 ? lastSeparatorIndex + 1 : 0, path.length());
    }

    public static boolean isZipFile(File file) throws IOException {
        boolean bl;
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            long n = raf.readInt();
            raf.close();
            bl = n == 1347093252L;
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Logger.getGlobal().log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }
        raf.close();
        return bl;
    }

    public static boolean isZipFile(String uri) throws IOException, URISyntaxException {
        File file = new File(new URI(uri));
        return MongoUtil.isZipFile(file);
    }

    static void validateDirectory(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Schema store directory does not exist and could not be created: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            if (!File.createTempFile("test", ".tmp", file).delete()) {
                throw new IOException("Unable to write to schema store directory: " + file.getAbsolutePath());
            }
        } else {
            throw new IOException("Specified schema store directory exists but is not a directory: " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SimpleFeatureType getSimpleFeatureType(BufferedReader reader, Name name) throws IOException {
        try {
            String line;
            String lineSeparator = System.getProperty("line.separator");
            StringBuilder jsonBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                jsonBuilder.append(line);
                jsonBuilder.append(lineSeparator);
            }
            BasicDBObject o = BasicDBObject.parse((String)jsonBuilder.toString());
            SimpleFeatureType simpleFeatureType = FeatureTypeDBObject.convert((DBObject)o, name);
            return simpleFeatureType;
        }
        finally {
            reader.close();
        }
    }

    static File downloadSchemaFile(String storeName, URL url, HTTPClient httpClient, SchemaStoreDirectory downloadDirectory) throws IOException {
        File downloadDir = new File(downloadDirectory.getDirectory(), storeName);
        MongoUtil.validateDirectory(downloadDir);
        httpClient.setTryGzip(true);
        try (InputStream in = httpClient.get(url).getResponseStream();){
            Logger.getGlobal().info("MongoDBStore:" + storeName + ":Downloading Schema File from :" + url.toExternalForm());
            String filesName = MongoUtil.extractFilesNameFromUrl(url.toExternalForm());
            File schemaStoreFile = new File(downloadDir, filesName);
            Files.copy(in, schemaStoreFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Logger.getGlobal().info("MongoDBStore:" + storeName + ":Downloaded File Stored at :" + schemaStoreFile.getAbsolutePath());
            File file = schemaStoreFile;
            return file;
        }
    }

    public static File extractZipFile(File destDir, File zipFile) throws ZipException, IOException {
        int BUFFER = 2048;
        String extractFolderName = zipFile.getName();
        int idx = extractFolderName.lastIndexOf(".zip");
        extractFolderName = extractFolderName.substring(0, idx);
        File extractLocation = new File(destDir, extractFolderName);
        extractLocation.mkdir();
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(extractLocation, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                try (BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));){
                    byte[] data = new byte[BUFFER];
                    FileOutputStream fos = new FileOutputStream(destFile);
                    try (BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);){
                        int currentByte;
                        while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                            dest.write(data, 0, currentByte);
                        }
                    }
                }
            }
        }
        Files.deleteIfExists(zipFile.toPath());
        SchemaFolderFinder jsonFolderFinder = new SchemaFolderFinder();
        Files.walkFileTree(extractLocation.toPath(), jsonFolderFinder);
        return jsonFolderFinder.getLastDirectory();
    }

    public static class SchemaFolderFinder
    implements FileVisitor<Path> {
        private File lastDirectory = null;

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path parent;
            if (file.toString().endsWith(".json".toLowerCase()) && (parent = file.getParent()) != null) {
                this.lastDirectory = parent.toFile();
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public File getLastDirectory() {
            return this.lastDirectory;
        }
    }
}

