/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.FilterToMongo;
import org.geotools.data.mongodb.MongoCollectionMeta;
import org.geotools.data.mongodb.MongoDataStore;
import org.geotools.data.mongodb.MongoFeatureReader;
import org.geotools.data.mongodb.MongoFilterSplitter;
import org.geotools.data.mongodb.MongoInferredMapper;
import org.geotools.data.mongodb.MongoQueryCapabilities;
import org.geotools.data.mongodb.MongoSchemaMapper;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.SortByImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class MongoFeatureSource
extends ContentFeatureSource {
    static Logger LOG = Logging.getLogger(MongoFeatureSource.class);
    final DBCollection collection;
    CollectionMapper mapper;

    public MongoFeatureSource(ContentEntry entry, Query query, DBCollection collection) {
        super(entry, query);
        this.collection = collection;
        this.initMapper();
    }

    final void initMapper() {
        SimpleFeatureType type = this.entry.getState(null).getFeatureType();
        this.setMapper(type != null ? new MongoSchemaMapper(type) : new MongoInferredMapper(this.getDataStore().getSchemaInitParams().orElse(null)));
    }

    public DBCollection getCollection() {
        return this.collection;
    }

    public CollectionMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(CollectionMapper mapper) {
        this.mapper = mapper;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureType type = this.mapper.buildFeatureType(this.entry.getName(), this.collection);
        this.getDataStore().getSchemaStore().storeSchema(type);
        return type;
    }

    public MongoDataStore getDataStore() {
        return (MongoDataStore)super.getDataStore();
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        try (FeatureReader r = this.getReader(query);){
            ReferencedEnvelope e = new ReferencedEnvelope();
            if (r.hasNext()) {
                e.init(((SimpleFeature)r.next()).getBounds());
            }
            while (r.hasNext()) {
                e.include(((SimpleFeature)r.next()).getBounds());
            }
            ReferencedEnvelope referencedEnvelope = e;
            return referencedEnvelope;
        }
    }

    protected int getCountInternal(Query query) throws IOException {
        Filter f = query.getFilter();
        if (this.isAll(f)) {
            LOG.fine("count(all)");
            return (int)this.collection.count();
        }
        Filter[] split = this.splitFilter(f);
        if (!this.isAll(split[1])) {
            return -1;
        }
        DBObject q = this.toQuery(f);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("count(" + String.valueOf(q) + ")");
        }
        return (int)this.collection.count(q);
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        ArrayList<Filter> postFilterList = new ArrayList<Filter>();
        ArrayList<String> postFilterAttributes = new ArrayList<String>();
        DBCursor cursor = this.toCursor(query, postFilterList, postFilterAttributes);
        MongoFeatureReader r = new MongoFeatureReader(cursor, this);
        if (!postFilterList.isEmpty() && !this.isAll((Filter)postFilterList.get(0))) {
            r = new FilteringFeatureReader((FeatureReader)r, (Filter)postFilterList.get(0));
            if (!postFilterAttributes.isEmpty()) {
                SimpleFeatureType returnedSchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), (String[])query.getPropertyNames());
                r = new ReTypeFeatureReader((FeatureReader)r, returnedSchema);
            }
        }
        return r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        if (query.getMaxFeatures() != Integer.MAX_VALUE) {
            return false;
        }
        if (visitor instanceof MinVisitor) {
            MinVisitor minVisitor = (MinVisitor)visitor;
            List expressions = minVisitor.getExpressions();
            if (expressions.size() != 1 || !(expressions.get(0) instanceof PropertyName)) {
                return false;
            }
            PropertyName propertyName = (PropertyName)expressions.get(0);
            SortByImpl sortBy = new SortByImpl(propertyName, SortOrder.ASCENDING);
            Query newQuery = new Query(query);
            newQuery.setSortBy(new SortBy[]{sortBy});
            newQuery.setMaxFeatures(1);
            try (FeatureReader reader = this.getReader(newQuery);){
                if (!reader.hasNext()) return true;
                minVisitor.setValue(propertyName.evaluate((Object)reader.next()));
                return true;
            }
        }
        if (!(visitor instanceof MaxVisitor)) return false;
        MaxVisitor maxVisitor = (MaxVisitor)visitor;
        List expressions = maxVisitor.getExpressions();
        if (expressions.size() != 1 || !(expressions.get(0) instanceof PropertyName)) {
            return false;
        }
        PropertyName propertyName = (PropertyName)expressions.get(0);
        SortByImpl sortBy = new SortByImpl(propertyName, SortOrder.DESCENDING);
        Query newQuery = new Query(query);
        newQuery.setSortBy(new SortBy[]{sortBy});
        newQuery.setMaxFeatures(1);
        try (FeatureReader reader = this.getReader(newQuery);){
            if (!reader.hasNext()) return true;
            maxVisitor.setValue(propertyName.evaluate((Object)reader.next()));
            return true;
        }
    }

    protected boolean canOffset() {
        return true;
    }

    protected boolean canLimit() {
        return true;
    }

    protected boolean canRetype() {
        return true;
    }

    protected boolean canSort() {
        return true;
    }

    protected boolean canFilter() {
        return true;
    }

    DBCursor toCursor(Query q, List<Filter> postFilter, List<String> postFilterAttrs) {
        DBCursor c;
        BasicDBObject query = new BasicDBObject();
        Filter f = q.getFilter();
        if (!this.isAll(f)) {
            Filter[] split = this.splitFilter(f);
            query = this.toQuery(split[0]);
            if (!this.isAll(split[1])) {
                postFilter.add(split[1]);
            }
        }
        if (q.getPropertyNames() != Query.ALL_NAMES) {
            BasicDBObject keys = new BasicDBObject();
            for (String string : q.getPropertyNames()) {
                keys.put((Object)this.mapper.getPropertyPath(string), (Object)1);
            }
            for (Filter filter : postFilter) {
                String[] attributeNames;
                for (String attrName : attributeNames = DataUtilities.attributeNames((Filter)filter)) {
                    if (attrName == null || attrName.isEmpty() || keys.containsField(attrName)) continue;
                    keys.put((Object)this.mapper.getPropertyPath(attrName), (Object)1);
                    postFilterAttrs.add(attrName);
                }
            }
            if (!keys.containsField(this.mapper.getGeometryPath())) {
                keys.put((Object)this.mapper.getGeometryPath(), (Object)1);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("find(%s, %s)", query, keys));
            }
            c = this.collection.find((DBObject)query, (DBObject)keys);
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("find(%s)", query));
            }
            c = this.collection.find((DBObject)query);
        }
        if (q.getStartIndex() != null && q.getStartIndex() != 0) {
            c = c.skip(q.getStartIndex().intValue());
        }
        if (q.getMaxFeatures() != Integer.MAX_VALUE) {
            c = c.limit(q.getMaxFeatures());
        }
        if (q.getSortBy() != null) {
            BasicDBObject orderBy = new BasicDBObject();
            for (SortBy sortBy : q.getSortBy()) {
                if (sortBy.getPropertyName() == null) continue;
                String propName = sortBy.getPropertyName().getPropertyName();
                String property = this.mapper.getPropertyPath(propName);
                orderBy.append(property, (Object)(sortBy.getSortOrder() == SortOrder.ASCENDING ? 1 : -1));
            }
            c = c.sort((DBObject)orderBy);
        }
        return c;
    }

    DBObject toQuery(Filter f) {
        if (this.isAll(f)) {
            return new BasicDBObject();
        }
        FilterToMongo v = new FilterToMongo(this.mapper);
        v.setFeatureType(this.getSchema());
        return (DBObject)f.accept((FilterVisitor)v, null);
    }

    boolean isAll(Filter f) {
        return f == null || f == Filter.INCLUDE;
    }

    Filter[] splitFilter(Filter f) {
        FilterCapabilities filterCapabilities = this.getDataStore().getFilterCapabilities();
        MongoFilterSplitter splitter = new MongoFilterSplitter(filterCapabilities, null, null, new MongoCollectionMeta(this.getIndexesInfoMap()));
        f.accept((FilterVisitor)splitter, null);
        return new Filter[]{splitter.getFilterPre(), splitter.getFilterPost()};
    }

    private Map<String, String> getIndexesInfoMap() {
        HashMap<String, String> indexes = new HashMap<String, String>();
        for (DBObject object : this.collection.getIndexInfo()) {
            BasicDBObject key = (BasicDBObject)object.get("key");
            for (Map.Entry entry : key.entrySet()) {
                indexes.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return indexes;
    }

    protected QueryCapabilities buildQueryCapabilities() {
        if (this.queryCapabilities == null) {
            return new MongoQueryCapabilities(this);
        }
        return this.queryCapabilities;
    }
}

