/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.MongoUtil;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MongoDBObjectFeature
implements SimpleFeature {
    private final SimpleFeatureType featureType;
    private final DBObject featureDBO;
    private final CollectionMapper mapper;
    private Map<Object, Object> userData;

    public MongoDBObjectFeature(DBObject dbo, SimpleFeatureType featureType, CollectionMapper mapper) {
        this.featureDBO = dbo;
        this.featureType = featureType;
        this.mapper = mapper;
    }

    public DBObject getObject() {
        return this.featureDBO;
    }

    public SimpleFeatureType getType() {
        return this.featureType;
    }

    public SimpleFeatureType getFeatureType() {
        return this.getType();
    }

    public FeatureId getIdentifier() {
        String id = this.getID();
        return id != null ? new FeatureIdImpl(id) : null;
    }

    public String getID() {
        Object id = this.featureDBO.get("_id");
        return id != null ? id.toString() : null;
    }

    public BoundingBox getBounds() {
        Object o = this.getDefaultGeometry();
        if (o instanceof Geometry) {
            CoordinateReferenceSystem crs = this.featureType.getCoordinateReferenceSystem();
            if (crs == null) {
                crs = DefaultGeographicCRS.WGS84;
            }
            ReferencedEnvelope bounds = ReferencedEnvelope.create((CoordinateReferenceSystem)crs);
            bounds.init((Envelope)JTS.bounds((Geometry)((Geometry)o), (CoordinateReferenceSystem)crs));
            return (BoundingBox)bounds;
        }
        return null;
    }

    public Object getDefaultGeometry() {
        return this.mapper.getGeometry(this.featureDBO);
    }

    public void setDefaultGeometry(Object geometry) {
        MongoUtil.setDBOValue(this.featureDBO, this.mapper.getGeometryPath(), (Object)this.mapper.toObject((Geometry)geometry));
    }

    public Object getAttribute(Name name) {
        return this.doGetAttribute(this.featureType.getDescriptor(name));
    }

    public void setAttribute(Name name, Object value) {
        this.doSetAttribute(this.featureType.getDescriptor(name), value);
    }

    public Object getAttribute(String name) {
        return this.doGetAttribute(this.featureType.getDescriptor(name));
    }

    public void setAttribute(String name, Object value) {
        this.doSetAttribute(this.featureType.getDescriptor(name), value);
    }

    public Object getAttribute(int index) throws IndexOutOfBoundsException {
        return this.doGetAttribute(this.featureType.getDescriptor(index));
    }

    public void setAttribute(int index, Object value) throws IndexOutOfBoundsException {
        this.doSetAttribute(this.featureType.getDescriptor(index), value);
    }

    private Object doGetAttribute(AttributeDescriptor d) throws IndexOutOfBoundsException {
        if (d instanceof GeometryDescriptor) {
            Object o = this.getDBOValue(this.mapper.getGeometryPath());
            return o instanceof DBObject ? this.mapper.getGeometry((DBObject)o) : null;
        }
        return this.getDBOValue(this.mapper.getPropertyPath(d.getLocalName()));
    }

    private void doSetAttribute(AttributeDescriptor d, Object o) {
        if (d instanceof GeometryDescriptor) {
            MongoUtil.setDBOValue(this.featureDBO, this.mapper.getGeometryPath(), (Object)this.mapper.toObject((Geometry)o));
        } else {
            MongoUtil.setDBOValue(this.featureDBO, this.mapper.getPropertyPath(d.getLocalName()), Converters.convert((Object)o, (Class)d.getType().getBinding()));
        }
    }

    Object getDBOValue(String path) {
        return MongoUtil.getDBOValue(this.featureDBO, path);
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public List<Object> getAttributes() {
        int aCount = this.getAttributeCount();
        ArrayList<Object> values = new ArrayList<Object>(aCount);
        for (int aIndex = 0; aIndex < aCount; ++aIndex) {
            values.add(this.getAttribute(aIndex));
        }
        return values;
    }

    public void setAttributes(List<Object> values) {
        int index = 0;
        for (Object value : values) {
            this.setAttribute(index++, value);
        }
    }

    public void setAttributes(Object[] values) {
        int index = 0;
        for (Object value : values) {
            this.setAttribute(index++, value);
        }
    }

    public Map<Object, Object> getUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<Object, Object>();
        }
        return this.userData;
    }

    public GeometryAttribute getDefaultGeometryProperty() {
        GeometryDescriptor geometryDescriptor = this.featureType.getGeometryDescriptor();
        GeometryAttributeImpl geometryAttribute = null;
        if (geometryDescriptor != null) {
            Object defaultGeometry = this.getDefaultGeometry();
            geometryAttribute = new GeometryAttributeImpl(defaultGeometry, geometryDescriptor, null);
        }
        return geometryAttribute;
    }

    public void setDefaultGeometryProperty(GeometryAttribute geometryAttribute) {
        if (geometryAttribute != null) {
            this.setDefaultGeometry(geometryAttribute.getValue());
        } else {
            this.setDefaultGeometry(null);
        }
    }

    public Collection<Property> getProperties() {
        throw new UnsupportedOperationException();
    }

    public Collection<Property> getProperties(Name name) {
        throw new UnsupportedOperationException();
    }

    public Collection<Property> getProperties(String name) {
        throw new UnsupportedOperationException();
    }

    public Property getProperty(Name name) {
        throw new UnsupportedOperationException();
    }

    public Property getProperty(String name) {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends Property> getValue() {
        throw new UnsupportedOperationException();
    }

    public void setValue(Collection<Property> value) {
        throw new UnsupportedOperationException();
    }

    public AttributeDescriptor getDescriptor() {
        return new AttributeDescriptorImpl((AttributeType)this.featureType, this.featureType.getName(), 0, Integer.MAX_VALUE, true, null);
    }

    public Name getName() {
        return this.featureType.getName();
    }

    public boolean isNillable() {
        return true;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public void validate() {
    }
}

