/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import org.geotools.data.mongodb.AbstractFilterToMongo;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.complex.JsonSelectAllFunction;
import org.geotools.data.mongodb.complex.JsonSelectFunction;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class FilterToMongo
extends AbstractFilterToMongo {
    final CollectionMapper mapper;
    SimpleFeatureType featureType;

    public FilterToMongo(CollectionMapper mapper) {
        this.mapper = mapper;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    private Class getJsonSelectType(Expression expression) {
        if (expression instanceof JsonSelectFunction) {
            AttributeDescriptor descriptor = this.featureType.getDescriptor(((JsonSelectFunction)expression).getJsonPath());
            return descriptor == null ? null : descriptor.getType().getBinding();
        }
        if (expression instanceof JsonSelectAllFunction) {
            AttributeDescriptor descriptor = this.featureType.getDescriptor(((JsonSelectAllFunction)expression).getJsonPath());
            return descriptor == null ? null : descriptor.getType().getBinding();
        }
        return null;
    }

    @Override
    protected Class<?> getValueTypeInternal(Expression e) {
        AttributeDescriptor attType;
        Class valueType = this.getJsonSelectType(e);
        if (valueType != null) {
            return valueType;
        }
        if (e instanceof PropertyName && this.featureType != null && (attType = (AttributeDescriptor)e.evaluate((Object)this.featureType)) != null) {
            valueType = attType.getType().getBinding();
        }
        return valueType;
    }

    @Override
    protected String getGeometryPath() {
        return this.mapper.getGeometryPath();
    }

    @Override
    protected String getPropertyPath(String prop) {
        return this.mapper.getPropertyPath(prop);
    }
}

