/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb.complex;

import com.mongodb.BasicDBList;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.mongodb.MongoFeature;
import org.geotools.data.mongodb.MongoGeometryBuilder;
import org.geotools.data.mongodb.complex.MongoCollectionFeature;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;

public final class MongoComplexUtilities {
    private static final Logger LOG = Logging.getLogger(MongoComplexUtilities.class);
    private static final boolean USE_LEGACY_PATHS = Boolean.parseBoolean(System.getProperty("org.geotools.data.mongodb.complex.useLegacyPaths", "false"));
    public static final String MONGO_PARENT_PATH = "MONGO_PARENT_PATH";

    private MongoComplexUtilities() {
    }

    public static String resolvePath(Feature feature, String jsonPath) {
        Object parentPath = feature.getUserData().get(MONGO_PARENT_PATH);
        return parentPath == null ? jsonPath : parentPath + "." + jsonPath;
    }

    public static void setParentPath(Feature feature, String parentPath) {
        feature.getUserData().put(MONGO_PARENT_PATH, parentPath);
    }

    public static boolean useLegacyPaths() {
        return USE_LEGACY_PATHS;
    }

    public static Object getValue(Object object, String jsonPath) {
        Feature feature = MongoComplexUtilities.extractFeature(object, jsonPath);
        if (feature instanceof MongoFeature) {
            MongoFeature mongoFeature = (MongoFeature)feature;
            return MongoComplexUtilities.getValue(mongoFeature.getMongoObject(), jsonPath);
        }
        if (feature instanceof MongoCollectionFeature) {
            MongoCollectionFeature collectionFeature = (MongoCollectionFeature)((Object)object);
            return MongoComplexUtilities.getValue(collectionFeature.getMongoFeature().getMongoObject(), collectionFeature.getCollectionsIndexes(), jsonPath);
        }
        throw MongoComplexUtilities.invalidFeature(feature, jsonPath);
    }

    public static Feature extractFeature(Object feature, String jsonPath) {
        if (!(feature instanceof Feature)) {
            throw MongoComplexUtilities.invalidFeature(feature, jsonPath);
        }
        Object mongoFeature = ((Feature)feature).getUserData().get("MONGO_OBJECT_FEATURE");
        return mongoFeature == null ? (Feature)feature : (Feature)mongoFeature;
    }

    private static RuntimeException invalidFeature(Object feature, String jsonPath) {
        return new RuntimeException(String.format("No possible to obtain a mongo object from '%s' to extract '%s'.", feature.getClass(), jsonPath));
    }

    public static Object getValue(DBObject mongoObject, String jsonPath) {
        return MongoComplexUtilities.getValue(mongoObject, Collections.emptyMap(), jsonPath);
    }

    public static Object getValue(DBObject mongoObject, Map<String, Integer> collectionsIndexes, String jsonPath) {
        MongoObjectWalker walker = new MongoObjectWalker(mongoObject, collectionsIndexes, jsonPath);
        return MongoComplexUtilities.convertGeometry(walker.getValue());
    }

    private static Object convertGeometry(Object value) {
        if (!(value instanceof DBObject) || value instanceof List) {
            return value;
        }
        DBObject object = (DBObject)value;
        Set keys = object.keySet();
        if (keys.size() != 2 || !keys.contains("coordinates") || !keys.contains("type")) {
            return value;
        }
        MongoGeometryBuilder builder = new MongoGeometryBuilder();
        try {
            return builder.toGeometry(object);
        }
        catch (Exception exception) {
            return value;
        }
    }

    public static Object getValues(Object object, String jsonPath) {
        Feature feature = MongoComplexUtilities.extractFeature(object, jsonPath);
        if (feature instanceof MongoFeature) {
            MongoFeature mongoFeature = (MongoFeature)feature;
            return MongoComplexUtilities.getValues(mongoFeature.getMongoObject(), jsonPath);
        }
        if (feature instanceof MongoCollectionFeature) {
            MongoCollectionFeature collectionFeature = (MongoCollectionFeature)((Object)object);
            return MongoComplexUtilities.getValues(collectionFeature.getMongoFeature().getMongoObject(), jsonPath);
        }
        throw MongoComplexUtilities.invalidFeature(feature, jsonPath);
    }

    public static Object getValues(DBObject dbObject, String jsonPath) {
        if (jsonPath == null || jsonPath.isEmpty() || dbObject == null) {
            return Collections.emptyList();
        }
        String[] jsonPathParts = jsonPath.split("\\.");
        List<Object> values = MongoComplexUtilities.getValuesHelper(dbObject, jsonPathParts, new ArrayList<Object>(), 0);
        if (values.size() == 1) {
            return values.get(0);
        }
        return values;
    }

    private static List<Object> getValuesHelper(DBObject dbObject, String[] jsonPathParts, List<Object> values, int index) {
        Object object = dbObject.get(jsonPathParts[index]);
        if (object == null) {
            return values;
        }
        boolean finalPath = index == jsonPathParts.length - 1;
        ++index;
        if (object instanceof List) {
            if (finalPath) {
                for (Object value : (List)object) {
                    values.add(MongoComplexUtilities.convertGeometry(value));
                }
            } else {
                for (Object element : (List)object) {
                    MongoComplexUtilities.getValuesHelper((DBObject)element, jsonPathParts, values, index);
                }
            }
        } else if (finalPath) {
            values.add(MongoComplexUtilities.convertGeometry(object));
        } else {
            MongoComplexUtilities.getValuesHelper((DBObject)object, jsonPathParts, values, index);
        }
        return values;
    }

    private static String concatPath(String parentPath, String path) {
        if (parentPath == null || parentPath.isEmpty()) {
            return path;
        }
        return parentPath + "." + path;
    }

    public static Map<String, Class> findMappings(DBObject dbObject) {
        HashMap<String, Class> mappings = new HashMap<String, Class>();
        MongoComplexUtilities.findMappingsHelper(dbObject, "", mappings);
        return mappings;
    }

    public static Map<String, Class> findMappings(DBCursor cursor) {
        HashMap<String, Class> mappings = new HashMap<String, Class>();
        try {
            while (cursor.hasNext()) {
                MongoComplexUtilities.findMappingsHelper(cursor.next(), "", mappings);
            }
        }
        finally {
            cursor.close();
        }
        return mappings;
    }

    private static void findMappingsHelper(Object object, String parentPath, Map<String, Class> mappings) {
        if (object == null) {
            return;
        }
        if (object instanceof DBObject) {
            LOG.log(Level.INFO, "Generating mappings from object: {0}", object);
            DBObject dbObject = (DBObject)object;
            for (String key : dbObject.keySet()) {
                Object value = dbObject.get(key);
                if (value == null) continue;
                String path = MongoComplexUtilities.concatPath(parentPath, key);
                if (value instanceof List) {
                    List list = (List)value;
                    if (list.isEmpty()) continue;
                    for (Object eo : list) {
                        MongoComplexUtilities.findMappingsHelper(eo, path, mappings);
                    }
                    continue;
                }
                if (value instanceof DBObject) {
                    MongoComplexUtilities.findMappingsHelper(value, path, mappings);
                    continue;
                }
                mappings.putIfAbsent(path, value.getClass());
            }
        } else {
            mappings.put(parentPath, object.getClass());
        }
    }

    private static final class MongoObjectWalker {
        private final Map<String, Integer> collectionsIndexes;
        private final String[] jsonPathParts;
        private String currentJsonPath;
        private int currentJsonPathPartIndex;
        private Object currentObject;

        MongoObjectWalker(DBObject mongoObject, Map<String, Integer> collectionsIndexes, String jsonPath) {
            this.collectionsIndexes = collectionsIndexes;
            this.jsonPathParts = jsonPath.split("\\.");
            this.currentJsonPath = "";
            this.currentJsonPathPartIndex = 0;
            this.currentObject = mongoObject;
        }

        Object getValue() {
            while (this.hasNext() && this.currentObject != null) {
                this.next();
            }
            return this.currentObject;
        }

        private boolean hasNext() {
            if (this.isAnEmptyList(this.currentObject)) {
                this.currentObject = null;
                return false;
            }
            return this.currentJsonPathPartIndex < this.jsonPathParts.length || this.currentObject instanceof BasicDBList && this.collectionsIndexes.get(this.currentJsonPath) != null;
        }

        private boolean isAnEmptyList(Object object) {
            BasicDBList list;
            return object instanceof BasicDBList && (list = (BasicDBList)this.currentObject).isEmpty();
        }

        private void next() {
            if (this.currentObject instanceof List) {
                this.currentObject = this.next((List)this.currentObject);
            } else if (this.currentObject instanceof DBObject) {
                this.currentObject = this.next((DBObject)this.currentObject);
            } else {
                throw new RuntimeException(String.format("Trying to get data from a non MongoDB object, current json path is '%s'.", this.currentJsonPath));
            }
        }

        private Object next(DBObject dbObject) {
            this.currentJsonPath = MongoComplexUtilities.concatPath(this.currentJsonPath, this.jsonPathParts[this.currentJsonPathPartIndex]);
            Object result = dbObject.get(this.jsonPathParts[this.currentJsonPathPartIndex]);
            ++this.currentJsonPathPartIndex;
            return result;
        }

        private Object next(List basicDBList) {
            Integer rawCollectionIndex = this.collectionsIndexes.get(this.currentJsonPath);
            if (rawCollectionIndex == null && basicDBList.size() == 1) {
                return basicDBList.get(0);
            }
            if (rawCollectionIndex == null) {
                throw new RuntimeException(String.format("There is no index available for collection '%s'.", this.currentJsonPath));
            }
            return basicDBList.get(rawCollectionIndex);
        }
    }
}

