/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureTypeDBObject {
    static final String KEY_typeName = "typeName";
    static final String KEY_geometryDescriptor = "geometryDescriptor";
    static final String KEY_localName = "localName";
    static final String KEY_crs = "crs";
    static final String KEY_type = "type";
    static final String KEY_properties = "properties";
    static final String KEY_name = "name";
    static final String KEY_defaultValue = "defaultValue";
    static final String KEY_minOccurs = "minOccurs";
    static final String KEY_maxOccurs = "maxOccurs";
    static final String KEY_binding = "binding";
    static final String KEY_attributeDescriptors = "attributeDescriptors";
    static final String KEY_userData = "userData";
    static final String VALUE_name = "name";
    static final String PREFIX_URN_OGC = "urn:ogc:def:crs:";

    public static DBObject convert(SimpleFeatureType ft) {
        DBObject crsDBO;
        BasicDBObject ftDBO = new BasicDBObject(KEY_typeName, (Object)ft.getTypeName());
        Map<String, String> ftUserData = FeatureTypeDBObject.typeCheck(ft.getUserData());
        if (!ftUserData.isEmpty()) {
            ftDBO.put(KEY_userData, (Object)new BasicDBObject(ftUserData));
        }
        GeometryDescriptor gd = ft.getGeometryDescriptor();
        String gdLocalName = gd.getLocalName();
        BasicDBObject gdDBO = new BasicDBObject(KEY_localName, (Object)gdLocalName);
        CoordinateReferenceSystem crs = gd.getCoordinateReferenceSystem();
        if (crs == null) {
            crs = DefaultGeographicCRS.WGS84;
        }
        if ((crsDBO = FeatureTypeDBObject.encodeCRSToGeoJSON(crs)) != null) {
            gdDBO.put(KEY_crs, (Object)crsDBO);
        }
        ftDBO.put(KEY_geometryDescriptor, (Object)gdDBO);
        BasicDBList adDBL = new BasicDBList();
        for (AttributeDescriptor ad : ft.getAttributeDescriptors()) {
            String adLocalName = ad.getLocalName();
            BasicDBObject adDBO = new BasicDBObject(KEY_localName, (Object)adLocalName);
            if (!adLocalName.equals(gdLocalName)) {
                Object dv = ad.getDefaultValue();
                if (dv != null) {
                    adDBO.put(KEY_defaultValue, dv);
                }
                adDBO.put(KEY_minOccurs, (Object)ad.getMinOccurs());
                adDBO.put(KEY_maxOccurs, (Object)ad.getMaxOccurs());
            }
            Class binding = ad instanceof GeometryDescriptor ? Geometry.class : ad.getType().getBinding();
            adDBO.put(KEY_type, (Object)new BasicDBObject(KEY_binding, (Object)binding.getName()));
            Map<String, String> adUserData = FeatureTypeDBObject.typeCheck(ad.getUserData());
            if (!adUserData.isEmpty()) {
                adDBO.put(KEY_userData, (Object)new BasicDBObject(adUserData));
            }
            adDBL.add((Object)adDBO);
        }
        ftDBO.put(KEY_attributeDescriptors, (Object)adDBL);
        return ftDBO;
    }

    public static SimpleFeatureType convert(DBObject ftDBO) {
        return FeatureTypeDBObject.convert(ftDBO, null);
    }

    public static SimpleFeatureType convert(DBObject ftDBO, Name name) {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        if (name == null) {
            ftBuilder.setName(FeatureTypeDBObject.extractString(ftDBO, KEY_typeName));
        } else {
            ftBuilder.setName(name);
        }
        BasicDBObject gdDBO = FeatureTypeDBObject.extractDBObject(ftDBO, KEY_geometryDescriptor);
        String gdLocalName = FeatureTypeDBObject.extractString((DBObject)gdDBO, KEY_localName);
        BasicDBObject crsDBO = FeatureTypeDBObject.extractDBObject((DBObject)gdDBO, KEY_crs, false);
        CoordinateReferenceSystem crs = FeatureTypeDBObject.decodeCRSFromGeoJSON((DBObject)crsDBO);
        if (crs == null) {
            crs = DefaultGeographicCRS.WGS84;
        }
        AttributeTypeBuilder atBuilder = new AttributeTypeBuilder();
        BasicDBList adDBL = FeatureTypeDBObject.extractDBList(ftDBO, KEY_attributeDescriptors);
        for (Object adO : adDBL) {
            Object dv;
            Integer max;
            if (!(adO instanceof DBObject)) continue;
            DBObject adDBO = (DBObject)adO;
            String adLocalName = FeatureTypeDBObject.extractString(adDBO, KEY_localName);
            String bindingName = FeatureTypeDBObject.extractString((DBObject)FeatureTypeDBObject.extractDBObject(adDBO, KEY_type), KEY_binding);
            try {
                atBuilder.binding(Class.forName(bindingName));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Unable to generate Class instance for binding " + bindingName);
            }
            BasicDBObject adUserDataDBO = FeatureTypeDBObject.extractDBObject(adDBO, KEY_userData, false);
            if (adUserDataDBO != null) {
                for (Map.Entry entry : adUserDataDBO.toMap().entrySet()) {
                    atBuilder.userData(entry.getKey(), entry.getValue());
                }
            }
            if (gdLocalName.equals(adLocalName)) {
                atBuilder.crs(crs);
                ftBuilder.add((AttributeDescriptor)atBuilder.buildDescriptor(adLocalName, atBuilder.buildGeometryType()));
                continue;
            }
            Integer min = FeatureTypeDBObject.extractInteger(adDBO, KEY_minOccurs, false);
            if (min != null) {
                atBuilder.minOccurs(min.intValue());
            }
            if ((max = FeatureTypeDBObject.extractInteger(adDBO, KEY_maxOccurs, false)) != null) {
                atBuilder.maxOccurs(max.intValue());
            }
            if ((dv = adDBO.get(KEY_defaultValue)) != null) {
                atBuilder.defaultValue(dv);
            }
            ftBuilder.add(atBuilder.buildDescriptor(adLocalName));
        }
        SimpleFeatureType ft = ftBuilder.buildFeatureType();
        BasicDBObject ftUserDataDBO = FeatureTypeDBObject.extractDBObject(ftDBO, KEY_userData, false);
        if (ftUserDataDBO != null) {
            Map ftUserData = ft.getUserData();
            for (Map.Entry entry : ftUserDataDBO.toMap().entrySet()) {
                ftUserData.put(entry.getKey(), entry.getValue());
            }
        }
        return ft;
    }

    private static Map<String, String> typeCheck(Map<?, ?> map) {
        LinkedHashMap<String, String> typeChecked = new LinkedHashMap<String, String>();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof String) || !(value instanceof String)) continue;
                typeChecked.put((String)key, (String)value);
            }
        }
        return typeChecked;
    }

    private static <T> T extractAndVerifyType(Class<T> type, DBObject dbo, String key, boolean required) {
        Object o = dbo.get(key);
        if (type.isInstance(o)) {
            return type.cast(o);
        }
        if (required) {
            throw new RuntimeException("Unable to extract " + key + " with type " + type.getName());
        }
        return null;
    }

    static BasicDBObject extractDBObject(DBObject dbo, String key) {
        return FeatureTypeDBObject.extractDBObject(dbo, key, true);
    }

    static BasicDBObject extractDBObject(DBObject dbo, String key, boolean required) {
        return FeatureTypeDBObject.extractAndVerifyType(BasicDBObject.class, dbo, key, required);
    }

    static BasicDBList extractDBList(DBObject dbo, String key) {
        return FeatureTypeDBObject.extractDBList(dbo, key, true);
    }

    static BasicDBList extractDBList(DBObject dbo, String key, boolean required) {
        return FeatureTypeDBObject.extractAndVerifyType(BasicDBList.class, dbo, key, required);
    }

    static String extractString(DBObject dbo, String key) {
        return FeatureTypeDBObject.extractString(dbo, key, true);
    }

    static String extractString(DBObject dbo, String key, boolean required) {
        return FeatureTypeDBObject.extractAndVerifyType(String.class, dbo, key, required);
    }

    static Integer extractInteger(DBObject dbo, String key) {
        return FeatureTypeDBObject.extractInteger(dbo, key, true);
    }

    static Integer extractInteger(DBObject dbo, String key, boolean required) {
        return FeatureTypeDBObject.extractAndVerifyType(Integer.class, dbo, key, required);
    }

    static CoordinateReferenceSystem decodeCRSFromGeoJSON(DBObject crsDBO) {
        if (crsDBO == null) {
            return null;
        }
        String type = FeatureTypeDBObject.extractString(crsDBO, KEY_type, false);
        if (type == null || !"name".equals(type)) {
            return null;
        }
        BasicDBObject pDBO = FeatureTypeDBObject.extractDBObject(crsDBO, KEY_properties, false);
        if (pDBO == null) {
            return null;
        }
        String name = FeatureTypeDBObject.extractString((DBObject)pDBO, "name", false);
        if (name == null) {
            return null;
        }
        CoordinateReferenceSystem crs = null;
        if (name.startsWith(PREFIX_URN_OGC)) {
            name = name.substring(PREFIX_URN_OGC.length());
        }
        try {
            crs = CRS.decode((String)name, (boolean)true);
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        return crs;
    }

    static DBObject encodeCRSToGeoJSON(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        Integer epsgCode = null;
        try {
            epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        if (epsgCode == null) {
            return null;
        }
        BasicDBObject crsDBO = new BasicDBObject(KEY_type, (Object)"name");
        crsDBO.put(KEY_properties, (Object)new BasicDBObject("name", (Object)("urn:ogc:def:crs:EPSG:" + epsgCode)));
        return crsDBO;
    }
}

