/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.logging.Logger;
import org.geotools.util.logging.LoggerFactory;

public class DefaultLoggerFactory
extends LoggerFactory<Logger> {
    private static DefaultLoggerFactory factory;

    protected DefaultLoggerFactory() {
        super(Logger.class);
    }

    public static synchronized DefaultLoggerFactory getInstance() {
        if (factory == null) {
            factory = new DefaultLoggerFactory();
        }
        return factory;
    }

    @Override
    protected Logger getImplementation(String name) {
        return Logger.getLogger(name);
    }

    @Override
    protected Logger wrap(String name, Logger implementation) {
        return implementation;
    }

    @Override
    protected Logger unwrap(Logger logger) {
        return logger;
    }

    @Override
    public String lookupConfiguration() {
        String configClass = System.getProperty("java.util.logging.config.class");
        String configFile = System.getProperty("java.util.logging.config.file");
        String javaHome = System.getProperty("java.home");
        if (configClass != null) {
            return configClass;
        }
        if (configFile != null) {
            return configFile;
        }
        if (javaHome != null) {
            return javaHome + "/lib/logging.properties";
        }
        return "java.util.logging";
    }
}

