/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles.mosaic;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.mbtiles.mosaic.MBTilesReader;
import org.geotools.parameter.Parameter;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Test;

public class MBTilesReaderTest {
    @Test
    public void testZoomlevel2() throws IOException {
        MBTilesReader reader = new MBTilesReader((Object)this.getClass().getResource("world_lakes.mbtiles"), null);
        GeneralParameterValue[] parameters = new GeneralParameterValue[1];
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(new Rectangle(500, 500)), (Bounds)new ReferencedEnvelope(0.0, 180.0, -85.0, 0.0, MBTilesReader.WGS_84));
        parameters[0] = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D, (Object)gg);
        GridCoverage2D gc = reader.read(parameters);
        RenderedImage img = gc.getRenderedImage();
        Assert.assertEquals((double)0.0, (double)gc.getEnvelope().getMinimum(0), (double)0.01);
        Assert.assertEquals((double)-2.003750834E7, (double)gc.getEnvelope().getMinimum(1), (double)0.01);
        Assert.assertEquals((double)2.003750834E7, (double)gc.getEnvelope().getMaximum(0), (double)0.01);
        Assert.assertEquals((double)0.0, (double)gc.getEnvelope().getMaximum(1), (double)0.01);
        Assert.assertEquals((long)512L, (long)img.getWidth());
        Assert.assertEquals((long)512L, (long)img.getHeight());
        ImageAssert.assertEquals((File)URLs.urlToFile((URL)this.getClass().getResource("world_lakes.png")), (RenderedImage)img, (int)250);
    }

    @Test
    public void testZoomlevel3() throws IOException {
        MBTilesReader reader = new MBTilesReader((Object)this.getClass().getResource("world_lakes.mbtiles"), null);
        GeneralParameterValue[] parameters = new GeneralParameterValue[1];
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(new Rectangle(500, 500)), (Bounds)new ReferencedEnvelope(0.0, 90.0, -85.0, 0.0, MBTilesReader.WGS_84));
        parameters[0] = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D, (Object)gg);
        GridCoverage2D gc = reader.read(parameters);
        RenderedImage img = gc.getRenderedImage();
        Assert.assertEquals((double)0.0, (double)gc.getEnvelope().getMinimum(0), (double)0.01);
        Assert.assertEquals((double)-2.003750834E7, (double)gc.getEnvelope().getMinimum(1), (double)0.01);
        Assert.assertEquals((double)1.502813125E7, (double)gc.getEnvelope().getMaximum(0), (double)0.01);
        Assert.assertEquals((double)0.0, (double)gc.getEnvelope().getMaximum(1), (double)0.01);
        Assert.assertEquals((long)768L, (long)img.getWidth());
        Assert.assertEquals((long)1024L, (long)img.getHeight());
    }

    @Test
    public void testZoomlevel4() throws IOException {
        MBTilesReader reader = new MBTilesReader((Object)this.getClass().getResource("world_lakes.mbtiles"), null);
        GeneralParameterValue[] parameters = new GeneralParameterValue[1];
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(new Rectangle(500, 500)), (Bounds)new ReferencedEnvelope(0.0, 45.0, -85.0, 0.0, MBTilesReader.WGS_84));
        parameters[0] = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D, (Object)gg);
        GridCoverage2D gc = reader.read(parameters);
        RenderedImage img = gc.getRenderedImage();
        Assert.assertEquals((double)0.0, (double)gc.getEnvelope().getMinimum(0), (double)0.01);
        Assert.assertEquals((double)-2.003750834E7, (double)gc.getEnvelope().getMinimum(1), (double)0.01);
        Assert.assertEquals((double)7514065.62, (double)gc.getEnvelope().getMaximum(0), (double)0.01);
        Assert.assertEquals((double)0.0, (double)gc.getEnvelope().getMaximum(1), (double)0.01);
        Assert.assertEquals((long)768L, (long)img.getWidth());
        Assert.assertEquals((long)2048L, (long)img.getHeight());
    }
}

