/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;

public class MBTilesMetadata {
    private static Logger LOGGER = Logging.getLogger(MBTilesMetadata.class);
    protected static Pattern patternEnvelope = Pattern.compile(" *(\\-?[0-9\\.]*) *, *(\\-?[0-9\\.]*) *, *(\\-?[0-9\\.]*) *, *(\\-?[0-9\\.]*) *");
    protected static Pattern patternCenter = Pattern.compile(" *(\\-?[0-9\\.]*) *, *(\\-?[0-9\\.]*) *, *(\\-?[0-9\\.]*) *");
    protected String name;
    protected String version;
    protected String description;
    protected t_type type;
    protected t_format format;
    protected Bounds bounds;
    protected String attribution;
    protected int minZoom;
    protected int maxZoom;
    protected String json;
    protected double[] center;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public t_type getType() {
        return this.type;
    }

    public void setType(t_type type) {
        this.type = type;
    }

    public t_format getFormat() {
        return this.format;
    }

    public void setFormat(t_format format) {
        this.format = format;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public double[] getCenter() {
        return this.center;
    }

    public void setCenter(double[] center) {
        this.center = center;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public String getTypeStr() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString().toLowerCase();
    }

    public String getFormatStr() {
        if (this.format == null) {
            return null;
        }
        return this.format.toString().toLowerCase();
    }

    public String getBoundsStr() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getMinimum(0) + "," + this.bounds.getMinimum(1) + "," + this.bounds.getMaximum(0) + "," + this.bounds.getMaximum(1);
    }

    public String getCenterStr() {
        if (this.center == null) {
            return null;
        }
        return this.center[0] + "," + this.center[1] + "," + this.center[2];
    }

    public void setTypeStr(String typeStr) {
        if (typeStr == null) {
            this.setType(null);
        } else if (typeStr.equalsIgnoreCase("BASE_LAYER")) {
            LOGGER.log(Level.WARNING, () -> String.format("MBTiles file has invalid type '%s', using '%s' instead", new Object[]{typeStr, t_type.BASE_LAYER}));
            this.setType(t_type.BASE_LAYER);
        } else {
            this.setType(t_type.lookUp(typeStr));
        }
    }

    public void setFormatStr(String formatStr) {
        if (formatStr == null) {
            this.setFormat(null);
        } else {
            this.setFormat(t_format.valueOf(formatStr.toUpperCase()));
        }
    }

    public void setBoundsStr(String boundsStr) {
        if (boundsStr == null) {
            this.setBounds(null);
        } else {
            Matcher matcherEnvelope = patternEnvelope.matcher(boundsStr);
            if (!matcherEnvelope.matches()) {
                throw new IllegalArgumentException("Envelope not in correct format: minx,miny,maxx,maxy");
            }
            double minx = Double.parseDouble(matcherEnvelope.group(1));
            double miny = Double.parseDouble(matcherEnvelope.group(2));
            double maxx = Double.parseDouble(matcherEnvelope.group(3));
            double maxy = Double.parseDouble(matcherEnvelope.group(4));
            try {
                this.setBounds((Bounds)new ReferencedEnvelope(minx, maxx, miny, maxy, CRS.decode((String)"EPSG:4326", (boolean)true)));
            }
            catch (FactoryException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void setCenterStr(String centerStr) {
        if (centerStr == null) {
            this.setCenter(null);
        } else {
            Matcher matcherCenter = patternCenter.matcher(centerStr);
            if (!matcherCenter.matches()) {
                throw new IllegalArgumentException("Center not in correct format: longitude,latitude,zoom level");
            }
            double lon = Double.parseDouble(matcherCenter.group(1));
            double lat = Double.parseDouble(matcherCenter.group(2));
            double zoomLevel = Double.parseDouble(matcherCenter.group(3));
            this.setCenter(new double[]{lon, lat, zoomLevel});
        }
    }

    public void setMinZoomStr(String minZoomStr) {
        this.minZoom = minZoomStr == null ? 0 : Integer.parseInt(minZoomStr);
    }

    public void setMaxZoomStr(String maxZoomStr) {
        this.maxZoom = maxZoomStr == null ? 0 : Integer.parseInt(maxZoomStr);
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public static enum t_format {
        JPG,
        JPEG,
        PNG,
        PBF;

    }

    public static enum t_type {
        OVERLAY("overlay"),
        BASE_LAYER("baselayer");

        public final String identifier;

        private t_type(String identifier) {
            this.identifier = identifier;
        }

        public static t_type lookUp(String s) throws IllegalArgumentException {
            return Arrays.stream(t_type.values()).filter(t -> t.identifier.equalsIgnoreCase(s)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown mbtiles type '%s'", s)));
        }
    }
}

