/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.mbtiles.MBTilesDataStore;
import org.geotools.mbtiles.MBTilesFile;
import org.sqlite.SQLiteConfig;
import org.sqlite.javax.SQLiteConnectionPoolDataSource;

public class MBTilesDataStoreFactory
implements DataStoreFactorySpi {
    private static final String MBTILES_DBTYPE = "mbtiles";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"mbtiles", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param(JDBCDataStoreFactory.USER.key, JDBCDataStoreFactory.USER.type, JDBCDataStoreFactory.USER.description, false, JDBCDataStoreFactory.USER.sample);
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", File.class, "Database", true, null, Collections.singletonMap("ext", "mbtiles"));

    public String getDisplayName() {
        return "MBTiles with vector tiles";
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        LinkedHashMap<String, DataAccessFactory.Param> map = new LinkedHashMap<String, DataAccessFactory.Param>();
        this.setupParameters(map);
        return map.values().toArray(new DataAccessFactory.Param[map.size()]);
    }

    protected void setupParameters(Map<String, DataAccessFactory.Param> parameters) {
        parameters.put(MBTilesDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(MBTilesDataStoreFactory.DATABASE.key, DATABASE);
        parameters.put(JDBCDataStoreFactory.NAMESPACE.key, JDBCDataStoreFactory.NAMESPACE);
        parameters.put(MBTilesDataStoreFactory.USER.key, USER);
        parameters.put(JDBCDataStoreFactory.PASSWD.key, JDBCDataStoreFactory.PASSWD);
    }

    public boolean isAvailable() {
        try {
            Class.forName("org.sqlite.JDBC");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        return null;
    }

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        DataSource ds = (DataSource)JDBCDataStoreFactory.DATASOURCE.lookUp(params);
        if (ds == null) {
            ds = this.createDataSource(params, true);
        }
        String namespace = (String)JDBCDataStoreFactory.NAMESPACE.lookUp(params);
        return new MBTilesDataStore(namespace, new MBTilesFile(ds));
    }

    protected DataSource createDataSource(Map<String, ?> params, boolean readOnly) throws IOException {
        SQLiteConfig config = new SQLiteConfig();
        config.setSharedCache(true);
        config.enableLoadExtension(true);
        if (readOnly) {
            config.setReadOnly(true);
            config.setPragma(SQLiteConfig.Pragma.SYNCHRONOUS, "OFF");
        }
        SQLiteConnectionPoolDataSource ds = new SQLiteConnectionPoolDataSource(config);
        ds.setUrl(this.getJDBCUrl(params));
        return ds;
    }

    private String getJDBCUrl(Map<String, ?> params) throws IOException {
        File db = (File)DATABASE.lookUp(params);
        if (db.getPath().startsWith("file:")) {
            db = new File(db.getPath().substring(5));
        }
        return "jdbc:sqlite:" + db;
    }

    public boolean canProcess(Map<String, ?> params) {
        if (!DataUtilities.canProcess(params, (DataAccessFactory.Param[])this.getParametersInfo())) {
            return false;
        }
        return this.checkDBType(params);
    }

    protected final boolean checkDBType(Map<String, ?> params) {
        try {
            String type = (String)DBTYPE.lookUp(params);
            return MBTILES_DBTYPE.equals(type);
        }
        catch (IOException e) {
            return false;
        }
    }
}

