/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.util.Objects;
import org.geotools.mbtiles.MBTilesTileLocation;

class RectangleLong {
    long minX;
    long maxX;
    long minY;
    long maxY;

    public RectangleLong(long minX, long maxX, long minY, long maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public RectangleLong() {
        this.setToNull();
    }

    public void setToNull() {
        this.minX = 0L;
        this.maxX = -1L;
        this.minY = 0L;
        this.maxY = -1L;
    }

    public long getMinX() {
        return this.minX;
    }

    public void setMinX(long minX) {
        this.minX = minX;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public void setMaxX(long maxX) {
        this.maxX = maxX;
    }

    public long getMinY() {
        return this.minY;
    }

    public void setMinY(long minY) {
        this.minY = minY;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public void setMaxY(long maxY) {
        this.maxY = maxY;
    }

    public String toString() {
        return "RectangleLong{minX=" + this.minX + ", maxX=" + this.maxX + ", minY=" + this.minY + ", maxY=" + this.maxY + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RectangleLong that = (RectangleLong)o;
        return this.minX == that.minX && this.minY == that.minY && this.maxX == that.maxX && this.maxY == that.maxY;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.maxX, this.maxY);
    }

    public void expandToInclude(MBTilesTileLocation loc) {
        if (this.isNull()) {
            this.minX = this.maxX = loc.getTileColumn();
            this.minY = this.maxY = loc.getTileRow();
        } else {
            long x = loc.getTileColumn();
            long y = loc.getTileRow();
            if (x < this.minX) {
                this.minX = x;
            } else if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            } else if (y > this.maxY) {
                this.maxY = y;
            }
        }
    }

    public void expandToInclude(RectangleLong other) {
        if (this.isNull()) {
            this.init(other);
        } else {
            if (other.minX < this.minX) {
                this.minX = other.minX;
            }
            if (other.maxX > this.maxX) {
                this.maxX = other.maxX;
            }
            if (other.minY < this.minY) {
                this.minY = other.minY;
            }
            if (other.maxY > this.maxY) {
                this.maxY = other.maxY;
            }
        }
    }

    protected void init(RectangleLong other) {
        this.minX = other.minX;
        this.maxX = other.maxX;
        this.minY = other.minY;
        this.maxY = other.maxY;
    }

    public RectangleLong intersection(RectangleLong other) {
        if (!this.isNull() && !other.isNull() && this.intersects(other)) {
            long intMinX = this.minX > other.minX ? this.minX : other.minX;
            long intMinY = this.minY > other.minY ? this.minY : other.minY;
            long intMaxX = this.maxX < other.maxX ? this.maxX : other.maxX;
            long intMaxY = this.maxY < other.maxY ? this.maxY : other.maxY;
            return new RectangleLong(intMinX, intMaxX, intMinY, intMaxY);
        }
        return new RectangleLong();
    }

    public boolean intersects(RectangleLong other) {
        if (!this.isNull() && !other.isNull()) {
            return other.minX <= this.maxX && other.maxX >= this.minX && other.minY <= this.maxY && other.maxY >= this.minY;
        }
        return false;
    }

    public boolean isNull() {
        return this.maxX < this.minX || this.maxY < this.minY;
    }

    public void forEach(PositionConsumer consumer) {
        for (long y = this.minY; y <= this.maxY; ++y) {
            for (long x = this.minX; x <= this.maxX; ++x) {
                consumer.accept(x, y);
            }
        }
    }

    @FunctionalInterface
    public static interface PositionConsumer {
        public void accept(long var1, long var3);
    }
}

