/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import no.ecc.vectortile.VectorTileDecoder;
import org.apache.commons.io.IOUtils;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesTile;
import org.geotools.mbtiles.MBTilesTileLocation;
import org.geotools.mbtiles.RectangleLong;
import org.geotools.util.CanonicalSet;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

class MBtilesCache {
    static final Logger LOGGER = Logging.getLogger(MBtilesCache.class);
    CanonicalSet<MBTilesTileLocation> canonicalizer = CanonicalSet.newInstance(MBTilesTileLocation.class);
    SoftValueHashMap<MBTilesTileLocation, Map<String, CollectionProvider>> cache = new SoftValueHashMap(0);
    Map<String, SimpleFeatureType> schemas = new HashMap<String, SimpleFeatureType>();

    public MBtilesCache(Map<String, SimpleFeatureType> schemas) {
        this.schemas = schemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeatureCollection getFeatures(MBTilesTile tile, String layerName) throws IOException {
        MBTilesTileLocation location = (MBTilesTileLocation)this.canonicalizer.unique((Object)tile.toLocation());
        Map<String, CollectionProvider> layers = (Map<String, CollectionProvider>)this.cache.get((Object)location);
        if (layers == null) {
            MBTilesTileLocation mBTilesTileLocation = location;
            synchronized (mBTilesTileLocation) {
                layers = (Map)this.cache.get((Object)location);
                if (layers == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Miss for " + tile + ", looking for layer " + layerName);
                    }
                    Map<String, List<VectorTileDecoder.Feature>> mvtFeaturesMap = this.fillCache(tile);
                    layers = this.mapToProviders(location, mvtFeaturesMap);
                    this.cache.put((Object)location, layers);
                }
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Hit for " + tile + ", looking for layer " + layerName);
        }
        return Optional.ofNullable((CollectionProvider)layers.get(layerName)).map(p -> p.getGeoToolsFeatures()).orElse(null);
    }

    public Map<String, CollectionProvider> mapToProviders(MBTilesTileLocation location, Map<String, List<VectorTileDecoder.Feature>> mvtFeaturesMap) {
        return mvtFeaturesMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> {
            SimpleFeatureType schema = this.schemas.get(e.getKey());
            LayerFeatureBuilder builder = new LayerFeatureBuilder(location, schema);
            return new CollectionProvider((List)e.getValue(), builder);
        }));
    }

    private Map<String, List<VectorTileDecoder.Feature>> fillCache(MBTilesTile tile) throws IOException {
        VectorTileDecoder decoder = new VectorTileDecoder();
        decoder.setAutoScale(false);
        byte[] gzippedData = this.getPbfFromTile(tile);
        HashMap<String, List<VectorTileDecoder.Feature>> result = new HashMap<String, List<VectorTileDecoder.Feature>>();
        for (VectorTileDecoder.Feature mvtFeature : decoder.decode(gzippedData)) {
            String layer = mvtFeature.getLayerName();
            if (this.schemas.get(layer) == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Skipping unknown layer " + layer + " (not described in the json metadata entry)");
                continue;
            }
            List features = result.computeIfAbsent(layer, l -> new ArrayList());
            features.add(mvtFeature);
        }
        return result;
    }

    private byte[] getPbfFromTile(MBTilesTile tile) throws IOException {
        byte[] raw = tile.getData();
        try (GZIPInputStream stream = new GZIPInputStream(new ByteArrayInputStream(raw));){
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
    }

    public Map<MBTilesTileLocation, SimpleFeatureCollection> getCachedFeatures(long z, RectangleLong tb, String layerName) {
        LinkedHashMap<MBTilesTileLocation, SimpleFeatureCollection> result = new LinkedHashMap<MBTilesTileLocation, SimpleFeatureCollection>();
        tb.forEach((x, y) -> {
            MBTilesTileLocation loc = new MBTilesTileLocation(z, x, y);
            Map tileContents = (Map)this.cache.get((Object)loc);
            if (tileContents != null) {
                SimpleFeatureCollection features = null;
                if (tileContents.containsKey(layerName)) {
                    features = ((CollectionProvider)tileContents.get(layerName)).getGeoToolsFeatures();
                } else if (this.schemas.get(layerName) != null) {
                    features = new EmptyFeatureCollection(this.schemas.get(layerName));
                }
                if (features != null) {
                    result.put(loc, features);
                }
            }
        });
        return result;
    }

    private class CollectionProvider {
        List<VectorTileDecoder.Feature> mvtFeatures;
        volatile SimpleFeatureCollection converted;
        LayerFeatureBuilder builder;

        public CollectionProvider(List<VectorTileDecoder.Feature> mvtFeatures, LayerFeatureBuilder builder) {
            this.mvtFeatures = mvtFeatures;
            this.builder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SimpleFeatureCollection getGeoToolsFeatures() {
            if (this.converted == null) {
                CollectionProvider collectionProvider = this;
                synchronized (collectionProvider) {
                    if (this.converted == null) {
                        this.mvtFeatures.stream().forEach(f -> this.builder.addFeature((VectorTileDecoder.Feature)f));
                        this.converted = this.builder.result;
                        this.builder = null;
                        this.mvtFeatures = null;
                    }
                }
            }
            return this.converted;
        }
    }

    private static class GeometryProcessor {
        final AffineTransformation at;
        MBTilesTileLocation tile;
        int extent;

        GeometryProcessor(MBTilesTileLocation tile, int extent) {
            long numberOfTiles = Math.round(Math.pow(2.0, tile.getZoomLevel()));
            double resX = MBTilesFile.WORLD_ENVELOPE.getSpan(0) / (double)numberOfTiles;
            double resY = MBTilesFile.WORLD_ENVELOPE.getSpan(1) / (double)numberOfTiles;
            double offsetX = MBTilesFile.WORLD_ENVELOPE.getMinimum(0);
            double offsetY = MBTilesFile.WORLD_ENVELOPE.getMinimum(1);
            double tx = offsetX + (double)tile.getTileColumn() * resX;
            double ty = offsetY + (double)(tile.getTileRow() + 1L) * resY;
            double mx = resX / (double)extent;
            double my = resY / (double)extent;
            this.at = new AffineTransformation(){

                public void filter(CoordinateSequence seq, int i) {
                    if (seq instanceof CoordinateSequence && i > 0 && i == seq.size() - 1 && seq.getCoordinate(0) == seq.getCoordinate(i)) {
                        return;
                    }
                    super.filter(seq, i);
                }
            };
            this.at.setToScale(mx, -my);
            this.at.translate(tx, ty);
        }

        Geometry process(Geometry screenGeometry) {
            screenGeometry.apply((CoordinateSequenceFilter)this.at);
            return screenGeometry;
        }
    }

    private static class LayerFeatureBuilder {
        private final String featureIdPrefix;
        private final ListFeatureCollection result;
        private final SimpleFeatureBuilder builder;
        private final MBTilesTileLocation tile;
        private final String geometryName;
        private final SimpleFeatureType schema;
        private final Polygon clip;
        private final ReferencedEnvelope tileEnvelope;
        private GeometryProcessor processor;

        LayerFeatureBuilder(MBTilesTileLocation tile, SimpleFeatureType schema) {
            this.geometryName = schema.getGeometryDescriptor().getLocalName();
            String typeName = schema.getTypeName();
            this.featureIdPrefix = this.getFeatureIdPrefix(tile, typeName);
            this.schema = schema;
            this.builder = new SimpleFeatureBuilder(schema);
            this.result = new ListFeatureCollection(schema);
            this.tile = tile;
            this.tileEnvelope = MBTilesFile.toEnvelope(tile);
            this.clip = JTS.toGeometry((ReferencedEnvelope)this.tileEnvelope);
        }

        private String getFeatureIdPrefix(MBTilesTileLocation tile, String typeName) {
            return typeName + "_" + tile.getZoomLevel() + "_" + tile.getTileRow() + "_" + tile.getTileColumn() + ".";
        }

        void addFeature(VectorTileDecoder.Feature mvtFeature) {
            Geometry geometry = this.getGeometry(this.tile, mvtFeature);
            if (geometry == null) {
                return;
            }
            this.builder.set(this.geometryName, (Object)geometry);
            Map attributes = mvtFeature.getAttributes();
            for (AttributeDescriptor ad : this.schema.getAttributeDescriptors()) {
                String attributeName = ad.getLocalName();
                Object value = attributes.get(attributeName);
                if (value == null) continue;
                this.builder.set(attributeName, value);
            }
            SimpleFeature feature = this.builder.buildFeature(this.featureIdPrefix + mvtFeature.getId());
            Envelope geometryEnvelope = geometry.getEnvelopeInternal();
            if (geometryEnvelope.getMinX() < this.tileEnvelope.getMinX() || geometryEnvelope.getMaxX() > this.tileEnvelope.getMaxX() || geometryEnvelope.getMinY() < this.tileEnvelope.getMinY() || geometryEnvelope.getMaxY() > this.tileEnvelope.getMaxY()) {
                feature.getUserData().put(Hints.GEOMETRY_CLIP, this.clip);
            }
            this.result.add(feature);
        }

        private Geometry getGeometry(MBTilesTileLocation tile, VectorTileDecoder.Feature mvtFeature) {
            Geometry screenGeometry = mvtFeature.getGeometry();
            int extent = mvtFeature.getExtent();
            if (this.processor == null || this.processor.extent != extent) {
                this.processor = new GeometryProcessor(tile, extent);
            }
            return this.processor.process(screenGeometry);
        }
    }
}

