/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesTile;
import org.geotools.mbtiles.MBTilesTileLocation;
import org.geotools.mbtiles.MBtilesCache;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class MBTilesFeatureReader
implements SimpleFeatureReader {
    static final Logger LOGGER = Logging.getLogger(MBTilesFeatureReader.class);
    private final MBTilesFile.TileIterator tiles;
    private final SimpleFeatureType schema;
    private final MBtilesCache cache;
    private final Set<MBTilesTileLocation> skipLocations;
    private SimpleFeatureIterator currentIterator;

    public MBTilesFeatureReader(MBTilesFile.TileIterator tiles, SimpleFeatureType schema, MBtilesCache cache, Set<MBTilesTileLocation> skipLocations) {
        this.tiles = tiles;
        this.schema = schema;
        this.cache = cache;
        this.skipLocations = skipLocations;
    }

    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SimpleFeature sf = (SimpleFeature)this.currentIterator.next();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Returning tiled feature " + sf.toString());
        }
        return sf;
    }

    public boolean hasNext() throws IOException {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return true;
        }
        while (this.tiles.hasNext()) {
            SimpleFeatureCollection features;
            MBTilesTile nextTile = this.tiles.next();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Moving to tile: " + nextTile);
            }
            if (this.skipLocations.contains(nextTile) || (features = this.cache.getFeatures(nextTile, this.schema.getTypeName())) == null) continue;
            this.currentIterator = features.features();
            if (this.currentIterator == null || !this.currentIterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.tiles.close();
    }
}

