/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.util.SqlUtil;
import org.geotools.mbtiles.MBTilesDataStoreFactory;
import org.geotools.mbtiles.MBTilesGrid;
import org.geotools.mbtiles.MBTilesMetadata;
import org.geotools.mbtiles.MBTilesTile;
import org.geotools.mbtiles.MBTilesTileLocation;
import org.geotools.mbtiles.RectangleLong;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MBTilesFile
implements AutoCloseable {
    public static final String PRAGMA_JOURNAL_MODE_OFF = "PRAGMA journal_mode=OFF";
    protected final String TABLE_METADATA = "metadata";
    protected final String TABLE_TILES = "tiles";
    protected final String TABLE_GRIDS = "grids";
    protected final String TABLE_GRID_DATA = "grid_data";
    protected final String MD_NAME = "name";
    protected final String MD_TYPE = "type";
    protected final String MD_VERSION = "version";
    protected final String MD_DESCRIPTION = "description";
    protected final String MD_FORMAT = "format";
    protected final String MD_BOUNDS = "bounds";
    protected final String MD_CENTER = "center";
    protected final String MD_ATTRIBUTION = "attribution";
    protected final String MD_MINZOOM = "minzoom";
    protected final String MD_MAXZOOM = "maxzoom";
    protected final String MD_JSON = "json";
    protected static final Logger LOGGER = Logging.getLogger(MBTilesFile.class);
    public static final CoordinateReferenceSystem SPHERICAL_MERCATOR;
    public static final ReferencedEnvelope WORLD_ENVELOPE;
    protected File file;
    protected final DataSource connPool;
    protected boolean disableJournal;

    public MBTilesFile() throws IOException {
        this(File.createTempFile("temp", ".mbtiles"));
    }

    public MBTilesFile(boolean disableJournal) throws IOException {
        this(File.createTempFile("temp", ".mbtiles"), disableJournal);
    }

    public MBTilesFile(File file) throws IOException {
        this(file, null, null, false);
    }

    public MBTilesFile(File file, boolean disableJournal) throws IOException {
        this(file, null, null, disableJournal);
    }

    public MBTilesFile(File file, String user, String passwd, boolean disableJournal) throws IOException {
        this.file = file;
        this.disableJournal = disableJournal;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(MBTilesDataStoreFactory.DATABASE.key, file.getPath());
        params.put(MBTilesDataStoreFactory.DBTYPE.key, (String)MBTilesDataStoreFactory.DBTYPE.sample);
        this.connPool = new MBTilesDataStoreFactory().createDataSource(params, false);
    }

    public MBTilesFile(DataSource dataSource) {
        this.connPool = dataSource;
    }

    public void saveMetaData(MBTilesMetadata metaData) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            this.saveMetaDataEntry("name", metaData.getName(), cx);
            this.saveMetaDataEntry("version", metaData.getVersion(), cx);
            this.saveMetaDataEntry("description", metaData.getDescription(), cx);
            this.saveMetaDataEntry("attribution", metaData.getAttribution(), cx);
            this.saveMetaDataEntry("type", metaData.getTypeStr(), cx);
            this.saveMetaDataEntry("format", metaData.getFormatStr(), cx);
            this.saveMetaDataEntry("bounds", metaData.getBoundsStr(), cx);
            this.saveMetaDataEntry("center", metaData.getCenterStr(), cx);
            this.saveMetaDataEntry("minzoom", String.valueOf(metaData.getMinZoom()), cx);
            this.saveMetaDataEntry("maxzoom", String.valueOf(metaData.getMaxZoom()), cx);
            this.saveMetaDataEntry("json", String.valueOf(metaData.getJson()), cx);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void saveMinMaxZoomMetadata(int min, int max) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            this.saveMetaDataEntry("minzoom", String.valueOf(min), cx);
            this.saveMetaDataEntry("maxzoom", String.valueOf(max), cx);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void saveTile(MBTilesTile entry) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            if (this.disableJournal) {
                this.disableJournal(cx);
            }
            if (entry.getData() != null) {
                try (PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("INSERT OR REPLACE INTO %s VALUES (?,?,?,?)", "tiles")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).set(entry.getData()).log(Level.FINE).statement();){
                    ps.execute();
                }
            }
            try (PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("DELETE FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=?", "tiles")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).log(Level.FINE).statement();){
                ps.execute();
            }
            this.saveMinMaxZoomMetadata((int)Math.min(entry.getZoomLevel(), this.minZoom()), (int)Math.max(entry.getZoomLevel(), this.maxZoom()));
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void saveGrid(MBTilesGrid entry) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            PreparedStatement ps;
            if (entry.getGrid() != null) {
                ps = SqlUtil.prepare((Connection)cx, (String)String.format("INSERT OR REPLACE INTO %s VALUES (?,?,?,?)", "grids")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).set(entry.getGrid()).log(Level.FINE).statement();
                try {
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            ps = SqlUtil.prepare((Connection)cx, (String)String.format("DELETE FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=?", "grids")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).log(Level.FINE).statement();
            try {
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            for (Map.Entry<String, String> gridDataEntry : entry.getGridData().entrySet()) {
                PreparedStatement ps2;
                if (gridDataEntry.getValue() != null) {
                    ps2 = SqlUtil.prepare((Connection)cx, (String)String.format("INSERT OR REPLACE INTO %s VALUES (?,?,?,?,?)", "grid_data")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).set(gridDataEntry.getKey()).set(gridDataEntry.getValue()).log(Level.FINE).statement();
                    try {
                        ps2.execute();
                        continue;
                    }
                    finally {
                        if (ps2 != null) {
                            ps2.close();
                        }
                        continue;
                    }
                }
                ps2 = SqlUtil.prepare((Connection)cx, (String)String.format("DELETE FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=? AND key_name=?", "grid_data")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).set(gridDataEntry.getKey()).log(Level.FINE).statement();
                try {
                    ps2.execute();
                }
                finally {
                    if (ps2 == null) continue;
                    ps2.close();
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public MBTilesMetadata loadMetaData() throws IOException {
        return this.loadMetaData(new MBTilesMetadata());
    }

    public MBTilesMetadata loadMetaData(MBTilesMetadata metaData) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            metaData.setName(this.loadMetaDataEntry("name", cx));
            metaData.setVersion(this.loadMetaDataEntry("version", cx));
            metaData.setDescription(this.loadMetaDataEntry("description", cx));
            metaData.setAttribution(this.loadMetaDataEntry("attribution", cx));
            metaData.setTypeStr(this.loadMetaDataEntry("type", cx));
            metaData.setFormatStr(this.loadMetaDataEntry("format", cx));
            metaData.setCenterStr(this.loadMetaDataEntry("center", cx));
            metaData.setBoundsStr(this.loadMetaDataEntry("bounds", cx));
            metaData.setMinZoomStr(this.loadMetaDataEntry("minzoom", cx));
            metaData.setMaxZoomStr(this.loadMetaDataEntry("maxzoom", cx));
            metaData.setJson(this.loadMetaDataEntry("json", cx));
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return metaData;
    }

    public MBTilesTile loadTile(long zoomLevel, long column, long row) throws IOException {
        return this.loadTile(new MBTilesTile(zoomLevel, column, row));
    }

    public MBTilesTile loadTile(MBTilesTile entry) throws IOException {
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT tile_data FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=?", "tiles")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).log(Level.FINE).statement();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                entry.setData(rs.getBytes(1));
            } else {
                entry.setData(null);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return entry;
    }

    public MBTilesGrid loadGrid(long zoomLevel, long column, long row) throws IOException {
        return this.loadGrid(new MBTilesGrid(zoomLevel, column, row));
    }

    public MBTilesGrid loadGrid(MBTilesGrid entry) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            ResultSet rs;
            try (PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT grid FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=?", "grids")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).log(Level.FINE).statement();){
                rs = ps.executeQuery();
                try {
                    if (rs.next()) {
                        entry.setGrid(rs.getBytes(1));
                    } else {
                        entry.setGrid(null);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT key_name, key_json FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=?", "grid_data")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).log(Level.FINE).statement();
            try {
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        entry.setGridDataKey(rs.getString(1), rs.getString(2));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return entry;
    }

    public TileIterator tiles() throws SQLException {
        Connection cx = null;
        Statement st = null;
        try {
            cx = this.connPool.getConnection();
            st = cx.createStatement();
            return new TileIterator(st.executeQuery("SELECT * FROM tiles;"), st, cx);
        }
        catch (SQLException e) {
            this.close(st);
            this.close(cx);
            throw e;
        }
    }

    private void close(Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to close statement", e);
        }
    }

    private void close(Connection cx) {
        try {
            if (cx != null) {
                cx.close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to close connection", e);
        }
    }

    public TileIterator tiles(long zoomLevel) throws SQLException {
        Connection cx = null;
        PreparedStatement ps = null;
        try {
            cx = this.connPool.getConnection();
            ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT * FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
            return new TileIterator(ps.executeQuery(), ps, cx);
        }
        catch (Exception e) {
            this.close(ps);
            this.close(cx);
            throw e;
        }
    }

    public TileIterator tiles(long zoomLevel, long leftTile, long bottomTile, long rightTile, long topTile) throws SQLException {
        Connection cx = null;
        PreparedStatement ps = null;
        try {
            cx = this.connPool.getConnection();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Reading tiles at zoom level " + zoomLevel + ", col range " + leftTile + "/" + rightTile + ", row range " + bottomTile + "/" + topTile);
            }
            ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT * FROM %s WHERE zoom_level=? AND tile_column >= ? AND tile_row >= ? AND tile_column <= ? AND tile_row <= ?", "tiles")).set(Long.valueOf(zoomLevel)).set(Long.valueOf(leftTile)).set(Long.valueOf(bottomTile)).set(Long.valueOf(rightTile)).set(Long.valueOf(topTile)).statement();
            return new TileIterator(ps.executeQuery(), ps, cx);
        }
        catch (Exception e) {
            this.close(cx);
            this.close(ps);
            throw e;
        }
    }

    public int numberOfTiles() throws SQLException {
        int size;
        try (Connection cx = this.connPool.getConnection();
             Statement st = cx.createStatement();
             ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM tiles;");){
            if (!rs.next()) {
                throw new SQLException("Tiles count did not return any row");
            }
            size = rs.getInt(1);
        }
        return size;
    }

    public int numberOfTiles(long zoomLevel) throws SQLException {
        int size;
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT COUNT(*) FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
             ResultSet rs = ps.executeQuery();){
            if (!rs.next()) {
                throw new SQLException("Zoom level count did not return any row");
            }
            size = rs.getInt(1);
        }
        return size;
    }

    public long closestZoom(long zoomLevel) throws SQLException {
        long zoom = 0L;
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT zoom_level FROM %s ORDER BY abs(zoom_level - ?)", "tiles")).set(Long.valueOf(zoomLevel)).statement();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                zoom = rs.getLong(1);
            }
        }
        return zoom;
    }

    public long minZoom() throws SQLException {
        long zoom = 0L;
        try (Connection cx = this.connPool.getConnection();
             Statement st = cx.createStatement();
             ResultSet rs = st.executeQuery("SELECT MIN(zoom_level) FROM tiles");){
            if (rs.next()) {
                zoom = rs.getLong(1);
            }
        }
        return zoom;
    }

    public long maxZoom() throws SQLException {
        long zoom = 0L;
        try (Connection cx = this.connPool.getConnection();
             Statement st = cx.createStatement();
             ResultSet rs = st.executeQuery("SELECT MAX(zoom_level) FROM tiles");){
            if (rs.next()) {
                zoom = rs.getLong(1);
            }
        }
        return zoom;
    }

    public long minColumn(long zoomLevel) throws SQLException {
        long size = 0L;
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT MIN(tile_column) FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                size = rs.getLong(1);
            }
        }
        return size;
    }

    public long maxColumn(long zoomLevel) throws SQLException {
        long size = Long.MAX_VALUE;
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT MAX(tile_column) FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                size = rs.getLong(1);
            }
        }
        return size;
    }

    public long minRow(long zoomLevel) throws SQLException {
        long size = 0L;
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT MIN(tile_row) FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                size = rs.getLong(1);
            }
        }
        return size;
    }

    public long maxRow(long zoomLevel) throws SQLException {
        long size = Long.MAX_VALUE;
        try (Connection cx = this.connPool.getConnection();
             PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT MAX(tile_row) FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                size = rs.getLong(1);
            }
        }
        return size;
    }

    @Override
    public void close() {
        try {
            if (this.connPool instanceof BasicDataSource) {
                ((BasicDataSource)this.connPool).close();
            } else if (this.connPool instanceof ManageableDataSource) {
                ((ManageableDataSource)this.connPool).close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error closing database connection", e);
        }
    }

    public File getFile() {
        return this.file;
    }

    protected void saveMetaDataEntry(String name, String value, Connection cx) throws SQLException {
        if (this.disableJournal) {
            this.disableJournal(cx);
        }
        if (value != null) {
            try (PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("INSERT OR REPLACE INTO %s VALUES (?,?)", "metadata")).set(name).set(value).log(Level.FINE).statement();){
                ps.execute();
            }
        }
        try (PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("DELETE FROM %s WHERE NAME = ?", "metadata")).set(name).log(Level.FINE).statement();){
            ps.execute();
        }
    }

    protected String loadMetaDataEntry(String name, Connection cx) throws SQLException {
        try (PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT VALUE FROM %s WHERE NAME = ?", "metadata")).set(name).log(Level.FINE).statement();){
            String string;
            block13: {
                ResultSet rs = ps.executeQuery();
                try {
                    String result = null;
                    if (rs.next()) {
                        result = rs.getString(1);
                    }
                    string = result;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return string;
        }
    }

    public void init() throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            this.init(cx);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected void init(Connection cx) throws SQLException {
        this.runScript("mbtiles.sql", cx);
    }

    protected void runScript(String filename, Connection cx) throws SQLException {
        SqlUtil.runScript((InputStream)this.getClass().getResourceAsStream(filename), (Connection)cx);
    }

    private void disableJournal(Connection cx) throws SQLException {
        try (PreparedStatement prepared = SqlUtil.prepare((Connection)cx, (String)PRAGMA_JOURNAL_MODE_OFF).statement();){
            prepared.execute();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected RectangleLong toTilesRectangle(Envelope envelope, long zoomLevel) throws SQLException {
        long numberOfTiles = MBTilesFile.tilesForZoom(zoomLevel);
        double resX = WORLD_ENVELOPE.getSpan(0) / (double)numberOfTiles;
        double resY = WORLD_ENVELOPE.getSpan(1) / (double)numberOfTiles;
        double offsetX = WORLD_ENVELOPE.getMinimum(0);
        double offsetY = WORLD_ENVELOPE.getMinimum(1);
        long minTileX = Math.round(Math.floor((envelope.getMinX() - offsetX) / resX));
        long maxTileX = Math.round(Math.floor((envelope.getMaxX() - offsetX) / resX));
        long minTileY = Math.round(Math.floor((envelope.getMinY() - offsetY) / resY));
        long maxTileY = Math.round(Math.floor((envelope.getMaxY() - offsetY) / resY));
        return new RectangleLong(minTileX, maxTileX, minTileY, maxTileY);
    }

    protected static long tilesForZoom(long zoomLevel) {
        return Math.round(Math.pow(2.0, zoomLevel));
    }

    protected RectangleLong getTileBounds(long zoomLevel, boolean exact) throws SQLException {
        if (exact) {
            long minRow = this.minRow(zoomLevel);
            long maxRow = this.maxRow(zoomLevel);
            long minCol = this.minColumn(zoomLevel);
            long maxCol = this.maxColumn(zoomLevel);
            return new RectangleLong(minCol, maxCol, minRow, maxRow);
        }
        long tiles = MBTilesFile.tilesForZoom(zoomLevel);
        return new RectangleLong(0L, tiles - 1L, 0L, tiles - 1L);
    }

    protected long getZoomLevel(double distance) throws SQLException {
        long maxZoom = this.maxZoom();
        long numberOfTiles = MBTilesFile.tilesForZoom(maxZoom);
        double span = WORLD_ENVELOPE.getSpan(0) / (double)numberOfTiles;
        double pxSize = span / 256.0;
        long z = maxZoom;
        while (z > 0L) {
            if (pxSize > distance) {
                return z;
            }
            --z;
            pxSize *= 2.0;
        }
        return 0L;
    }

    protected ReferencedEnvelope toEnvelope(RectangleLong rect, long zoom) {
        long numberOfTiles = MBTilesFile.tilesForZoom(zoom);
        double spanX = WORLD_ENVELOPE.getSpan(0) / (double)numberOfTiles;
        double spanY = WORLD_ENVELOPE.getSpan(1) / (double)numberOfTiles;
        double minX = (double)rect.getMinX() * spanX + WORLD_ENVELOPE.getMinX();
        double maxX = (double)rect.getMaxX() * spanX + WORLD_ENVELOPE.getMinX();
        double minY = (double)rect.getMinX() * spanY + WORLD_ENVELOPE.getMinY();
        double maxY = (double)rect.getMaxX() * spanY + WORLD_ENVELOPE.getMinY();
        return new ReferencedEnvelope(minX, maxX, minY, maxY, SPHERICAL_MERCATOR);
    }

    protected static ReferencedEnvelope toEnvelope(MBTilesTileLocation tile) {
        long numberOfTiles = MBTilesFile.tilesForZoom(tile.getZoomLevel());
        double spanX = WORLD_ENVELOPE.getSpan(0) / (double)numberOfTiles;
        double spanY = WORLD_ENVELOPE.getSpan(1) / (double)numberOfTiles;
        double minX = (double)tile.getTileColumn() * spanX + WORLD_ENVELOPE.getMinX();
        double maxX = minX + spanX;
        double minY = (double)tile.getTileRow() * spanY + WORLD_ENVELOPE.getMinY();
        double maxY = minY + spanY;
        return new ReferencedEnvelope(minX, maxX, minY, maxY, SPHERICAL_MERCATOR);
    }

    static {
        try {
            SPHERICAL_MERCATOR = CRS.decode((String)"EPSG:3857", (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        WORLD_ENVELOPE = new ReferencedEnvelope(-2.003750834E7, 2.003750834E7, -2.003750834E7, 2.003750834E7, SPHERICAL_MERCATOR);
    }

    public class TileIterator
    implements Iterator<MBTilesTile>,
    Closeable {
        ResultSet rs;
        Statement st;
        Connection cx;
        Boolean next = null;

        TileIterator(ResultSet rs, Statement st, Connection cx) {
            this.rs = rs;
            this.st = st;
            this.cx = cx;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                try {
                    this.next = this.rs.next();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.next;
        }

        @Override
        public MBTilesTile next() {
            try {
                MBTilesTile entry = new MBTilesTile(this.rs.getLong(1), this.rs.getLong(2), this.rs.getLong(3));
                entry.setData(this.rs.getBytes(4));
                MBTilesTile mBTilesTile = entry;
                return mBTilesTile;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            try {
                try {
                    this.rs.close();
                }
                finally {
                    try {
                        this.st.close();
                    }
                    finally {
                        this.cx.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }
}

