/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.data.DataSourceException;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.mbtiles.MBTilesFeatureSource;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesMetadata;
import org.geotools.mbtiles.MBtilesCache;
import org.geotools.mbtiles.VectorLayerMetadata;
import org.geotools.mbtiles.VectorLayersMetadata;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MBTilesDataStore
extends ContentDataStore {
    static final Logger LOGGER;
    private static final int MAX_ATTEMPTS = 1000;
    protected static final CoordinateReferenceSystem DEFAULT_CRS;
    private final MBtilesCache tileCache;
    MBTilesFile mbtiles;
    LinkedHashMap<String, SimpleFeatureType> schemas;

    public MBTilesDataStore(MBTilesFile mbtiles) throws IOException {
        this(null, mbtiles);
    }

    public MBTilesDataStore(String namespaceURI, MBTilesFile mbtiles) throws IOException {
        this.namespaceURI = namespaceURI;
        this.mbtiles = mbtiles;
        MBTilesMetadata metadata = mbtiles.loadMetaData();
        if (!MBTilesMetadata.t_format.PBF.equals((Object)metadata.getFormat())) {
            throw new DataSourceException("Expected 'PBF' as the format, but found " + String.valueOf((Object)metadata.getFormat()));
        }
        if (metadata.getJson() == null) {
            throw new DataSourceException("Cannot find 'json' metadata field, required to load the layers and their structure");
        }
        try {
            LinkedHashMap<String, VectorLayerMetadata> layersMap = VectorLayersMetadata.parseMetadata(metadata.getJson()).getLayersMap();
            this.schemas = new LinkedHashMap();
            for (String layerName : layersMap.keySet()) {
                VectorLayerMetadata lm = layersMap.get(layerName);
                this.schemas.put(layerName, this.buildFeatureType(lm));
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Could not parse the 'json' metadata field, failed to initialize the store", (Throwable)e);
        }
        this.tileCache = new MBtilesCache(this.schemas);
    }

    private SimpleFeatureType buildFeatureType(VectorLayerMetadata layerMetadata) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(layerMetadata.getId());
        tb.setNamespaceURI(this.namespaceURI);
        LinkedHashMap<String, Class> fieldBindings = layerMetadata.getFieldBindings();
        fieldBindings.entrySet().forEach(e -> tb.add((String)e.getKey(), (Class)e.getValue()));
        String geometryName = this.guessGeometryName(fieldBindings.keySet());
        tb.add(geometryName, Geometry.class, DEFAULT_CRS);
        return tb.buildFeatureType();
    }

    private String guessGeometryName(Set<String> attributeNames) {
        Object geometryName = "the_geom";
        for (int i = 0; i < 1000 && attributeNames.contains(geometryName); ++i) {
            geometryName = (String)geometryName + i;
        }
        if (attributeNames.contains(geometryName)) {
            throw new RuntimeException("Unexpected, could not find a unique geometry name after appending the first 1000 integers to 'the_geom'");
        }
        return geometryName;
    }

    protected List<Name> createTypeNames() throws IOException {
        return this.schemas.keySet().stream().map(id -> new NameImpl(this.getNamespaceURI(), id)).collect(Collectors.toList());
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        SimpleFeatureType schema = this.schemas.get(entry.getTypeName());
        return new MBTilesFeatureSource(entry, schema, this.mbtiles, this.tileCache);
    }

    static {
        CoordinateReferenceSystem crs;
        LOGGER = Logging.getLogger(MBTilesDataStore.class);
        try {
            crs = CRS.decode((String)"EPSG:3857", (boolean)true);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, "Could not initialize web mercator, geometry fields will use an engineering CRS", e);
            crs = DefaultEngineeringCRS.GENERIC_2D;
        }
        DEFAULT_CRS = crs;
    }
}

