/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.locationtech.jts.geom.Envelope;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Or;

class ExtractMultiBoundsFilterVisitor
extends ExtractBoundsFilterVisitor {
    static final ExtractMultiBoundsFilterVisitor INSTANCE = new ExtractMultiBoundsFilterVisitor();

    ExtractMultiBoundsFilterVisitor() {
    }

    public static List<Envelope> getBounds(Filter filter) {
        Object result = filter.accept((FilterVisitor)INSTANCE, null);
        if (result instanceof List) {
            return (List)result;
        }
        if (result instanceof Envelope) {
            return Collections.singletonList((Envelope)result);
        }
        return Collections.emptyList();
    }

    public Object visit(And filter, Object data) {
        ArrayList<List> envelopes = new ArrayList<List>();
        for (Filter f : filter.getChildren()) {
            Object object = f.accept((FilterVisitor)this, data);
            if (object instanceof Envelope) {
                envelopes.add(Collections.singletonList((Envelope)object));
                continue;
            }
            if (!(object instanceof List)) continue;
            List list = (List)object;
            envelopes.add(list);
        }
        if (envelopes.isEmpty()) {
            return new Envelope();
        }
        ArrayList result = null;
        for (ArrayList arrayList : envelopes) {
            if (result == null) {
                result = arrayList;
                continue;
            }
            HashSet<Envelope> intersections = new HashSet<Envelope>();
            for (Envelope ce : arrayList) {
                for (Envelope re : result) {
                    if (!re.intersects(ce)) continue;
                    intersections.add(re.intersection(ce));
                }
            }
            if (intersections.isEmpty()) {
                return new Envelope();
            }
            result = new ArrayList(intersections);
        }
        return result;
    }

    public Object visit(Or filter, Object data) {
        ArrayList<Envelope> envelopes = new ArrayList<Envelope>();
        for (Filter f : filter.getChildren()) {
            Object result = f.accept((FilterVisitor)this, data);
            if (result instanceof Envelope) {
                envelopes.add((Envelope)result);
                continue;
            }
            if (!(result instanceof List)) continue;
            List list = (List)result;
            envelopes.addAll(list);
        }
        ArrayList<Envelope> result = new ArrayList<Envelope>();
        for (Envelope envelope : envelopes) {
            if (result.isEmpty()) {
                result.add(envelope);
                continue;
            }
            boolean mergedAny = false;
            do {
                mergedAny = false;
                ListIterator it = result.listIterator();
                while (it.hasNext()) {
                    Envelope next = (Envelope)it.next();
                    if (!next.intersects(envelope)) continue;
                    it.remove();
                    envelope.expandToInclude(next);
                    mergedAny = true;
                }
            } while (mergedAny);
            result.add(envelope);
        }
        return result;
    }
}

