/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.geotools.data.simple.SimpleFeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class CompositeSimpleFeatureReader
implements SimpleFeatureReader {
    private final List<ReaderSupplier> readerSuppliers;
    private SimpleFeatureReader reader;
    private final SimpleFeatureType schema;

    public CompositeSimpleFeatureReader(SimpleFeatureType schema, List<ReaderSupplier> readerSuppliers) throws IOException {
        this.schema = schema;
        this.readerSuppliers = readerSuppliers;
        this.reader = readerSuppliers.remove(0).get();
    }

    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (SimpleFeature)this.reader.next();
    }

    public boolean hasNext() throws IOException {
        if (this.reader == null) {
            return false;
        }
        while (!this.reader.hasNext() && !this.readerSuppliers.isEmpty()) {
            this.reader.close();
            this.reader = this.readerSuppliers.remove(0).get();
        }
        if (!this.reader.hasNext()) {
            this.reader.close();
            this.reader = null;
            return false;
        }
        return true;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @FunctionalInterface
    public static interface ReaderSupplier {
        @Nonnull
        public SimpleFeatureReader get() throws IOException;
    }
}

