/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.geotools.data.FeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.mbtiles.MBTilesDataStore;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.URLs;
import org.geotools.xml.styling.SLDParser;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MBTilesRenderTest {
    @BeforeClass
    public static void setupCRS() {
        MapProjection.SKIP_SANITY_CHECKS = true;
    }

    @AfterClass
    public static void resetCRS() {
        MapProjection.SKIP_SANITY_CHECKS = false;
    }

    @Test
    public void testRender() throws IOException {
        URL styleResource = MBTilesRenderTest.class.getResource("generic.sld");
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = new SLDParser(styleFactory, styleResource).parseSLD();
        Style style = ((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0];
        MapContent mc = new MapContent();
        File file = URLs.urlToFile((URL)this.getClass().getResource("madagascar.mbtiles"));
        MBTilesDataStore store = new MBTilesDataStore(new MBTilesFile(file));
        for (String typeName : store.getTypeNames()) {
            ContentFeatureSource fs = store.getFeatureSource(typeName);
            mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs, style));
        }
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        int w = 300;
        int h = 500;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        renderer.paint(g, new Rectangle(0, 0, w, h), new ReferencedEnvelope(4700000.0, 5700000.0, -3000000.0, -1300000.0, MBTilesDataStore.DEFAULT_CRS));
        g.dispose();
        File expected = new File("src/test/resources/org/geotools/mbtiles/madagascar.png");
        ImageAssert.assertEquals((File)expected, (RenderedImage)image, (int)((int)((double)(w * h) * 0.05)));
    }

    @Test
    public void testRenderReprojected() throws IOException, FactoryException {
        URL styleResource = MBTilesRenderTest.class.getResource("generic.sld");
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = new SLDParser(styleFactory, styleResource).parseSLD();
        Style style = ((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0];
        MapContent mc = new MapContent();
        File file = URLs.urlToFile((URL)this.getClass().getResource("madagascar.mbtiles"));
        MBTilesDataStore store = new MBTilesDataStore(new MBTilesFile(file));
        for (String typeName : store.getTypeNames()) {
            ContentFeatureSource fs = store.getFeatureSource(typeName);
            mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs, style));
        }
        CoordinateReferenceSystem utm32s = CRS.decode((String)"EPSG:32732", (boolean)true);
        mc.getViewport().setCoordinateReferenceSystem(utm32s);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        int w = 300;
        int h = 500;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        renderer.paint(g, new Rectangle(0, 0, w, h), new ReferencedEnvelope(4000000.0, 5500000.0, 6400000.0, 8400000.0, utm32s));
        g.dispose();
        File expected = new File("src/test/resources/org/geotools/mbtiles/madagascar_reprojected.png");
        ImageAssert.assertEquals((File)expected, (RenderedImage)image, (int)((int)((double)(w * h) * 0.05)));
    }

    @Test
    public void testTransformWithGeneralizationHint() throws Exception {
        Style style = this.getStyle("transformation_water.sld");
        File file = URLs.urlToFile((URL)this.getClass().getResource("madagascar.mbtiles"));
        MBTilesDataStore store = new MBTilesDataStore(new MBTilesFile(file));
        ContentFeatureSource fs = store.getFeatureSource("water");
        FeatureLayer layer = new FeatureLayer((FeatureCollection)fs.getFeatures(), style);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)layer);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setGeneralizationDistance(50.0);
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        int w = 300;
        int h = 500;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        renderer.paint(g, new Rectangle(0, 0, w, h), new ReferencedEnvelope(4700000.0, 5700000.0, -3000000.0, -1300000.0, MBTilesDataStore.DEFAULT_CRS));
        g.dispose();
        File expected = new File("src/test/resources/org/geotools/mbtiles/overgeneralized_madagascar.png");
        ImageAssert.assertEquals((File)expected, (RenderedImage)image, (int)((int)((double)(w * h) * 0.05)));
    }

    @Test
    public void testTransformWithMBTilesWithBuffer() throws Exception {
        Style styleTransformation = this.getStyle("transformation_many_points.sld");
        Style styleNoTransformation = this.getStyle("many_points.sld");
        File file = URLs.urlToFile((URL)this.getClass().getResource("manypoints_test.mbtiles"));
        MBTilesDataStore store = new MBTilesDataStore(new MBTilesFile(file));
        int w = 440;
        int h = 330;
        ContentFeatureSource fs = store.getFeatureSource("manypoints_test");
        ReferencedEnvelope bbox = new ReferencedEnvelope(4254790.681588205, 4619242.456803064, 4701182.96838953, 4977579.240638782, MBTilesDataStore.DEFAULT_CRS);
        BufferedImage transformationImg = this.getImage(w, h, bbox, (FeatureSource)fs, styleTransformation);
        BufferedImage noTransformationImg = this.getImage(w, h, bbox, (FeatureSource)fs, styleNoTransformation);
        File expectedT = new File("src/test/resources/org/geotools/mbtiles/many_points_transformed.png");
        File expected = new File("src/test/resources/org/geotools/mbtiles/many_points.png");
        ImageAssert.assertEquals((File)expectedT, (RenderedImage)transformationImg, (int)((int)((double)(w * h) * 0.05)));
        ImageAssert.assertEquals((File)expected, (RenderedImage)noTransformationImg, (int)((int)((double)(w * h) * 0.05)));
        int i = 155;
        for (int j = 154; j < 166; ++j) {
            Color noTrans = this.getPixelColor(i, j, noTransformationImg);
            Color tansformed = this.getPixelColor(i, j, transformationImg);
            Assert.assertNotEquals((Object)noTrans, (Object)tansformed);
        }
    }

    private Style getStyle(String fileName) throws IOException {
        URL styleResource = MBTilesRenderTest.class.getResource(fileName);
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = new SLDParser(styleFactory, styleResource).parseSLD();
        return ((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0];
    }

    private BufferedImage getImage(int w, int h, ReferencedEnvelope bbox, FeatureSource fs, Style style) {
        FeatureLayer layer = new FeatureLayer(fs, style);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)layer);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        renderer.paint(g, new Rectangle(0, 0, w, h), bbox);
        g.dispose();
        mc.dispose();
        return image;
    }

    private Color getPixelColor(int i, int j, BufferedImage img) {
        ColorModel cm = img.getColorModel();
        WritableRaster raster = img.getRaster();
        Object pixel = raster.getDataElements(i, j, null);
        Color actual = cm.hasAlpha() ? new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), cm.getAlpha(pixel)) : new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), 255);
        return actual;
    }
}

