/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.data.DataUtilities;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.mbtiles.CompositeSimpleFeatureReader;
import org.geotools.mbtiles.ExtractMultiBoundsFilterVisitor;
import org.geotools.mbtiles.MBTilesDataStore;
import org.geotools.mbtiles.MBTilesFeatureReader;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesTileLocation;
import org.geotools.mbtiles.MBtilesCache;
import org.geotools.mbtiles.RectangleLong;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class MBTilesFeatureSource
extends ContentFeatureSource {
    static final Logger LOGGER = Logging.getLogger(MBTilesFeatureSource.class);
    private final MBTilesFile mbtiles;
    private final MBtilesCache tileCache;

    public MBTilesFeatureSource(ContentEntry entry, SimpleFeatureType schema, MBTilesFile mbtiles, MBtilesCache tileCache) {
        super(entry, null);
        this.mbtiles = mbtiles;
        this.schema = schema;
        this.tileCache = tileCache;
    }

    protected void addHints(Set<Hints.Key> hints) {
        hints.add(Hints.GEOMETRY_SIMPLIFICATION);
        hints.add(Hints.GEOMETRY_GENERALIZATION);
        hints.add(Hints.GEOMETRY_DISTANCE);
        hints.add((Hints.Key)Hints.GEOMETRY_CLIP);
        hints.add((Hints.Key)Hints.GEOMETRY_CLIP);
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        Filter f = query.getFilter();
        if (f == null || f.equals(Filter.INCLUDE)) {
            try {
                return new ReferencedEnvelope((org.opengis.geometry.Envelope)CRS.transform((org.opengis.geometry.Envelope)this.mbtiles.loadMetaData().getBounds(), (CoordinateReferenceSystem)MBTilesDataStore.DEFAULT_CRS));
            }
            catch (TransformException e) {
                throw new RuntimeException("Unable to retrieve bounds from mbtiles metadata", e);
            }
        }
        return null;
    }

    protected int getCountInternal(Query query) throws IOException {
        return -1;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.schema;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        try {
            long z = this.getTargetZLevel(query);
            List<RectangleLong> tileBounds = this.getTileBoundsFor(query, z);
            List<CompositeSimpleFeatureReader.ReaderSupplier> suppliers = tileBounds.stream().flatMap(tb -> this.getReaderSuppliersFor(z, (RectangleLong)tb).stream()).collect(Collectors.toList());
            Object reader = suppliers.isEmpty() ? DataUtilities.simple((FeatureReader)new EmptyFeatureReader((FeatureType)this.getSchema())) : new CompositeSimpleFeatureReader(this.getSchema(), suppliers);
            return reader;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected List<CompositeSimpleFeatureReader.ReaderSupplier> getReaderSuppliersFor(long z, RectangleLong tb) {
        ArrayList<CompositeSimpleFeatureReader.ReaderSupplier> result = new ArrayList<CompositeSimpleFeatureReader.ReaderSupplier>();
        Map<MBTilesTileLocation, SimpleFeatureCollection> memoryTiles = this.tileCache.getCachedFeatures(z, tb, this.getSchema().getTypeName());
        result.addAll(this.getMemorySuppliers(memoryTiles.values()));
        RectangleLong unreadRect = this.getUnreadLocationBounds(z, tb, memoryTiles.keySet());
        if (unreadRect != null && !unreadRect.isNull()) {
            result.add(this.getDatabaseSupplier(z, unreadRect, memoryTiles.keySet()));
        }
        return result;
    }

    protected RectangleLong getUnreadLocationBounds(long z, RectangleLong bounds, Set<MBTilesTileLocation> readLocations) {
        RectangleLong result = new RectangleLong();
        MBTilesTileLocation location = new MBTilesTileLocation(z, 0L, 0L);
        bounds.forEach((x, y) -> {
            location.setTileColumn(x);
            location.setTileRow(y);
            if (!readLocations.contains(location)) {
                result.expandToInclude(location);
            }
        });
        return result;
    }

    protected CompositeSimpleFeatureReader.ReaderSupplier getDatabaseSupplier(long z, RectangleLong unreadRect, Set<MBTilesTileLocation> skipLocations) {
        return () -> {
            try {
                MBTilesFile.TileIterator tiles = this.mbtiles.tiles(z, unreadRect.getMinX(), unreadRect.getMinY(), unreadRect.getMaxX(), unreadRect.getMaxY());
                return new MBTilesFeatureReader(tiles, this.getSchema(), this.tileCache, skipLocations);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
    }

    protected List<CompositeSimpleFeatureReader.ReaderSupplier> getMemorySuppliers(Collection<SimpleFeatureCollection> values) {
        return values.stream().map(fc -> () -> DataUtilities.reader((FeatureCollection)fc)).collect(Collectors.toList());
    }

    private long getTargetZLevel(Query query) throws SQLException {
        return Optional.ofNullable(query).map(Query::getHints).map(h -> {
            if (h.get((Object)Hints.GEOMETRY_GENERALIZATION) != null) {
                return h.get((Object)Hints.GEOMETRY_GENERALIZATION);
            }
            if (h.get((Object)Hints.GEOMETRY_SIMPLIFICATION) != null) {
                return h.get((Object)Hints.GEOMETRY_SIMPLIFICATION);
            }
            return h.get((Object)Hints.GEOMETRY_DISTANCE);
        }).map(d -> {
            try {
                return this.mbtiles.getZoomLevel((Double)d);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to compute the best zoom level for rendering", e);
            }
        }).orElse(this.mbtiles.maxZoom());
    }

    protected List<RectangleLong> getTileBoundsFor(Query query, long z) throws SQLException {
        RectangleLong levelBounds = this.mbtiles.getTileBounds(z, false);
        if (query == null || query.getFilter() == null || query.getFilter() == Filter.INCLUDE) {
            return Collections.singletonList(levelBounds);
        }
        List rectangles = Optional.ofNullable(ExtractMultiBoundsFilterVisitor.getBounds(query.getFilter())).map(o -> o.stream()).orElse(Stream.empty()).filter(e -> !Double.isInfinite(e.getWidth())).map(e -> {
            try {
                return this.mbtiles.toTilesRectangle((Envelope)e, z);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }).map(tr -> tr.intersection(levelBounds)).collect(Collectors.toList());
        if (rectangles.isEmpty()) {
            return Collections.singletonList(levelBounds);
        }
        ArrayList<RectangleLong> result = new ArrayList<RectangleLong>();
        for (RectangleLong rect : rectangles) {
            if (result.isEmpty()) {
                result.add(rect);
                continue;
            }
            boolean mergedAny = false;
            do {
                mergedAny = false;
                ListIterator it = result.listIterator();
                while (it.hasNext()) {
                    RectangleLong next = (RectangleLong)it.next();
                    if (!next.intersects(rect)) continue;
                    it.remove();
                    rect.expandToInclude(next);
                    mergedAny = true;
                }
            } while (mergedAny);
            result.add(rect);
        }
        return result;
    }
}

