/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.mbtiles.MBTilesDataStore;
import org.geotools.mbtiles.MBTilesDataStoreFactory;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.referencing.CRS;
import org.geotools.util.URLs;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;

public class MBTilesDataStoreTest {
    private static final String DATATYPES = "datatypes";

    @Test
    public void testRasterTiles() throws Exception {
        File file = URLs.urlToFile((URL)this.getClass().getResource("mosaic/world_lakes.mbtiles"));
        Assert.assertThrows(DataSourceException.class, () -> new MBTilesDataStore(new MBTilesFile(file)));
    }

    @Test
    public void testPBFNoSchemaFile() throws Exception {
        File file = URLs.urlToFile((URL)this.getClass().getResource("planet.mbtiles"));
        Assert.assertThrows(DataSourceException.class, () -> new MBTilesDataStore(new MBTilesFile(file)));
    }

    @Test
    public void testDataTypes() throws IOException, FactoryException {
        File file = URLs.urlToFile((URL)this.getClass().getResource("datatypes.mbtiles"));
        MBTilesDataStore store = new MBTilesDataStore(new MBTilesFile(file));
        MatcherAssert.assertThat((Object)store.getTypeNames(), (Matcher)Matchers.arrayContaining((Object[])new String[]{DATATYPES}));
        ContentFeatureSource fs = store.getFeatureSource(DATATYPES);
        Assert.assertNotNull((Object)fs);
        SimpleFeatureType schema = fs.getSchema();
        MatcherAssert.assertThat((Object)schema.getTypeName(), (Matcher)Matchers.equalTo((Object)DATATYPES));
        GeometryDescriptor geom = schema.getGeometryDescriptor();
        MatcherAssert.assertThat((Object)geom.getLocalName(), (Matcher)Matchers.equalTo((Object)"the_geom"));
        MatcherAssert.assertThat((Object)geom.getCoordinateReferenceSystem(), (Matcher)Matchers.equalTo((Object)CRS.decode((String)"EPSG:3857", (boolean)true)));
        AttributeDescriptor bd = schema.getDescriptor("bool_true");
        MatcherAssert.assertThat((Object)bd.getType().getBinding(), (Matcher)Matchers.equalTo(Boolean.class));
        AttributeDescriptor fd = schema.getDescriptor("float_value");
        MatcherAssert.assertThat((Object)fd.getType().getBinding(), (Matcher)Matchers.equalTo(Number.class));
        AttributeDescriptor sd = schema.getDescriptor("string_value");
        MatcherAssert.assertThat((Object)sd.getType().getBinding(), (Matcher)Matchers.equalTo(String.class));
    }

    @Test
    public void readSingle() throws IOException, ParseException {
        File file = URLs.urlToFile((URL)this.getClass().getResource("datatypes.mbtiles"));
        MBTilesDataStore store = new MBTilesDataStore(new MBTilesFile(file));
        try (FeatureReader reader = store.getFeatureReader(new Query(DATATYPES), Transaction.AUTO_COMMIT);){
            Assert.assertTrue((boolean)reader.hasNext());
            SimpleFeature feature = (SimpleFeature)reader.next();
            MatcherAssert.assertThat((Object)feature.getAttribute("bool_false"), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)feature.getAttribute("bool_true"), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)((Number)feature.getAttribute("float_value")).doubleValue(), (Matcher)Matchers.closeTo((double)1.25, (double)0.01));
            MatcherAssert.assertThat((Object)feature.getAttribute("int64_value"), (Matcher)Matchers.equalTo((Object)123456789012345L));
            MatcherAssert.assertThat((Object)feature.getAttribute("neg_int_value"), (Matcher)Matchers.equalTo((Object)-1L));
            MatcherAssert.assertThat((Object)feature.getAttribute("pos_int_value"), (Matcher)Matchers.equalTo((Object)1L));
            MatcherAssert.assertThat((Object)feature.getAttribute("string_value"), (Matcher)Matchers.equalTo((Object)"str"));
            Point expected = (Point)new WKTReader().read("POINT (215246.671651058 6281289.23636264)");
            Point actual = (Point)feature.getDefaultGeometry();
            Assert.assertTrue((boolean)actual.equalsExact((Geometry)expected, 0.01));
        }
    }

    @Test
    public void testFactory() throws IOException {
        String namespaceURI = "http://geotools.org/mbtiles";
        File file = URLs.urlToFile((URL)this.getClass().getResource("datatypes.mbtiles"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(MBTilesDataStoreFactory.DBTYPE.key, "mbtiles");
        params.put(MBTilesDataStoreFactory.DATABASE.key, file);
        params.put(JDBCDataStoreFactory.NAMESPACE.key, namespaceURI);
        DataStore store = DataStoreFinder.getDataStore(params);
        Assert.assertNotNull((Object)store);
        MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(MBTilesDataStore.class));
        MatcherAssert.assertThat((Object)store.getTypeNames(), (Matcher)Matchers.arrayContaining((Object[])new String[]{DATATYPES}));
        SimpleFeatureType schema = store.getSchema(DATATYPES);
        NameImpl qualifiedName = new NameImpl(namespaceURI, DATATYPES);
        MatcherAssert.assertThat((Object)schema.getName(), (Matcher)Matchers.equalTo((Object)qualifiedName));
        SimpleFeatureType schemaFromQualified = (SimpleFeatureType)store.getSchema((Name)qualifiedName);
        MatcherAssert.assertThat((Object)schema, (Matcher)Matchers.equalTo((Object)schemaFromQualified));
    }
}

