/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.layer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicFill;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SemanticType;
import org.geotools.api.style.Stroke;
import org.geotools.mbstyle.MBStyle;
import org.geotools.mbstyle.layer.MBLayer;
import org.geotools.mbstyle.parse.MBFilter;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.mbstyle.transform.MBStyleTransformer;
import org.geotools.measure.Units;
import org.geotools.text.Text;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class LineMBLayer
extends MBLayer {
    private final JSONObject layout;
    private final JSONObject paint = super.getPaint();
    private static final String TYPE = "line";

    public LineMBLayer(JSONObject json) {
        super(json, new MBObjectParser(LineMBLayer.class));
        this.layout = super.getLayout();
    }

    @Override
    protected SemanticType defaultSemanticType() {
        return SemanticType.LINE;
    }

    public LineCap getLineCap() {
        return this.parse.getEnum(this.layout, "line-cap", LineCap.class, LineCap.BUTT);
    }

    public Expression lineCap() {
        return this.parse.enumToExpression(this.layout, "line-cap", LineCap.class, LineCap.BUTT);
    }

    public LineJoin getLineJoin() {
        return this.parse.getEnum(this.layout, "line-join", LineJoin.class, LineJoin.MITER);
    }

    public Expression lineJoin() {
        return this.parse.enumToExpression(this.layout, "line-join", LineJoin.class, LineJoin.MITER);
    }

    public Number getLineMiterLimit() {
        return this.parse.optional(Number.class, this.layout, "line-miter-limit", 2);
    }

    public Expression lineMiterLimit() {
        return this.parse.number(this.layout, "line-miter-limit", (Number)2);
    }

    public Number getLineRoundLimit() {
        return this.parse.optional(Number.class, this.layout, "line-round-limit", 1.05);
    }

    public Expression lineRoundLimit() {
        return this.parse.number(this.layout, "line-round-limit", (Number)1.05);
    }

    public Number getLineOpacity() {
        return this.parse.optional(Number.class, this.paint, "line-opacity", 1);
    }

    public Expression lineOpacity() {
        return this.parse.number(this.paint, "line-opacity", (Number)1);
    }

    public Color getLineColor() {
        if (this.paint.containsKey((Object)"line-pattern")) {
            return null;
        }
        return this.parse.convertToColor(this.parse.optional(String.class, this.paint, "line-color", "#000000"));
    }

    public Expression lineColor() {
        if (this.paint.containsKey((Object)"line-pattern")) {
            return null;
        }
        return this.parse.color(this.paint, "line-color", Color.BLACK);
    }

    public int[] getLineTranslate() {
        return this.parse.array(this.paint, "line-translate", new int[]{0, 0});
    }

    public Displacement lineTranslateDisplacement() {
        return this.parse.displacement(this.paint, "line-translate", this.sf.displacement((Expression)this.ff.literal(0), (Expression)this.ff.literal(0)));
    }

    public LineTranslateAnchor getLineTranslateAnchor() {
        return this.parse.getEnum(this.paint, "line-translate-anchor", LineTranslateAnchor.class, LineTranslateAnchor.MAP);
    }

    public Expression lineTranslateAnchor() {
        return this.parse.enumToExpression(this.paint, "line-translate-anchor", LineTranslateAnchor.class, LineTranslateAnchor.MAP);
    }

    public Number getLineWidth() {
        if (this.paint.get((Object)"line-width") != null) {
            return (Number)this.paint.get((Object)"line-width");
        }
        return 1;
    }

    public Expression lineWidth() {
        return this.parse.number(this.paint, "line-width", (Number)1);
    }

    public Number getLineGapWidth() {
        return this.parse.optional(Number.class, this.paint, "line-gap-width", 0);
    }

    public Expression lineGapWidth() {
        return this.parse.number(this.paint, "line-gap-width", (Number)0);
    }

    public Number getLineOffset() {
        return this.parse.optional(Number.class, this.paint, "line-offset", 0);
    }

    public Expression lineOffset() {
        return this.parse.number(this.paint, "line-offset", (Number)0);
    }

    public Number getLineBlur() {
        return this.parse.optional(Number.class, this.paint, "line-blur", 0);
    }

    public Expression lineBlur() {
        return this.parse.number(this.paint, "line-blur", (Number)0);
    }

    public List<Double> getLineDasharray() {
        ArrayList<Double> ret = new ArrayList<Double>();
        if (this.paint.get((Object)"line-dasharray") != null && this.paint.get((Object)"line-dasharray") instanceof JSONArray) {
            JSONArray a = (JSONArray)this.paint.get((Object)"line-dasharray");
            for (Object o : a) {
                Number n = (Number)o;
                ret.add(n.doubleValue());
            }
            return ret;
        }
        return null;
    }

    public List<Expression> lineDasharray() {
        Object defn = this.paint.get((Object)"line-dasharray");
        if (defn == null) {
            return null;
        }
        if (defn instanceof JSONArray) {
            JSONArray array = (JSONArray)defn;
            ArrayList<Expression> expressionList = new ArrayList<Expression>();
            for (int i = 0; i < array.size(); ++i) {
                expressionList.add(this.parse.number(array, i, (Number)0));
            }
            return expressionList;
        }
        if (defn instanceof JSONObject) {
            throw new MBFormatException("\"line-dasharray\": Functions not supported yet.");
        }
        throw new MBFormatException("\"line-dasharray\": Expected array or function, but was " + defn.getClass().getSimpleName());
    }

    public String getLinePattern() {
        return this.parse.optional(String.class, this.paint, "line-pattern", null);
    }

    public Expression linePattern() {
        return this.parse.string(this.paint, "line-pattern", null);
    }

    public boolean hasLinePattern() {
        return this.parse.isDefined(this.paint, "line-pattern");
    }

    public boolean hasLineGapWidth() {
        return this.parse.isDefined(this.paint, "line-gap-width");
    }

    @Override
    public List<FeatureTypeStyle> transformInternal(MBStyle styleContext) {
        MBStyleTransformer transformer = new MBStyleTransformer(this.parse);
        ArrayList<LineSymbolizer> symbolizers = new ArrayList<LineSymbolizer>();
        Stroke stroke = this.sf.stroke(this.lineColor(), this.lineOpacity(), this.lineWidth(), this.lineJoin(), this.lineCap(), null, null);
        stroke.setDashArray(this.scaleByWidth(this.lineDasharray(), this.lineWidth()));
        LineSymbolizer ls = this.sf.lineSymbolizer(this.getId(), null, this.sf.description(Text.text((String)TYPE), null), Units.PIXEL, stroke, this.lineOffset());
        if (this.hasLinePattern()) {
            ExternalGraphic eg = transformer.createExternalGraphicForSprite(this.linePattern(), styleContext);
            GraphicFill fill = this.sf.graphicFill(Arrays.asList(eg), this.lineOpacity(), null, null, null, null);
            stroke.setGraphicFill((Graphic)fill);
        }
        if (this.hasLineGapWidth()) {
            Add topOffset = this.ff.add(this.lineOffset(), (Expression)this.ff.divide((Expression)this.ff.add(this.lineGapWidth(), this.lineWidth()), (Expression)this.ff.literal(2)));
            Subtract bottomOffset = this.ff.subtract(this.lineOffset(), (Expression)this.ff.divide((Expression)this.ff.add(this.lineGapWidth(), this.lineWidth()), (Expression)this.ff.literal(2)));
            ls = this.sf.lineSymbolizer(this.getId(), null, this.sf.description(Text.text((String)TYPE), null), Units.PIXEL, stroke, (Expression)topOffset);
            LineSymbolizer bottomLine = this.sf.lineSymbolizer(this.getId(), null, this.sf.description(Text.text((String)TYPE), null), Units.PIXEL, stroke, (Expression)bottomOffset);
            symbolizers.add(bottomLine);
        }
        symbolizers.add(ls);
        MBFilter filter = this.getFilter();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule rule = this.sf.rule(this.getId(), null, null, 0.0, Double.POSITIVE_INFINITY, symbolizers, filter.filter());
        rules.add(rule);
        return Collections.singletonList(this.sf.featureTypeStyle(this.getId(), this.sf.description(Text.text((String)("MBStyle " + this.getId())), Text.text((String)("Generated for " + this.getSourceLayer()))), null, Collections.emptySet(), filter.semanticTypeIdentifiers(), rules));
    }

    private List<Expression> scaleByWidth(List<Expression> dasharray, Expression lineWidth) {
        if (dasharray == null) {
            return null;
        }
        if (lineWidth instanceof Literal && Double.valueOf(1.0).equals(lineWidth.evaluate(null, Double.class))) {
            return dasharray;
        }
        return dasharray.stream().map(dash -> this.ff.multiply(dash, lineWidth)).collect(Collectors.toList());
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static enum LineTranslateAnchor {
        MAP,
        VIEWPORT;

    }

    public static enum LineJoin {
        BEVEL,
        ROUND,
        MITER;

    }

    public static enum LineCap {
        BUTT,
        ROUND,
        SQUARE;

    }
}

