/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.layer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.ContrastMethod;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SemanticType;
import org.geotools.mbstyle.MBStyle;
import org.geotools.mbstyle.layer.MBLayer;
import org.geotools.mbstyle.parse.MBFilter;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.measure.Units;
import org.geotools.text.Text;
import org.json.simple.JSONObject;

public class RasterMBLayer
extends MBLayer {
    private final JSONObject paintJson;
    private static final String TYPE = "raster";

    public RasterMBLayer(JSONObject json) {
        super(json, new MBObjectParser(RasterMBLayer.class));
        this.paintJson = json.get((Object)"paint") != null ? (JSONObject)json.get((Object)"paint") : new JSONObject();
    }

    @Override
    protected SemanticType defaultSemanticType() {
        return SemanticType.RASTER;
    }

    public Expression opacity() {
        return this.parse.percentage(this.paintJson, "raster-opacity", 1);
    }

    public Number getOpacity() {
        return this.parse.optional(Number.class, this.paintJson, "raster-opacity", 1);
    }

    public Expression hueRotate() {
        return this.parse.number(this.paintJson, "raster-hue-rotate", (Number)0);
    }

    public Number getHueRotate() {
        return this.parse.optional(Number.class, this.paintJson, "raster-hue-rotate", 0);
    }

    public Expression brightnessMin() {
        return this.parse.number(this.paintJson, "raster-brightness-min", (Number)0);
    }

    public Number getBrightnessMin() {
        return this.parse.optional(Number.class, this.paintJson, "raster-brightness-min", 0);
    }

    public Expression brightnessMax() {
        return this.parse.number(this.paintJson, "raster-brightness-max", (Number)1);
    }

    public Number getBrightnessMax() {
        return this.parse.optional(Number.class, this.paintJson, "raster-brightness-max", 1);
    }

    public Expression saturation() {
        return this.parse.number(this.paintJson, "raster-saturation", (Number)0);
    }

    public Number getSaturation() {
        return this.parse.optional(Number.class, this.paintJson, "raster-saturation", 0);
    }

    public Expression contrast() {
        return this.parse.number(this.paintJson, "raster-contrast", (Number)0);
    }

    public Number getContrast() {
        return this.parse.optional(Number.class, this.paintJson, "raster-contrast", 0);
    }

    public Expression fadeDuration() {
        return this.parse.number(this.paintJson, "raster-fade-duration", (Number)300);
    }

    public Number getFadeDuration() {
        return this.parse.optional(Number.class, this.paintJson, "raster-fade-duration", 300);
    }

    @Override
    public List<FeatureTypeStyle> transformInternal(MBStyle styleContext) {
        ContrastEnhancement ce = this.sf.contrastEnhancement((Expression)this.ff.literal(1.0), ContrastMethod.NONE);
        RasterSymbolizer symbolizer = this.sf.rasterSymbolizer(this.getId(), null, this.sf.description(Text.text((String)TYPE), null), Units.PIXEL, this.opacity(), null, null, null, ce, null, null);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        MBFilter filter = this.getFilter();
        Rule rule = this.sf.rule(this.getId(), null, null, 0.0, Double.MAX_VALUE, Arrays.asList(symbolizer), filter.filter());
        rules.add(rule);
        return Collections.singletonList(this.sf.featureTypeStyle(this.getId(), this.sf.description(Text.text((String)("MBStyle " + this.getId())), Text.text((String)("Generated for " + this.getSourceLayer()))), null, Collections.emptySet(), filter.semanticTypeIdentifiers(), rules));
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

