/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.function;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.mbstyle.function.MBFunctionUtil;
import org.geotools.mbstyle.parse.MBFormatException;
import org.json.simple.JSONArray;

class MatchFunction
extends FunctionExpressionImpl {
    public static final FunctionName NAME = new FunctionNameImpl("match", new String[0]);

    MatchFunction() {
        super(NAME);
    }

    public void setParameters(List<Expression> params) {
        this.params = new ArrayList<Expression>(params);
    }

    public Object evaluate(Object feature) {
        Object inputType = ((Expression)this.params.get(0)).evaluate(feature);
        if (inputType == null || !Number.class.isAssignableFrom(inputType.getClass()) && !String.class.isAssignableFrom(inputType.getClass())) {
            throw new MBFormatException(String.format("MBDecision \"match\" requires a number or string expression for input type, found %s", inputType != null ? inputType.getClass().getName() : null));
        }
        int labelIndex = 1;
        for (int outputIndex = 2; outputIndex < this.params.size(); outputIndex += 2) {
            Object label = ((Expression)this.params.get(labelIndex)).evaluate(feature);
            if (label != null) {
                JSONArray jsonArray;
                if (Number.class.isAssignableFrom(label.getClass()) || String.class.isAssignableFrom(label.getClass()) && MBFunctionUtil.argsEqual(label, inputType).booleanValue()) {
                    return ((Expression)this.params.get(outputIndex)).evaluate(feature);
                }
                if (JSONArray.class.isAssignableFrom(label.getClass()) && (jsonArray = (JSONArray)label).contains(inputType)) {
                    return ((Expression)this.params.get(outputIndex)).evaluate(feature);
                }
            }
            labelIndex += 2;
        }
        if (labelIndex < this.params.size()) {
            return ((Expression)this.params.get(labelIndex)).evaluate(feature);
        }
        return null;
    }
}

