/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.function;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.json.simple.JSONArray;

class ToColorFunction
extends FunctionExpressionImpl {
    final MBObjectParser parse = new MBObjectParser(ToColorFunction.class);
    public static final FunctionName NAME = new FunctionNameImpl("toColor", new String[0]);

    ToColorFunction() {
        super(NAME);
    }

    public void setParameters(List<Expression> params) {
        this.params = new ArrayList<Expression>(params);
    }

    public Object evaluate(Object feature) {
        Integer i = 1;
        while (i <= this.params.size() - 1) {
            JSONArray je;
            Object evaluation = ((Expression)this.params.get(i)).evaluate(feature);
            if (evaluation instanceof Color) {
                return evaluation;
            }
            if (evaluation instanceof JSONArray && ((je = (JSONArray)evaluation).size() == 3 || je.size() == 4)) {
                Long r = (Long)je.get(0);
                Long g = (Long)je.get(1);
                Long b = (Long)je.get(2);
                if (je.size() == 3) {
                    try {
                        Color c = new Color(r.intValue(), g.intValue(), b.intValue());
                        return c;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (je.size() == 4) {
                    Double a = (Double)je.get(3);
                    Integer alpha = Long.valueOf(Math.round(a * 255.0)).intValue();
                    try {
                        Color c = new Color(r.intValue(), g.intValue(), b.intValue(), alpha);
                        return c;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (evaluation instanceof String) {
                try {
                    return this.parse.convertToColor(evaluation.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        throw new IllegalArgumentException("No arguments provided to the \"toColor\" function can be converted to a Color value");
    }
}

