/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.mbstyle.expression.MBExpression;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.json.simple.JSONArray;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.identity.FeatureId;
import org.opengis.style.SemanticType;

public class MBFilter {
    public static final String TYPE_POINT = "Point";
    public static final String TYPE_LINE = "LineString";
    public static final String TYPE_POLYGON = "Polygon";
    protected final SemanticType semanticType;
    protected final MBObjectParser parse;
    protected final FilterFactory2 ff;
    protected final JSONArray json;

    public MBFilter(JSONArray json) {
        this(json, new MBObjectParser(MBFilter.class));
    }

    public MBFilter(JSONArray json, MBObjectParser parse) {
        this(json, parse, null);
    }

    public MBFilter(JSONArray json, MBObjectParser parse, SemanticType semanticType) {
        this.parse = parse == null ? new MBObjectParser(MBFilter.class) : new MBObjectParser(MBFilter.class, parse);
        this.ff = this.parse.getFilterFactory();
        this.json = json;
        this.semanticType = semanticType;
    }

    public Set<SemanticType> semanticTypeIdentifiers() {
        if (this.json == null || this.json.isEmpty()) {
            return this.semanticTypeIdentifiersDefaults();
        }
        Set<SemanticType> semanticTypes = this.semanticTypeIdentifiers(this.json);
        return semanticTypes.isEmpty() ? this.semanticTypeIdentifiersDefaults() : semanticTypes;
    }

    private Set<SemanticType> semanticTypeIdentifiersDefaults() {
        HashSet<SemanticType> defaults = new HashSet<SemanticType>();
        if (this.semanticType != null) {
            defaults.add(this.semanticType);
        }
        return defaults;
    }

    Set<SemanticType> semanticTypeIdentifiers(JSONArray array) {
        if (array == null || array.isEmpty()) {
            throw new MBFormatException("MBFilter expected");
        }
        String operator = this.parse.get(array, 0);
        if (("==".equals(operator) || "!=".equals(operator) || "in".equals(operator) || "!in".equals(operator)) && this.parse.isString(array, 1) && "$type".equals(this.parse.get(array, 1))) {
            return this.semanticTypeByGeometryType(array, operator);
        }
        if ("all".equals(operator)) {
            return this.semanticTypeAll(array);
        }
        if ("any".equals(operator)) {
            return this.semanticTypeAny(array);
        }
        if ("none".equals(operator)) {
            return this.semanticTypeNone(array);
        }
        return Collections.emptySet();
    }

    private Set<SemanticType> semanticTypeNone(JSONArray array) {
        HashSet<SemanticType> semanticTypes = new HashSet<SemanticType>(Arrays.asList(SemanticType.values()));
        for (int i = 1; i < array.size(); ++i) {
            Set<SemanticType> types = this.semanticTypeIdentifiers((JSONArray)array.get(i));
            semanticTypes.removeAll(types);
        }
        return semanticTypes;
    }

    private Set<SemanticType> semanticTypeAny(JSONArray array) {
        HashSet<SemanticType> semanticTypes = new HashSet<SemanticType>();
        for (int i = 1; i < array.size(); ++i) {
            Set<SemanticType> types = this.semanticTypeIdentifiers((JSONArray)array.get(i));
            semanticTypes.addAll(types);
        }
        return semanticTypes;
    }

    private Set<SemanticType> semanticTypeAll(JSONArray array) {
        HashSet<SemanticType> semanticTypes = new HashSet<SemanticType>();
        for (int i = 1; i < array.size(); ++i) {
            JSONArray alternative = (JSONArray)array.get(i);
            Set<SemanticType> types = this.semanticTypeIdentifiers(alternative);
            if (types.isEmpty()) continue;
            if (semanticTypes.isEmpty()) {
                semanticTypes.addAll(types);
                continue;
            }
            throw new MBFormatException("Only one \"all\" alternative may be a $type filter");
        }
        return semanticTypes;
    }

    private Set<SemanticType> semanticTypeByGeometryType(JSONArray array, String operator) {
        if ("in".equals(operator) || "==".equals(operator)) {
            HashSet<SemanticType> semanticTypes = new HashSet<SemanticType>();
            List types = array.subList(2, array.size());
            for (Object type : types) {
                if (type instanceof String) {
                    String jsonText = (String)type;
                    SemanticType semanticType = this.translateSemanticType(jsonText);
                    semanticTypes.add(semanticType);
                    continue;
                }
                throw new MBFormatException("[\"in\",\"$type\", ...] limited to Point, LineString, Polygon: " + type);
            }
            if ("==".equals(operator) && types.size() != 1) {
                throw new MBFormatException("[\"==\",\"$type\", ...] limited one geometry type, to test more than one use \"in\" operator.");
            }
            return semanticTypes;
        }
        if ("!in".equals(operator) || "!=".equals(operator)) {
            HashSet<SemanticType> semanticTypes = new HashSet<SemanticType>(Arrays.asList(SemanticType.values()));
            List types = array.subList(2, array.size());
            for (Object type : types) {
                if (type instanceof String) {
                    String jsonText = (String)type;
                    SemanticType semanticType = this.translateSemanticType(jsonText);
                    semanticTypes.remove(semanticType);
                    continue;
                }
                throw new MBFormatException("[\"!in\",\"$type\", ...] limited to Point, LineString, Polygon: " + type);
            }
            if ("!=".equals(operator) && types.size() != 1) {
                throw new MBFormatException("[\"!=\",\"$type\", ...] limited one geometry type, to test more than one use \"!in\" operator.");
            }
            return semanticTypes;
        }
        return Collections.emptySet();
    }

    private Filter translateType(String jsonText) {
        Function dimension = this.ff.function("dimension", new Expression[]{this.ff.function("geometry", new Expression[0])});
        switch (jsonText) {
            case "Point": {
                return this.ff.equals((Expression)dimension, (Expression)this.ff.literal(0));
            }
            case "LineString": {
                return this.ff.equals((Expression)dimension, (Expression)this.ff.literal(1));
            }
            case "Polygon": {
                return this.ff.and((Filter)this.ff.equals((Expression)dimension, (Expression)this.ff.literal(2)), (Filter)this.ff.not((Filter)this.ff.equals((Expression)this.ff.function("isCoverage", new Expression[0]), (Expression)this.ff.literal(true))));
            }
        }
        throw new MBFormatException("MBStyle restricted to testing Point, LineString, Polygon: " + jsonText);
    }

    private SemanticType translateSemanticType(String jsonText) {
        switch (jsonText) {
            case "Point": {
                return SemanticType.POINT;
            }
            case "LineString": {
                return SemanticType.LINE;
            }
            case "Polygon": {
                return SemanticType.POLYGON;
            }
        }
        return null;
    }

    public Filter filter() {
        if (this.json == null || this.json.isEmpty()) {
            return Filter.INCLUDE;
        }
        String operator = this.parse.get(this.json, 0);
        if (("==".equals(operator) || "!=".equals(operator) || "in".equals(operator) || "!in".equals(operator)) && this.parse.isString(this.json, 1) && "$type".equals(this.parse.get(this.json, 1))) {
            return this.filterByGeometryType(this.json, operator);
        }
        if (("==".equals(operator) || "!=".equals(operator) || "has".equals(operator) || "!has".equals(operator) || "in".equals(operator) || "!in".equals(operator)) && this.parse.isString(this.json, 1) && "$id".equals(this.parse.get(this.json, 1))) {
            return this.filterByFeatureIdentifier(this.json, operator);
        }
        if ("!has".equals(operator)) {
            String key = this.parse.get(this.json, 1);
            return this.ff.isNull((Expression)this.ff.property(key));
        }
        if ("has".equals(operator)) {
            String key = this.parse.get(this.json, 1);
            return this.ff.not((Filter)this.ff.isNull((Expression)this.ff.property(key)));
        }
        if ("==".equals(operator)) {
            return this.filterEqualTo(this.json);
        }
        if ("!=".equals(operator)) {
            return this.filterNotEqual(this.json);
        }
        if (">".equals(operator)) {
            return this.filterGreater(this.json);
        }
        if (">=".equals(operator)) {
            return this.filterGreaterOrEqual(this.json);
        }
        if ("<".equals(operator)) {
            return this.filterLess(this.json);
        }
        if ("<=".equals(operator)) {
            return this.filterLessOrEqual(this.json);
        }
        if ("in".equals(operator)) {
            return this.filterIn(this.json, true);
        }
        if ("!in".equals(operator)) {
            return this.filterIn(this.json, false);
        }
        if ("all".equals(operator)) {
            return this.filterAll(this.json);
        }
        if ("any".equals(operator)) {
            return this.filterAny(this.json);
        }
        if ("none".equals(operator)) {
            return this.filterNone(this.json);
        }
        if ("case".equals(operator)) {
            Expression caseExpr = MBExpression.transformExpression(this.json);
            return this.ff.equals(caseExpr, (Expression)this.ff.literal(true));
        }
        if ("coalesce".equals(operator)) {
            Expression coalesce = MBExpression.transformExpression(this.json);
            return this.ff.equals(coalesce, (Expression)this.ff.literal(true));
        }
        if ("match".equals(operator)) {
            Expression match = MBExpression.transformExpression(this.json);
            return this.ff.equals(match, (Expression)this.ff.literal(true));
        }
        if ("within".equals(operator)) {
            Expression within = MBExpression.transformExpression(this.json);
            return this.ff.equals(within, (Expression)this.ff.literal(true));
        }
        throw new MBFormatException("Data expression or filter \"" + operator + "\" invalid. It may be misspelled or not supported by this implementation:" + this.json);
    }

    private Filter filterNone(JSONArray array) {
        ArrayList<Not> none = new ArrayList<Not>();
        for (int i = 1; i < array.size(); ++i) {
            if (this.parse.isArray(array, i)) {
                MBFilter mbFilter = new MBFilter((JSONArray)array.get(i));
                Filter filter = mbFilter.filter();
                if (filter == Filter.INCLUDE) continue;
                none.add(this.ff.not(filter));
                continue;
            }
            throw new MBFormatException("None filter does not support: \"" + this.json.get(i) + "\"");
        }
        return this.ff.and(none);
    }

    private Filter filterAny(JSONArray array) {
        ArrayList<Filter> any = new ArrayList<Filter>();
        for (int i = 1; i < array.size(); ++i) {
            if (this.parse.isArray(array, i)) {
                MBFilter mbFilter = new MBFilter((JSONArray)array.get(i));
                Filter filter = mbFilter.filter();
                if (filter == Filter.INCLUDE) continue;
                any.add(filter);
                continue;
            }
            throw new MBFormatException("Any filter does not support: \"" + this.json.get(i) + "\"");
        }
        return this.ff.or(any);
    }

    private Filter filterAll(JSONArray array) {
        ArrayList<Filter> all = new ArrayList<Filter>();
        for (int i = 1; i < array.size(); ++i) {
            if (this.parse.isArray(array, i)) {
                MBFilter mbFilter = new MBFilter((JSONArray)array.get(i));
                Filter filter = mbFilter.filter();
                if (filter == Filter.INCLUDE) continue;
                all.add(filter);
                continue;
            }
            throw new MBFormatException("All filter does not support: \"" + this.json.get(i) + "\"");
        }
        return this.ff.and(all);
    }

    private Filter filterIn(JSONArray array, boolean in) {
        String key = this.parse.get(array, 1);
        Expression[] args = new Expression[array.size() - 1];
        args[0] = this.ff.property(key);
        for (int i = 1; i < args.length; ++i) {
            Expression expression;
            args[i] = expression = this.parse.string(array, i + 1);
        }
        Function function = this.ff.function("in", args);
        return this.ff.equals((Expression)function, (Expression)this.ff.literal(in));
    }

    private Filter filterByFeatureIdentifier(JSONArray array, String operator) {
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        for (Object value : array.subList(2, array.size())) {
            if (!(value instanceof String)) continue;
            String fid = (String)value;
            fids.add(this.ff.featureId(fid));
        }
        if ("has".equals(operator) || "in".equals(operator)) {
            return this.ff.id(fids);
        }
        if ("!has".equals(operator) || "!in".equals(operator)) {
            return this.ff.not((Filter)this.ff.id(fids));
        }
        throw new UnsupportedOperationException("$id \"" + operator + "\" not valid");
    }

    private Filter filterByGeometryType(JSONArray json, String operator) {
        ArrayList<Filter> typeFilters = new ArrayList<Filter>();
        List types = json.subList(2, json.size());
        for (Object type : types) {
            Filter typeFilter = null;
            if (type instanceof String) {
                typeFilter = this.translateType((String)type);
            }
            if (typeFilter == null) {
                throw new MBFormatException("\"$type\" limited to Point, LineString, Polygon: " + type);
            }
            typeFilters.add(typeFilter);
        }
        if ("==".equals(operator)) {
            if (typeFilters.size() != 1) {
                throw new MBFormatException("[\"==\",\"$type\", ...] limited one geometry type, to test more than one use \"in\" operator.");
            }
            return (Filter)typeFilters.get(0);
        }
        if ("!=".equals(operator)) {
            if (typeFilters.size() != 1) {
                throw new MBFormatException("[\"!=\",\"$type\", ...] limited one geometry type, to test more than one use \"!in\" operator.");
            }
            return this.ff.not((Filter)typeFilters.get(0));
        }
        if ("in".equals(operator)) {
            return this.ff.or(typeFilters);
        }
        if ("!in".equals(operator)) {
            return this.ff.not((Filter)this.ff.or(typeFilters));
        }
        throw new MBFormatException("Unsupported $type operator \"" + json + "\"");
    }

    private Filter filterEqualTo(JSONArray array) {
        if (array.size() != 3) {
            this.throwUnexpectedArgumentCount("==", 2);
        }
        Expression expression1 = this.comparisonExpression1(array);
        Expression expression2 = this.comparisonExpression2(array);
        return this.ff.equals(expression1, expression2);
    }

    private Filter filterNotEqual(JSONArray array) {
        if (array.size() != 3) {
            this.throwUnexpectedArgumentCount("!=", 2);
        }
        Expression expression1 = this.comparisonExpression1(array);
        Expression expression2 = this.comparisonExpression2(array);
        return this.ff.notEqual(expression1, expression2);
    }

    private Filter filterLessOrEqual(JSONArray array) {
        if (this.json.size() != 3) {
            this.throwUnexpectedArgumentCount("<=", 2);
        }
        Expression expression1 = this.comparisonExpression1(array);
        Expression expression2 = this.comparisonExpression2(array);
        return this.ff.lessOrEqual(expression1, expression2);
    }

    private Filter filterLess(JSONArray array) {
        if (this.json.size() != 3) {
            this.throwUnexpectedArgumentCount("<", 2);
        }
        Expression expression1 = this.comparisonExpression1(array);
        Expression expression2 = this.comparisonExpression2(array);
        return this.ff.less(expression1, expression2);
    }

    private Filter filterGreaterOrEqual(JSONArray array) {
        if (this.json.size() != 3) {
            this.throwUnexpectedArgumentCount(">=", 2);
        }
        Expression expression1 = this.comparisonExpression1(array);
        Expression expression2 = this.comparisonExpression2(array);
        return this.ff.greaterOrEqual(expression1, expression2);
    }

    private Filter filterGreater(JSONArray array) {
        if (this.json.size() != 3) {
            this.throwUnexpectedArgumentCount(">", 2);
        }
        Expression expression1 = this.comparisonExpression1(array);
        Expression expression2 = this.comparisonExpression2(array);
        return this.ff.greater(expression1, expression2);
    }

    private void throwUnexpectedArgumentCount(String expression, int argCount) throws MBFormatException {
        throw new MBFormatException(String.format("Expression \"%s\" should have exactly %d argument(s)", expression, argCount));
    }

    private Expression comparisonExpression1(JSONArray array) {
        if (this.parse.isString(array, 1)) {
            String key = this.parse.get(array, 1);
            return this.ff.property(key);
        }
        return this.parse.string(array, 1);
    }

    private Expression comparisonExpression2(JSONArray array) {
        if (this.parse.isString(array, 1)) {
            Object value = this.parse.value(array, 2);
            return this.ff.literal(value);
        }
        return this.parse.string(array, 2);
    }
}

