/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.layer;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.mbstyle.MBStyle;
import org.geotools.mbstyle.layer.MBLayer;
import org.geotools.mbstyle.parse.MBFilter;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.mbstyle.transform.MBStyleTransformer;
import org.geotools.measure.Units;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.text.Text;
import org.json.simple.JSONObject;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Description;
import org.opengis.style.Fill;
import org.opengis.style.GraphicFill;
import org.opengis.style.SemanticType;

public class FillExtrusionMBLayer
extends MBLayer {
    private JSONObject paint = this.paint();
    private static String TYPE = "fill-extrusion";

    public FillExtrusionMBLayer(JSONObject json) {
        super(json, new MBObjectParser(FillExtrusionMBLayer.class));
    }

    @Override
    protected SemanticType defaultSemanticType() {
        return SemanticType.POLYGON;
    }

    public Number getFillExtrusionOpacity() throws MBFormatException {
        return this.parse.optional(Double.class, this.paint, "fill-extrusion-opacity", 1.0);
    }

    public Expression fillExtrusionOpacity() throws MBFormatException {
        return this.parse.percentage(this.paint, "fill-extrusion-opacity", 1.0);
    }

    public Color getFillExtrusionColor() throws MBFormatException {
        return this.parse.optional(Color.class, this.paint, "fill-extrusion-color", Color.BLACK);
    }

    public Expression fillExtrusionColor() throws MBFormatException {
        return this.parse.color(this.paint, "fill-extrusion-color", Color.BLACK);
    }

    public int[] getFillExtrusionTranslate() throws MBFormatException {
        return this.parse.array(this.paint, "fill-extrusion-translate", new int[]{0, 0});
    }

    public Point fillExtrusionTranslate() {
        int[] translate = this.getFillExtrusionTranslate();
        return new Point(translate[0], translate[1]);
    }

    public TranslateAnchor getFillExtrusionTranslateAnchor() {
        Object value = this.paint.get((Object)"fill-extrusion-translate-anchor");
        if (value != null && "viewport".equalsIgnoreCase((String)value)) {
            return TranslateAnchor.VIEWPORT;
        }
        return TranslateAnchor.MAP;
    }

    public Expression getFillExtrusionPattern() throws MBFormatException {
        return this.parse.string(this.paint, "fill-extrusion-pattern", null);
    }

    public Number getFillExtrusionHeight() throws MBFormatException {
        return this.parse.optional(Double.class, this.paint, "fill-extrusion-height", 0.0);
    }

    public Expression fillExtrusionHeight() throws MBFormatException {
        return this.parse.percentage(this.paint, "fill-extrusion-height", 0.0);
    }

    public Number getFillExtrusionBase() throws MBFormatException {
        return this.parse.optional(Double.class, this.paint, "fill-extrusion-base", 0.0);
    }

    public Expression fillExtrusionBase() throws MBFormatException {
        return this.parse.percentage(this.paint, "fill-extrusion-base", 0.0);
    }

    @Override
    public List<FeatureTypeStyle> transformInternal(MBStyle styleContext) {
        org.geotools.styling.Fill fill;
        ArrayList<FeatureTypeStyle> fillExtrusion = new ArrayList<FeatureTypeStyle>();
        MBStyleTransformer transformer = new MBStyleTransformer(this.parse);
        if (this.getFillExtrusionPattern() != null) {
            ExternalGraphic eg = transformer.createExternalGraphicForSprite(this.getFillExtrusionPattern(), styleContext);
            Graphic gf = this.sf.graphicFill(Arrays.asList(eg), this.fillExtrusionOpacity(), null, null, null, null);
            fill = this.sf.fill((GraphicFill)gf, null, null);
        } else {
            fill = this.sf.fill(null, this.fillExtrusionColor(), this.fillExtrusionOpacity());
        }
        PolygonSymbolizer shadowSymbolizer = this.sf.createPolygonSymbolizer();
        PolygonSymbolizer sidesSymbolizer = this.sf.createPolygonSymbolizer();
        PolygonSymbolizer roofSymbolizer = this.sf.createPolygonSymbolizer();
        shadowSymbolizer.setName("shadow");
        shadowSymbolizer.setGeometry((Expression)this.ff.function("offset", new Expression[]{this.ff.property((String)null), this.ff.literal(0.005), this.ff.literal(-0.005)}));
        shadowSymbolizer.setDescription((Description)this.sf.description(Text.text((String)"fill"), null));
        shadowSymbolizer.setUnitOfMeasure(Units.PIXEL);
        shadowSymbolizer.setStroke(null);
        shadowSymbolizer.setFill((Fill)fill);
        shadowSymbolizer.setDisplacement(null);
        shadowSymbolizer.setPerpendicularOffset((Expression)this.ff.literal(0));
        sidesSymbolizer.setName("sides");
        sidesSymbolizer.setGeometry((Expression)this.ff.function("isometric", new Expression[]{this.ff.property((String)null), this.ff.literal((Object)this.fillExtrusionHeight())}));
        sidesSymbolizer.setDescription((Description)this.sf.description(Text.text((String)"fill"), null));
        sidesSymbolizer.setUnitOfMeasure(Units.PIXEL);
        sidesSymbolizer.setStroke(null);
        sidesSymbolizer.setFill((Fill)fill);
        sidesSymbolizer.setDisplacement(null);
        sidesSymbolizer.setPerpendicularOffset((Expression)this.ff.literal(0));
        roofSymbolizer.setName("roof");
        roofSymbolizer.setGeometry((Expression)this.ff.function("offset", new Expression[]{this.ff.property((String)null), this.ff.literal((Object)this.fillExtrusionBase()), this.ff.literal((Object)this.fillExtrusionHeight())}));
        roofSymbolizer.setDescription((Description)this.sf.description(Text.text((String)"fill"), null));
        roofSymbolizer.setUnitOfMeasure(Units.PIXEL);
        roofSymbolizer.setStroke(null);
        roofSymbolizer.setFill((Fill)fill);
        roofSymbolizer.setDisplacement(null);
        roofSymbolizer.setPerpendicularOffset((Expression)this.ff.literal(0));
        MBFilter filter = this.getFilter();
        Rule shadowRule = this.sf.rule(this.getId(), null, null, 0.0, Double.POSITIVE_INFINITY, Arrays.asList(shadowSymbolizer), filter.filter());
        Rule sidesRule = this.sf.rule(this.getId(), null, null, 0.0, Double.POSITIVE_INFINITY, Arrays.asList(sidesSymbolizer), filter.filter());
        Rule roofRule = this.sf.rule(this.getId(), null, null, 0.0, Double.POSITIVE_INFINITY, Arrays.asList(roofSymbolizer), filter.filter());
        FeatureTypeStyle shadow = this.sf.featureTypeStyle(this.getId(), (Description)this.sf.description(Text.text((String)("MBStyle " + this.getId())), Text.text((String)("Generated for " + this.getSourceLayer()))), null, Collections.emptySet(), filter.semanticTypeIdentifiers(), Arrays.asList(shadowRule));
        FeatureTypeStyle sides = this.sf.featureTypeStyle(this.getId(), (Description)this.sf.description(Text.text((String)("MBStyle " + this.getId())), Text.text((String)("Generated for " + this.getSourceLayer()))), null, Collections.emptySet(), filter.semanticTypeIdentifiers(), Arrays.asList(sidesRule));
        FeatureTypeStyle roof = this.sf.featureTypeStyle(this.getId(), (Description)this.sf.description(Text.text((String)("MBStyle " + this.getId())), Text.text((String)("Generated for " + this.getSourceLayer()))), null, Collections.emptySet(), filter.semanticTypeIdentifiers(), Arrays.asList(roofRule));
        fillExtrusion.add(shadow);
        fillExtrusion.add(sides);
        fillExtrusion.add(roof);
        return fillExtrusion;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static enum TranslateAnchor {
        MAP,
        VIEWPORT;

    }
}

