/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.expression;

import java.util.ArrayList;
import org.geotools.mbstyle.expression.MBExpression;
import org.geotools.mbstyle.parse.MBFormatException;
import org.json.simple.JSONArray;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class MBString
extends MBExpression {
    public MBString(JSONArray json) {
        super(json);
    }

    public Expression stringConcat() throws MBFormatException {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (int i = 1; i < this.json.size(); ++i) {
            Expression arg = this.parse.string(this.json, i);
            if (arg instanceof Literal) {
                arg = this.transformLiteral(arg);
                list.add(arg);
                continue;
            }
            list.add(arg);
        }
        Expression[] args = new Expression[list.size()];
        args = list.toArray(args);
        Function function = this.ff.function("Concatenate", args);
        return function;
    }

    public Expression stringDowncase() {
        if (this.parse.string(this.json, 1) != null) {
            Expression arg = this.parse.string(this.json, 1);
            if (arg instanceof Literal) {
                arg = this.transformLiteral(arg);
            }
            Function function = this.ff.function("strToLowerCase", new Expression[]{arg});
            return function;
        }
        throw new MBFormatException("Unable to downcase the value from " + this.parse.get(this.json, 1));
    }

    public Expression stringUpcase() {
        if (this.parse.string(this.json, 1) != null) {
            Expression arg = this.parse.string(this.json, 1);
            if (arg instanceof Literal) {
                arg = this.transformLiteral(arg);
            }
            Function function = this.ff.function("strToUpperCase", new Expression[]{arg});
            return function;
        }
        throw new MBFormatException("Unable to upcase the value from " + this.parse.get(this.json, 1));
    }

    @Override
    public Expression getExpression() {
        switch (this.name) {
            case "concat": {
                return this.stringConcat();
            }
            case "downcase": {
                return this.stringDowncase();
            }
            case "upcase": {
                return this.stringUpcase();
            }
        }
        throw new MBFormatException(this.name + " is an unsupported string function");
    }
}

