/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.source;

import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.mbstyle.source.CanvasMBSource;
import org.geotools.mbstyle.source.GeoJsonMBSource;
import org.geotools.mbstyle.source.ImageMBSource;
import org.geotools.mbstyle.source.RasterMBSource;
import org.geotools.mbstyle.source.VectorMBSource;
import org.geotools.mbstyle.source.VideoMBSource;
import org.json.simple.JSONObject;

public abstract class MBSource {
    protected final JSONObject json;
    protected final MBObjectParser parser;

    public MBSource(JSONObject json) {
        this(json, null);
    }

    public MBSource(JSONObject json, MBObjectParser parser) {
        this.json = json != null ? json : new JSONObject();
        this.parser = parser != null ? parser : new MBObjectParser(MBSource.class);
    }

    public static MBSource create(JSONObject json, MBObjectParser parser) {
        if (!json.containsKey((Object)"type") || !(json.get((Object)"type") instanceof String)) {
            throw new MBFormatException("Mapbox source \"type\" is required and must be one of: vector, raster, geojson, image, video, or canvas.");
        }
        String type = ((String)json.get((Object)"type")).toLowerCase().trim();
        if ("vector".equalsIgnoreCase(type)) {
            return new VectorMBSource(json, parser);
        }
        if ("raster".equalsIgnoreCase(type)) {
            return new RasterMBSource(json, parser);
        }
        if ("geojson".equalsIgnoreCase(type)) {
            return new GeoJsonMBSource(json, parser);
        }
        if ("image".equalsIgnoreCase(type)) {
            return new ImageMBSource(json, parser);
        }
        if ("video".equalsIgnoreCase(type)) {
            return new VideoMBSource(json, parser);
        }
        if ("canvas".equalsIgnoreCase(type)) {
            return new CanvasMBSource(json, parser);
        }
        throw new MBFormatException("Mapbox source \"type\" is required and must be one of: vector, raster, geojson, image, video, or canvas.");
    }

    public abstract String getType();
}

