/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.parse;

import java.awt.Color;
import java.awt.RenderingHints;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.mbstyle.expression.MBExpression;
import org.geotools.mbstyle.layer.LineMBLayer;
import org.geotools.mbstyle.parse.MBFilter;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBFunction;
import org.geotools.styling.Displacement;
import org.geotools.styling.StyleFactory2;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class MBObjectParser {
    final Class<?> context;
    final FilterFactory2 ff;
    final StyleFactory2 sf;
    private static final Logger LOGGER = Logging.getLogger(MBObjectParser.class);

    public MBObjectParser(Class<?> context) {
        this.context = context;
        this.sf = (StyleFactory2)CommonFactoryFinder.getStyleFactory();
        this.ff = CommonFactoryFinder.getFilterFactory2();
    }

    public MBObjectParser(Class<MBFilter> context, MBObjectParser parse) {
        this.context = context;
        this.sf = parse == null ? (StyleFactory2)CommonFactoryFinder.getStyleFactory() : parse.getStyleFactory();
        this.ff = parse == null ? CommonFactoryFinder.getFilterFactory2() : parse.getFilterFactory();
    }

    public FilterFactory2 getFilterFactory() {
        return this.ff;
    }

    public StyleFactory2 getStyleFactory() {
        return this.sf;
    }

    public JSONObject paint(JSONObject layer) {
        if (layer.containsKey((Object)"paint")) {
            Object paint = layer.get((Object)"paint");
            if (paint == null) {
                String type = this.get(layer, "type", "layer");
                throw new MBFormatException(type + " paint requires JSONObject");
            }
            if (paint instanceof JSONObject) {
                return (JSONObject)paint;
            }
            String type = this.get(layer, "type", "layer");
            throw new MBFormatException(type + " paint requires JSONObject");
        }
        return new JSONObject();
    }

    public JSONObject layout(JSONObject layer) {
        if (layer.containsKey((Object)"layout")) {
            Object layout = layer.get((Object)"layout");
            if (layout == null) {
                String type = this.get(layer, "type", "layer");
                throw new MBFormatException(type + " layout requires JSONObject");
            }
            if (layout instanceof JSONObject) {
                return (JSONObject)layout;
            }
            String type = this.get(layer, "type", "layer");
            throw new MBFormatException(type + " paint requires JSONObject");
        }
        return new JSONObject();
    }

    public JSONObject getJSONObject(JSONObject json, String name) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name required for json object access");
        }
        if (json.containsKey((Object)name) && json.get((Object)name) instanceof JSONObject) {
            return (JSONObject)json.get((Object)name);
        }
        throw new MBFormatException("\"" + name + "\" requires JSONObject");
    }

    public JSONObject getJSONObject(JSONObject json, String name, JSONObject fallback) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name required for json object access");
        }
        if (json.containsKey((Object)name) && json.get((Object)name) instanceof JSONObject) {
            return (JSONObject)json.get((Object)name);
        }
        return fallback;
    }

    public JSONArray getJSONArray(JSONObject json, String name) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name required for json object access");
        }
        if (json.containsKey((Object)name) && json.get((Object)name) instanceof JSONArray) {
            return (JSONArray)json.get((Object)name);
        }
        throw new MBFormatException("\"" + name + "\" requires JSONArray");
    }

    public JSONArray getJSONArray(JSONObject json, String name, JSONArray fallback) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name required for json object access");
        }
        if (!json.containsKey((Object)name) || json.get((Object)name) == null) {
            return fallback;
        }
        if (json.containsKey((Object)name) && json.get((Object)name) instanceof JSONArray) {
            return (JSONArray)json.get((Object)name);
        }
        throw new MBFormatException("\"" + name + "\" requires JSONArray");
    }

    public Object value(JSONArray json, int index) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (index < json.size()) {
            Object value = json.get(index);
            if (value instanceof String || value instanceof Boolean || value instanceof Number) {
                return value;
            }
            if (value instanceof JSONArray) {
                return this.ff.literal((Object)MBExpression.transformExpression((JSONArray)value));
            }
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires [" + index + "] string, numeric or boolean");
    }

    public Object value(JSONObject json, String name) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (json.containsKey((Object)name)) {
            Object value = json.get((Object)name);
            if (value == null || value instanceof String || value instanceof Boolean || value instanceof Number) {
                return value;
            }
            throw new MBFormatException(this.context.getSimpleName() + " requires \"" + name + "\" literal required (was " + value.getClass().getSimpleName() + ")");
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires \"" + name + "\" required.");
    }

    public String get(JSONArray json, int index) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (index < json.size() && json.get(index) instanceof String) {
            return (String)json.get(index);
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires [" + index + "] string");
    }

    public String get(JSONObject json, String name) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name required for json access");
        }
        if (json.containsKey((Object)name) && json.get((Object)name) instanceof String) {
            return (String)json.get((Object)name);
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires \"" + name + "\" string field");
    }

    public String get(JSONObject json, String name, String fallback) {
        if (name == null || json == null) {
            return fallback;
        }
        if (!json.containsKey((Object)name) || json.get((Object)name) == null) {
            return fallback;
        }
        if (json.containsKey((Object)name) && json.get((Object)name) instanceof String) {
            return (String)json.get((Object)name);
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires \"" + name + "\" string field");
    }

    public double getNumeric(JSONArray json, int index) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (index < json.size() && json.get(index) instanceof Number) {
            return ((Number)json.get(index)).doubleValue();
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires [" + index + "] numeric value");
    }

    public Double getNumeric(JSONObject json, String name) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name required for json object access");
        }
        if (json.containsKey((Object)name) && json.get((Object)name) instanceof Number) {
            return ((Number)json.get((Object)name)).doubleValue();
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires \"" + name + "\" numeric field");
    }

    public Boolean getBoolean(JSONArray json, int index) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (index < json.size() && json.get(index) instanceof Boolean) {
            return (Boolean)json.get(index);
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires [" + index + "] boolean");
    }

    public Boolean getBoolean(JSONObject json, String name) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name required for json object access");
        }
        if (json.containsKey((Object)name) && json.get((Object)name) instanceof Boolean) {
            return (Boolean)json.get((Object)name);
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires \"" + name + "\" boolean field");
    }

    public Boolean getBoolean(JSONObject json, String name, Boolean fallback) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name required for json object access");
        }
        if (!json.containsKey((Object)name) || json.get((Object)name) == null) {
            return fallback;
        }
        if (json.get((Object)name) instanceof Boolean) {
            return (Boolean)json.get((Object)name);
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires \"" + name + "\" boolean field");
    }

    public <T> T require(Class<T> type, JSONArray json, int index) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (index >= 0 && index <= json.size() && type.isInstance(json.get(index))) {
            return type.cast(json.get(index));
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires [" + index + "] " + type.getSimpleName());
    }

    public <T> T require(Class<T> type, JSONObject json, String name) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name required for json object access");
        }
        if (json.containsKey((Object)name) && type.isInstance(json.get((Object)name))) {
            return type.cast(json.get((Object)name));
        }
        throw new MBFormatException(this.context.getSimpleName() + " requires \"" + name + "\" " + type.getSimpleName() + " field");
    }

    public <T> T optional(Class<T> type, JSONObject json, String name, T fallback) {
        if (json == null) {
            throw new IllegalArgumentException("json required");
        }
        if (name == null) {
            throw new IllegalArgumentException("name required for json object access");
        }
        if (!json.containsKey((Object)name)) {
            return fallback;
        }
        Object value = json.get((Object)name);
        if (!json.containsKey((Object)name) || json.get((Object)name) == null) {
            return fallback;
        }
        if (Number.class.isAssignableFrom(type)) {
            Object number = Converters.convert((Object)value, type);
            if (number == null) {
                throw new MBFormatException(this.context.getSimpleName() + " optional \"" + name + "\" expects " + type.getSimpleName() + " value");
            }
            return type.cast(number);
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new MBFormatException(this.context.getSimpleName() + " optional \"" + name + "\" expects " + type.getSimpleName() + " value");
    }

    public <T extends Enum<?>> T getEnum(JSONObject json, String name, Class<T> enumeration, T fallback) {
        Object value = json.get((Object)name);
        if (value == null) {
            return fallback;
        }
        if (value instanceof String) {
            String stringVal = (String)value;
            if ("".equals(stringVal.trim())) {
                return fallback;
            }
            for (Enum enumValue : (Enum[])enumeration.getEnumConstants()) {
                if (!enumValue.toString().equalsIgnoreCase(stringVal.trim())) continue;
                return (T)enumValue;
            }
            throw new MBFormatException("\"" + name + "\" contains invalid \"" + stringVal + "\" for enumeration " + enumeration.getSimpleName());
        }
        throw new MBFormatException("Conversion of \"" + name + "\" value from " + value.getClass().getSimpleName() + " to " + enumeration.getSimpleName() + " not supported.");
    }

    public <T extends Enum<?>> Expression enumToExpression(JSONObject json, String name, Class<T> enumeration, T fallback) {
        Object value = json.get((Object)name);
        if (value == null) {
            return this.constant(fallback.toString(), enumeration);
        }
        if (value instanceof String) {
            String stringVal = (String)value;
            if ("".equals(stringVal.trim())) {
                return this.constant(fallback.toString(), enumeration);
            }
            try {
                return this.constant(stringVal, enumeration);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "\"" + stringVal + "\" Exception parsing value \"" + stringVal + "\" for enumeration " + enumeration.getSimpleName() + ", falling back to default value.");
                return this.constant(fallback.toString(), enumeration);
            }
        }
        if (value instanceof JSONObject) {
            MBFunction function = new MBFunction(this, (JSONObject)value);
            return function.enumeration(enumeration);
        }
        throw new MBFormatException("Conversion of \"" + name + "\" value from " + value.getClass().getSimpleName() + " to " + enumeration.getSimpleName() + " not supported.");
    }

    public Literal constant(Object value, Class<? extends Enum<?>> enumeration) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String stringVal = (String)value;
            if ("".equals(stringVal.trim())) {
                return null;
            }
            Enum<?> enumValue = null;
            for (Enum<?> constant : enumeration.getEnumConstants()) {
                if (!constant.toString().equalsIgnoreCase(stringVal.trim())) continue;
                enumValue = constant;
                break;
            }
            if (enumValue == null) {
                throw new MBFormatException("\"" + stringVal + "\" invalid value for enumeration " + enumeration.getSimpleName());
            }
            if (enumValue instanceof LineMBLayer.LineJoin && LineMBLayer.LineJoin.MITER.equals(enumValue)) {
                return this.ff.literal((Object)"mitre");
            }
            String literal = enumValue.toString().toLowerCase();
            return this.ff.literal((Object)literal);
        }
        return null;
    }

    public JSONObject jsonObject(Object obj) throws MBFormatException {
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        if (obj == null) {
            throw new MBFormatException("Not a JSONObject: null");
        }
        throw new MBFormatException("Not a JSONObject: " + obj.toString());
    }

    public JSONObject jsonObect(Object obj, String message) throws MBFormatException {
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        throw new MBFormatException(message);
    }

    public JSONArray jsonArray(Object obj) throws MBFormatException {
        if (obj instanceof JSONArray) {
            return (JSONArray)obj;
        }
        if (obj == null) {
            throw new MBFormatException("Not a JSONArray: null");
        }
        throw new MBFormatException("Not a JSONArray: " + obj.toString());
    }

    public JSONArray jsonArray(Object obj, String message) throws MBFormatException {
        if (obj instanceof JSONArray) {
            return (JSONArray)obj;
        }
        throw new MBFormatException(message);
    }

    public <T> T[] array(Class<T> type, JSONObject json, String name, T[] fallback) {
        if (json.containsKey((Object)name)) {
            Object obj = json.get((Object)name);
            if (obj instanceof JSONArray) {
                JSONArray array = (JSONArray)obj;
                Object[] returnArray = (Object[])Array.newInstance(type, array.size());
                for (int i = 0; i < array.size(); ++i) {
                    Object value = array.get(i);
                    if (Number.class.isAssignableFrom(type) && value instanceof Number) {
                        if (type == Double.class) {
                            returnArray[i] = ((Number)value).doubleValue();
                            continue;
                        }
                        if (type == Integer.class) {
                            returnArray[i] = ((Number)value).intValue();
                            continue;
                        }
                    }
                    returnArray[i] = type.cast(array.get(i));
                }
                return returnArray;
            }
            throw new MBFormatException("\"" + name + "\" required as JSONArray of " + type.getSimpleName() + ": Unexpected " + obj.getClass().getSimpleName());
        }
        return fallback;
    }

    public int[] array(JSONObject json, String name, int[] fallback) {
        Integer[] array = this.array(Integer.class, json, name, fallback == null ? null : (Integer[])Arrays.stream(fallback).boxed().toArray(Integer[]::new));
        return array == null ? fallback : Arrays.stream(array).mapToInt(i -> i).toArray();
    }

    public double[] array(JSONObject json, String name, double[] fallback) {
        Double[] array = this.array(Double.class, json, name, fallback == null ? null : (Double[])Arrays.stream(fallback).boxed().toArray(Double[]::new));
        return array == null ? fallback : Arrays.stream(array).mapToDouble(i -> i).toArray();
    }

    public Expression percentage(JSONObject json, String name) throws MBFormatException {
        return this.percentage(json, name, null);
    }

    public Expression percentage(JSONObject json, String name, Number fallback) throws MBFormatException {
        if (json == null) {
            return fallback == null ? null : this.ff.literal((Object)fallback);
        }
        Object obj = json.get((Object)name);
        if (obj == null) {
            return this.ff.literal((Object)fallback);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return this.ff.literal((Object)str);
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return this.ff.literal((Object)number);
        }
        if (obj instanceof Boolean) {
            throw new MBFormatException("\"" + name + "\" percentage from boolean " + String.valueOf(obj) + " not supported, expected value between 0 and 1");
        }
        if (obj instanceof JSONObject) {
            MBFunction function = new MBFunction(this, (JSONObject)obj);
            return function.numeric();
        }
        if (obj instanceof JSONArray) {
            if (((JSONArray)obj).get(0) instanceof String) {
                return MBExpression.transformExpression((JSONArray)obj);
            }
            throw new MBFormatException(String.valueOf(this.context) + " number from JSONArray not supported");
        }
        throw new IllegalArgumentException("json contents invalid, \"" + name + "\" value limited to Number or JSONObject but was " + obj.getClass().getSimpleName());
    }

    private Expression font(JSONObject json, String name, String fallback) throws MBFormatException {
        if (json == null) {
            return fallback == null ? null : this.ff.literal((Object)fallback);
        }
        Object obj = json.get((Object)name);
        if (obj == null) {
            return this.ff.literal((Object)fallback);
        }
        if (obj instanceof JSONObject) {
            MBFunction function = new MBFunction(this, (JSONObject)obj);
            return function.font();
        }
        if (obj instanceof JSONArray) {
            if (((JSONArray)obj).get(0) instanceof String) {
                return MBExpression.transformExpression((JSONArray)obj);
            }
            throw new MBFormatException(String.valueOf(this.context) + " font from JSONArray not supported");
        }
        throw new IllegalArgumentException("json contents invalid font, " + name + " value expected JSONArray, or JSONObject but was " + obj.getClass().getSimpleName());
    }

    public Expression font(JSONObject json, String name) throws MBFormatException {
        return this.font(json, name, null);
    }

    private Expression number(String context, Object obj, Number fallback) {
        if (obj == null) {
            return fallback == null ? null : this.ff.literal((Object)fallback);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return this.ff.literal((Object)str);
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return this.ff.literal((Object)number.toString());
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            throw new MBFormatException(context + " number from Boolean " + bool + " not supported");
        }
        if (obj instanceof JSONObject) {
            MBFunction function = new MBFunction(this, (JSONObject)obj);
            return function.numeric();
        }
        if (obj instanceof JSONArray) {
            if (((JSONArray)obj).get(0) instanceof String) {
                return MBExpression.transformExpression((JSONArray)obj);
            }
            throw new MBFormatException(context + " number from JSONArray not supported");
        }
        throw new IllegalArgumentException("json contents invalid, " + context + " value limited to String, Number, Boolean or JSONObject but was " + obj.getClass().getSimpleName());
    }

    public Expression number(JSONArray json, int index) throws MBFormatException {
        return this.number(json, index, null);
    }

    public Expression number(JSONArray json, int index, Number fallback) throws MBFormatException {
        if (json == null) {
            return fallback == null ? null : this.ff.literal((Object)fallback);
        }
        Object obj = json.get(index);
        return this.number("index " + index, obj, fallback);
    }

    public Expression number(JSONObject json, String name) throws MBFormatException {
        return this.number(json, name, null);
    }

    public Expression number(JSONObject json, String name, Number fallback) throws MBFormatException {
        if (json == null) {
            return this.ff.literal((Object)fallback);
        }
        Object obj = json.get((Object)name);
        return this.number("\"" + name + "\"", obj, fallback);
    }

    private Expression string(String context, Object obj, String fallback) {
        if (obj == null) {
            return fallback == null ? null : this.ff.literal((Object)fallback);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return this.ff.literal((Object)str);
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return this.ff.literal((Object)number.toString());
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return this.ff.literal((Object)bool.toString());
        }
        if (obj instanceof JSONObject) {
            MBFunction function = new MBFunction(this, (JSONObject)obj);
            return function.function(String.class);
        }
        if (obj instanceof JSONArray) {
            if (((JSONArray)obj).get(0) instanceof String) {
                return MBExpression.transformExpression((JSONArray)obj);
            }
            throw new MBFormatException(context + " string from JSONArray not supported");
        }
        throw new IllegalArgumentException("json contents invalid, " + context + " value limited to String, Number, Boolean or JSONObject but was " + obj.getClass().getSimpleName());
    }

    public Expression string(JSONArray json, int index) {
        Object obj = json.get(index);
        if (obj == null) {
            return this.ff.literal(null);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return this.ff.literal((Object)str);
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return this.ff.literal((Object)number);
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return this.ff.literal((Object)bool);
        }
        if (obj instanceof JSONObject) {
            MBFunction function = new MBFunction(this, (JSONObject)obj);
            return function.function(String.class);
        }
        if (obj instanceof JSONArray) {
            JSONArray array = (JSONArray)obj;
            if (this.isString(array, 0)) {
                String expressionName = this.get(array, 0);
                if (MBExpression.canCreate(expressionName)) {
                    return MBExpression.transformExpression(array);
                }
                throw new MBFormatException(String.valueOf(this.context) + " string unavailable: data expression \"" + expressionName + "\" invalid. It may be misspelled or not supported by this implementation");
            }
            throw new MBFormatException(String.valueOf(this.context) + " string unavailable: Conversion from a JSONArray not a supported: " + String.valueOf(array));
        }
        throw new IllegalArgumentException(String.valueOf(this.context) + " string unavailable: json contents invalid - value limited to String, Number, Boolean, JSONArray or JSONObject but was " + obj.getClass().getSimpleName());
    }

    public Expression string(JSONObject json, String name, String fallback) throws MBFormatException {
        if (json == null) {
            return fallback == null ? null : this.ff.literal((Object)fallback);
        }
        return this.string("\"" + name + "\"", json.get((Object)name), fallback);
    }

    public Expression color(JSONObject json, String name, Color fallback) throws MBFormatException {
        if (json.get((Object)name) == null) {
            return fallback == null ? null : this.ff.literal((Object)fallback);
        }
        Object obj = json.get((Object)name);
        return this.color("\"" + name + "\"", obj, fallback);
    }

    public Literal color(String color) {
        if (color == null) {
            return null;
        }
        return this.ff.literal((Object)this.convertToColor(color));
    }

    private Expression color(String context, Object obj, Color fallback) {
        if (obj == null) {
            return fallback == null ? null : this.ff.literal((Object)fallback);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return this.color(str);
        }
        if (obj instanceof Number) {
            throw new MBFormatException(context + " color from Number not supported");
        }
        if (obj instanceof Boolean) {
            throw new MBFormatException(context + "  color from Boolean not supported");
        }
        if (obj instanceof JSONObject) {
            MBFunction function = new MBFunction((JSONObject)obj);
            return function.color();
        }
        if (obj instanceof JSONArray) {
            if (((JSONArray)obj).get(0) instanceof String) {
                return MBExpression.transformExpression((JSONArray)obj);
            }
            throw new MBFormatException(context + " color from JSONArray not supported");
        }
        throw new IllegalArgumentException("json contents invalid, " + context + " limited to String or JSONObject but was " + obj.getClass().getSimpleName());
    }

    public Color convertToColor(String color) {
        if (color == null) {
            return null;
        }
        if ("red".equalsIgnoreCase(color)) {
            return Color.RED;
        }
        if ("blue".equalsIgnoreCase(color)) {
            return Color.BLUE;
        }
        if (color.startsWith("#") && color.length() == 4) {
            String[] split = color.split("");
            StringBuilder builder = new StringBuilder();
            builder.append(split[0]);
            Integer j = 1;
            while (j < split.length) {
                builder.append(split[j]).append(split[j]);
                Integer n = j;
                Integer n2 = j = Integer.valueOf(j + 1);
            }
            String cstring = builder.toString();
            return Color.decode(cstring);
        }
        Hints h = new Hints((RenderingHints.Key)Hints.COLOR_DEFINITION, (Object)"CSS");
        return (Color)Converters.convert((Object)color, Color.class, (Hints)h);
    }

    public Expression bool(JSONObject json, String name, boolean fallback) throws MBFormatException {
        if (json.get((Object)name) == null) {
            return this.ff.literal(fallback);
        }
        Object obj = json.get((Object)name);
        if (obj instanceof String) {
            String str = (String)obj;
            return this.ff.literal((Object)str);
        }
        if (obj instanceof Number) {
            throw new UnsupportedOperationException("\"" + name + "\": boolean from Number not supported");
        }
        if (obj instanceof Boolean) {
            Boolean b = (Boolean)obj;
            return this.ff.literal((Object)b);
        }
        if (obj instanceof JSONObject) {
            MBFunction function = new MBFunction(this, (JSONObject)obj);
            return function.function(Boolean.class);
        }
        if (obj instanceof JSONArray) {
            if (((JSONArray)obj).get(0) instanceof String) {
                return MBExpression.transformExpression((JSONArray)obj);
            }
            throw new MBFormatException(String.valueOf(this.context) + " boolean from JSONArray not supported");
        }
        throw new IllegalArgumentException("json contents invalid, \"" + name + "\" value limited to String, Boolean or JSONObject but was " + obj.getClass().getSimpleName());
    }

    public Displacement displacement(JSONObject json, String name, Displacement fallback) {
        Object defn = json.get((Object)name);
        if (defn == null) {
            return fallback;
        }
        if (defn instanceof JSONArray) {
            JSONArray array = (JSONArray)defn;
            return this.sf.displacement(this.number(array, 0, (Number)0), this.number(array, 1, (Number)0));
        }
        if (defn instanceof JSONObject) {
            List<MBFunction> functionForEachDimension;
            MBFunction function = new MBFunction(this, (JSONObject)defn);
            if (!function.isArrayFunction()) {
                throw new MBFormatException("\"" + name + "\": Exception parsing displacement from Mapbox function: function values must all be arrays with length 2.");
            }
            try {
                functionForEachDimension = function.splitArrayFunction();
            }
            catch (Exception pe) {
                throw new MBFormatException("\"" + name + "\": Exception parsing displacement from Mapbox function: " + pe.getMessage(), pe);
            }
            if (functionForEachDimension.size() != 2) {
                throw new MBFormatException("\"" + name + "\": Exception parsing displacement from Mapbox function: function values must all be arrays with length 2.");
            }
            Expression xFn = functionForEachDimension.get(0).numeric();
            Expression yFn = functionForEachDimension.get(1).numeric();
            return this.sf.displacement(xFn, yFn);
        }
        throw new MBFormatException("\"" + name + "\": Expected array or function, but was " + defn.getClass().getSimpleName());
    }

    @Deprecated
    public boolean isPropertyDefined(JSONObject json, String propertyName) throws MBFormatException {
        return this.isDefined(json, propertyName);
    }

    public boolean isDefined(JSONObject json, String name) throws MBFormatException {
        return json.containsKey((Object)name) && json.get((Object)name) != null;
    }

    public boolean isDefined(JSONArray json, int index) throws MBFormatException {
        return index < json.size() && json.get(index) != null;
    }

    public boolean isString(JSONObject json, String name) throws MBFormatException {
        return json.containsKey((Object)name) && json.get((Object)name) != null && json.get((Object)name) instanceof String;
    }

    public boolean isString(JSONArray json, int index) throws MBFormatException {
        return index < json.size() && json.get(index) != null && json.get(index) instanceof String;
    }

    public boolean isNumeric(JSONObject json, String name) throws MBFormatException {
        return json.containsKey((Object)name) && json.get((Object)name) != null && json.get((Object)name) instanceof Number;
    }

    public boolean isNumeric(JSONArray json, int index) throws MBFormatException {
        return index < json.size() && json.get(index) != null && json.get(index) instanceof Number;
    }

    public boolean isBoolean(JSONObject json, String name) throws MBFormatException {
        return json.containsKey((Object)name) && json.get((Object)name) != null && json.get((Object)name) instanceof Boolean;
    }

    public boolean isBoolean(JSONArray json, int index) throws MBFormatException {
        return index < json.size() && json.get(index) != null && json.get(index) instanceof Boolean;
    }

    public boolean isArray(JSONObject json, String name) throws MBFormatException {
        return json.containsKey((Object)name) && json.get((Object)name) != null && json.get((Object)name) instanceof JSONArray;
    }

    public boolean isArray(JSONArray json, int index) throws MBFormatException {
        return index < json.size() && json.get(index) != null && json.get(index) instanceof JSONArray;
    }

    public boolean isObject(JSONObject json, String name) throws MBFormatException {
        return json.containsKey((Object)name) && json.get((Object)name) != null && json.get((Object)name) instanceof JSONObject;
    }

    public boolean isObject(JSONArray json, int index) throws MBFormatException {
        return index < json.size() && json.get(index) != null && json.get(index) instanceof JSONObject;
    }
}

