/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.layer;

import java.util.Collections;
import java.util.List;
import org.geotools.mbstyle.MBStyle;
import org.geotools.mbstyle.layer.BackgroundMBLayer;
import org.geotools.mbstyle.layer.CircleMBLayer;
import org.geotools.mbstyle.layer.FillExtrusionMBLayer;
import org.geotools.mbstyle.layer.FillMBLayer;
import org.geotools.mbstyle.layer.LineMBLayer;
import org.geotools.mbstyle.layer.RasterMBLayer;
import org.geotools.mbstyle.layer.SymbolMBLayer;
import org.geotools.mbstyle.parse.MBFilter;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleFactory2;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.style.SemanticType;

public abstract class MBLayer {
    protected final MBObjectParser parse;
    protected final FilterFactory2 ff;
    protected final StyleFactory2 sf;
    protected final JSONObject json;
    protected final String id;

    public MBLayer(JSONObject json, MBObjectParser parse) {
        this.json = json;
        this.parse = parse;
        this.ff = parse.getFilterFactory();
        this.sf = parse.getStyleFactory();
        this.id = (String)json.get((Object)"id");
    }

    public static MBLayer create(JSONObject layer) {
        if (layer.containsKey((Object)"type") && layer.get((Object)"type") instanceof String) {
            String type;
            switch (type = (String)layer.get((Object)"type")) {
                case "line": {
                    return new LineMBLayer(layer);
                }
                case "fill": {
                    return new FillMBLayer(layer);
                }
                case "raster": {
                    return new RasterMBLayer(layer);
                }
                case "circle": {
                    return new CircleMBLayer(layer);
                }
                case "background": {
                    return new BackgroundMBLayer(layer);
                }
                case "symbol": {
                    return new SymbolMBLayer(layer);
                }
                case "fill-extrusion": {
                    return new FillExtrusionMBLayer(layer);
                }
            }
            throw new MBFormatException("\"type\" " + type + " is not a valid layer type. Must be one of: background, fill, line, symbol, raster, circle, fill-extrusion");
        }
        throw new MBFormatException("\"type\" required to create layer.");
    }

    public abstract String getType();

    public JSONObject getMetadata() {
        return this.parse.getJSONObject(this.json, "metadata", new JSONObject());
    }

    public String getRef() {
        return this.parse.optional(String.class, this.json, "ref", null);
    }

    public JSONObject getJson() {
        return this.json;
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.parse.optional(String.class, this.json, "source", null);
    }

    public String getSourceLayer() {
        return this.parse.optional(String.class, this.json, "source-layer", null);
    }

    public int getMinZoom() {
        Integer min = this.parse.optional(Integer.class, this.json, "minzoom", null);
        return min == null ? Integer.MIN_VALUE : min;
    }

    public int getMaxZoom() {
        Integer max = this.parse.optional(Integer.class, this.json, "maxzoom", null);
        return max == null ? Integer.MAX_VALUE : max;
    }

    public MBFilter getFilter() {
        JSONArray array = this.parse.getJSONArray(this.json, "filter", null);
        MBFilter filter = new MBFilter(array, this.parse, this.defaultSemanticType());
        return filter;
    }

    abstract SemanticType defaultSemanticType();

    public Filter filter() {
        MBFilter mbFilter = this.getFilter();
        if (mbFilter == null) {
            return Filter.INCLUDE;
        }
        return mbFilter.filter();
    }

    public JSONObject getLayout() {
        return this.parse.layout(this.json);
    }

    public JSONObject layout() {
        return this.getLayout();
    }

    public JSONObject getPaint() {
        return this.parse.paint(this.json);
    }

    public Visibility getVisibility() {
        JSONObject layout = this.layout();
        return this.parse.getEnum(layout, "visibility", Visibility.class, Visibility.VISIBLE);
    }

    public boolean visibility() {
        return this.getVisibility() == Visibility.VISIBLE;
    }

    public JSONObject paint() {
        return this.getPaint();
    }

    public List<FeatureTypeStyle> transform(MBStyle styleContext, Double minScaleDenominator, Double maxScaleDenominator) {
        List<FeatureTypeStyle> style = this.transform(styleContext);
        if (style == null) {
            return Collections.emptyList();
        }
        for (FeatureTypeStyle fts : style) {
            for (Rule rule : fts.rules()) {
                if (minScaleDenominator != null) {
                    rule.setMinScaleDenominator(minScaleDenominator.doubleValue());
                }
                if (maxScaleDenominator == null) continue;
                rule.setMaxScaleDenominator(maxScaleDenominator.doubleValue());
            }
        }
        return style;
    }

    public final List<FeatureTypeStyle> transform(MBStyle styleContext) {
        MBLayer layer = this;
        if (!layer.visibility()) {
            return null;
        }
        return this.transformInternal(styleContext);
    }

    public abstract List<FeatureTypeStyle> transformInternal(MBStyle var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.json == null ? 0 : this.json.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MBLayer other = (MBLayer)obj;
        return !(this.json == null ? other.json != null : !this.json.equals((Object)other.json));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " id=" + this.id;
    }

    public static enum Visibility {
        VISIBLE,
        NONE;

    }
}

