/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.expression;

import org.geotools.mbstyle.expression.MBExpression;
import org.geotools.mbstyle.parse.MBFormatException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opengis.filter.expression.Expression;

public class MBTypes
extends MBExpression {
    public MBTypes(JSONArray json) {
        super(json);
    }

    public Expression typesArray() {
        return this.ff.function("mbType", this.exprList());
    }

    public Expression typesBoolean() {
        return this.ff.function("mbType", this.exprList());
    }

    private Expression typesLiteral() {
        if (this.json.size() == 2) {
            if (this.json.get(1) instanceof JSONObject) {
                JSONObject object = (JSONObject)this.json.get(1);
                return this.ff.literal((Object)object);
            }
            if (this.json.get(1) instanceof JSONArray) {
                JSONArray arr = (JSONArray)this.json.get(1);
                return this.ff.literal((Object)arr);
            }
            throw new MBFormatException("The \"literal\" expression requires a JSONObject or JSONArray but was " + String.valueOf(this.json.get(1).getClass()));
        }
        throw new MBFormatException("The \"literal\" expression requires exactly 1 argument");
    }

    public Expression typesNumber() {
        return this.ff.function("mbType", this.exprList());
    }

    public Expression typesObject() {
        return this.ff.function("mbType", this.exprList());
    }

    public Expression typesString() {
        return this.ff.function("mbType", this.exprList());
    }

    public Expression typesToBoolean() {
        return this.ff.function("toBool", new Expression[]{this.parse.string(this.json, 1)});
    }

    public Expression typesToColor() {
        return this.ff.function("toColor", this.exprList());
    }

    public Expression typesToNumber() {
        return this.ff.function("toNumber", this.exprList());
    }

    public Expression typesToString() {
        return this.ff.function("toString", new Expression[]{this.parse.string(this.json, 1)});
    }

    public Expression typesTypeOf() {
        Expression value = this.parse.string(this.json, 1);
        return this.ff.function("mbTypeOf", new Expression[]{value});
    }

    private Expression[] exprList() {
        Expression[] args = new Expression[this.json.size()];
        Integer i = 0;
        while (i <= this.json.size() - 1) {
            Expression obj;
            args[i.intValue()] = obj = this.parse.string(this.json, i);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return args;
    }

    @Override
    public Expression getExpression() throws MBFormatException {
        switch (this.name) {
            case "array": {
                return this.typesArray();
            }
            case "boolean": {
                return this.typesBoolean();
            }
            case "literal": {
                return this.typesLiteral();
            }
            case "number": {
                return this.typesNumber();
            }
            case "object": {
                return this.typesObject();
            }
            case "string": {
                return this.typesString();
            }
            case "to-boolean": {
                return this.typesToBoolean();
            }
            case "to-color": {
                return this.typesToColor();
            }
            case "to-number": {
                return this.typesToNumber();
            }
            case "to-string": {
                return this.typesToString();
            }
            case "typeof": {
                return this.typesTypeOf();
            }
        }
        throw new MBFormatException(this.name + " is an unsupported types expression");
    }
}

