/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionImpl;
import org.geotools.mbstyle.expression.MBColor;
import org.geotools.mbstyle.expression.MBDecision;
import org.geotools.mbstyle.expression.MBFeatureData;
import org.geotools.mbstyle.expression.MBHeatmap;
import org.geotools.mbstyle.expression.MBLookup;
import org.geotools.mbstyle.expression.MBMath;
import org.geotools.mbstyle.expression.MBRampsScalesCurves;
import org.geotools.mbstyle.expression.MBString;
import org.geotools.mbstyle.expression.MBTypes;
import org.geotools.mbstyle.expression.MBVariableBinding;
import org.geotools.mbstyle.expression.MBZoom;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.mbstyle.transform.MBStyleTransformer;
import org.json.simple.JSONArray;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public abstract class MBExpression
extends FunctionImpl {
    protected final JSONArray json;
    protected final String name;
    protected final FilterFactory2 ff;
    protected final MBObjectParser parse;
    protected final MBStyleTransformer transformer;
    public static final List<String> colors = Collections.unmodifiableList(Arrays.asList("rgb", "rgba", "to-rgba"));
    public static final List<String> decisions = Collections.unmodifiableList(Arrays.asList("!", "!=", "<", "<=", "==", ">", ">=", "all", "any", "case", "coalesce", "match"));
    public static final List featureData = Collections.unmodifiableList(Arrays.asList("geometry-type", "id", "properties"));
    public static final List heatMap = Collections.unmodifiableList(Arrays.asList("heatmap-density"));
    public static final List lookUp = Arrays.asList("at", "length", "has", "get");
    public static final List math = Arrays.asList("-", "*", "/", "%", "^", "+", "acos", "asin", "atan", "cos", "e", "ln", "ln2", "log10", "log2", "max", "min", "pi", "sin", "sqrt", "tan");
    public static final List ramps = Arrays.asList("interpolate", "step");
    public static final List string = Arrays.asList("concat", "downcase", "upcase");
    public static final List types = Arrays.asList("array", "boolean", "literal", "number", "object", "string", "to-boolean", "to-color", "to-number", "to-string", "typeof");
    public static final List variableBindings = Arrays.asList("let", "var");
    public static final List zoom = Arrays.asList("zoom");

    protected MBExpression(JSONArray json) {
        this.json = json;
        this.name = (String)json.get(0);
        this.ff = CommonFactoryFinder.getFilterFactory2();
        this.parse = new MBObjectParser(MBExpression.class);
        this.transformer = new MBStyleTransformer(this.parse);
    }

    public String getName() {
        return this.name;
    }

    public static MBExpression create(JSONArray json) {
        if (json.get(0) instanceof String) {
            String name = (String)json.get(0);
            if (colors.contains(name)) {
                return new MBColor(json);
            }
            if (decisions.contains(name)) {
                return new MBDecision(json);
            }
            if (featureData.contains(name)) {
                return new MBFeatureData(json);
            }
            if (heatMap.contains(name)) {
                return new MBHeatmap(json);
            }
            if (lookUp.contains(name)) {
                return new MBLookup(json);
            }
            if (math.contains(name)) {
                return new MBMath(json);
            }
            if (ramps.contains(name)) {
                return new MBRampsScalesCurves(json);
            }
            if (string.contains(name)) {
                return new MBString(json);
            }
            if (types.contains(name)) {
                return new MBTypes(json);
            }
            if (variableBindings.contains(name)) {
                return new MBVariableBinding(json);
            }
            if (zoom.contains(name)) {
                return new MBZoom(json);
            }
            throw new MBFormatException("Data expression \"" + name + "\" invalid. It may be misspelled or not supported by this implementation:" + String.valueOf(json));
        }
        throw new MBFormatException("Requires a string name of the data expression at position 0");
    }

    public static boolean canCreate(String name) {
        return name != null && (colors.contains(name) || decisions.contains(name) || featureData.contains(name) || heatMap.contains(name) || lookUp.contains(name) || math.contains(name) || ramps.contains(name) || string.contains(name) || types.contains(name) || variableBindings.contains(name) || zoom.contains(name));
    }

    public abstract Expression getExpression();

    public Expression transformLiteral(Expression ex) {
        String text = (String)ex.evaluate(null, String.class);
        ex = text.trim().isEmpty() ? this.ff.literal((Object)" ") : this.transformer.cqlExpressionFromTokens(text);
        return ex;
    }

    public static Expression transformExpression(JSONArray json) {
        return MBExpression.create(json).getExpression();
    }

    protected void throwUnexpectedArgumentCount(String expression, int argCount) throws MBFormatException {
        throw new MBFormatException(String.format("Expression \"%s\" should have exactly %d argument(s)", expression, argCount));
    }

    protected void throwInsufficientArgumentCount(String expression, int argCount) throws MBFormatException {
        throw new MBFormatException(String.format("Expression \"%s\" should have at least %d argument(s)", expression, argCount));
    }
}

